/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.classfile.java;

import com.wily.util.classfile.IMethodSignature;
import com.wily.util.classfile.ISlotSignature;
import com.wily.util.classfile.InvalidFieldDescriptorException;
import com.wily.util.classfile.InvalidMethodDescriptorException;
import com.wily.util.classfile.java.ClassFileFieldDescriptor;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.SimpleLocalizableMessage;
import java.util.StringTokenizer;
import java.util.Vector;

public class ClassFileMethodDescriptor
implements IMethodSignature {
    private static final String kInitialTypeList = "(";
    private String fMethodDescriptor;
    private Vector fArguments;
    private ClassFileFieldDescriptor fReturnValue;

    public ClassFileMethodDescriptor() {
        this.fArguments = new Vector();
        this.fReturnValue = ClassFileFieldDescriptor.getVoidDescriptor();
    }

    public ClassFileMethodDescriptor(String methodDescriptor) throws InvalidMethodDescriptorException {
        this.setMethodDescriptor(methodDescriptor);
    }

    protected void setMethodDescriptor(String methodDescriptor) throws InvalidMethodDescriptorException {
        this.fMethodDescriptor = methodDescriptor;
        this.parseDescriptor();
    }

    private void parseDescriptor() throws InvalidMethodDescriptorException {
        this.fArguments = new Vector();
        this.fReturnValue = null;
        if (this.fMethodDescriptor == null) {
            throw new InvalidMethodDescriptorException(new SimpleLocalizableMessage("Class_File_Method_Descriptor_Empty"), "");
        }
        StringTokenizer tokenizer = new StringTokenizer(this.fMethodDescriptor, kInitialTypeList, true);
        if (!tokenizer.hasMoreTokens()) {
            throw new InvalidMethodDescriptorException(new SimpleLocalizableMessage("Class_File_Method_Descriptor_Empty"), this.fMethodDescriptor);
        }
        if (!tokenizer.nextToken().equals(kInitialTypeList)) {
            throw new InvalidMethodDescriptorException(new FormattedLocalizableMessage("Class_File_Method_Descriptor_Missing_Start_Parameter_List", this.fMethodDescriptor), this.fMethodDescriptor);
        }
        try {
            try {
                ClassFileFieldDescriptor field;
                while ((field = new ClassFileFieldDescriptor(tokenizer)).isValid()) {
                    this.fArguments.addElement(field);
                }
            }
            catch (InvalidFieldDescriptorException ifde) {
                throw new InvalidMethodDescriptorException(new FormattedLocalizableMessage("Class_File_Method_Descriptor_Invalid_Parameter", this.fMethodDescriptor), this.fMethodDescriptor);
            }
            this.fReturnValue = new ClassFileFieldDescriptor(tokenizer, true);
            if (!this.fReturnValue.isValid()) {
                throw new InvalidMethodDescriptorException(new FormattedLocalizableMessage("Class_File_Method_Descriptor_Missing_Return_Type", this.fMethodDescriptor), this.fMethodDescriptor);
            }
        }
        catch (InvalidFieldDescriptorException ifde) {
            throw new InvalidMethodDescriptorException(new FormattedLocalizableMessage("Class_File_Method_Descriptor_Invalid_Return_Type", this.fMethodDescriptor), this.fMethodDescriptor);
        }
    }

    public int getArgumentCount() {
        return this.fArguments.size();
    }

    public ClassFileFieldDescriptor getArgumentAt(int index) {
        return (ClassFileFieldDescriptor)this.fArguments.elementAt(index);
    }

    public ClassFileFieldDescriptor getReturnType() {
        return this.fReturnValue;
    }

    public int getParameterCount() {
        return this.getArgumentCount();
    }

    public ISlotSignature getParameterSignatureByIndex(int index) {
        return this.getArgumentAt(index);
    }

    public ISlotSignature getReturnSlotSignature() {
        return this.getReturnType();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClassFileMethodDescriptor) {
            ClassFileMethodDescriptor desc = (ClassFileMethodDescriptor)obj;
            if (this.getArgumentCount() != desc.getArgumentCount()) {
                return false;
            }
            for (int i = 0; i < this.getArgumentCount(); ++i) {
                if (this.getArgumentAt(i).equals(desc.getArgumentAt(i))) continue;
                return false;
            }
            return this.getReturnType().equals(desc.getReturnType());
        }
        return false;
    }

    public int hashCode() {
        return this.fMethodDescriptor.hashCode();
    }

    public String toString() {
        return this.fMethodDescriptor;
    }

    public String getSignatureString() {
        int argumentCount = this.getArgumentCount();
        StringBuffer formatted = new StringBuffer(argumentCount * 30);
        formatted.append(kInitialTypeList);
        for (int i = 0; i < argumentCount; ++i) {
            ClassFileFieldDescriptor field = this.getArgumentAt(i);
            formatted.append(field.getSignatureString());
            if (i + 1 >= argumentCount) continue;
            formatted.append(", ");
        }
        formatted.append(")");
        return formatted.toString();
    }
}

