/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.tracer.discovery;

import com.wily.powerpack.websphereMQ.agent.extensions.tracer.TraceProperties;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.discovery.MQDiscoveryConstants;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.discovery.MQDiscoveryDataPacket;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.discovery.MQDiscoveryQM;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.discovery.QueuePacket;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.discovery.QueueRepositoryReader;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.Reflection;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.Iterator;
import java.util.Map;

public final class MQDiscoveryDataWriter
extends Thread
implements MQDiscoveryConstants {
    private IModuleFeedbackChannel logger = null;
    private static String queuename = TraceProperties.MQ_DISCOVERY_QUEUE_NAME_VALUE;
    private static Integer OPEN_WRITE_OPTIONS = new Integer(8240);
    private String agentName = null;
    private static Object writeQueue = null;
    private static MQDiscoveryDataWriter instance = null;
    private MQDiscoveryDataPacket discoveryDataPkt = null;
    private Map queuePackets = null;
    private int count = 0;

    public MQDiscoveryDataWriter(String agentName, String threadName, IModuleFeedbackChannel feedback) {
        super(threadName);
        this.logger = feedback;
        this.agentName = agentName;
        MQDiscoveryQM.setIModuleFeedbackChannel(this.logger);
        this.discoveryDataPkt = MQDiscoveryDataPacket.getInstance(agentName, this.logger);
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
        this.discoveryDataPkt.setAgentName(agentName);
    }

    public static synchronized MQDiscoveryDataWriter getInstance(String agentName, String threadName, IModuleFeedbackChannel feedback) {
        if (instance == null) {
            instance = new MQDiscoveryDataWriter(agentName, threadName, feedback);
        }
        return instance;
    }

    public void run() {
        this.logger.info(discoveryModule, "Started the autodiscovery writer thread ");
        Object mqDiscoveryQM = null;
        block8: while (true) {
            if (mqDiscoveryQM != null) {
                try {
                    this.logger.debug(discoveryModule, "Closing old autodiscovery queuemanager connection for writer");
                    Reflection.closeMQQueueManager(mqDiscoveryQM);
                }
                catch (Exception exception) {}
            }
            if ((mqDiscoveryQM = MQDiscoveryQM.establishAutoDiscoveryQM()) == null) continue;
            boolean successfulQueueConn = this.createQueueHandle(mqDiscoveryQM);
            if (successfulQueueConn) {
                while (true) {
                    boolean done;
                    if (!(done = this.writeQueuePacketsToMQMonitorAgents())) {
                        if (writeQueue == null) continue block8;
                        try {
                            Reflection.closeMQQueue(writeQueue);
                        }
                        catch (Exception exception) {}
                        continue block8;
                    }
                    try {
                        MQDiscoveryDataWriter.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        this.logger.debug(discoveryModule, "Autodiscover writer thread is interrupted in sleep. Shouldn't have happened, though no problem because of this. ");
                    }
                }
            }
            this.logger.error(discoveryModule, "Problem in getting queue connection for reading from autodiscover queue: " + TraceProperties.MQ_DISCOVERY_QUEUE_NAME_VALUE + " but, queue manager connection was fine. " + "Check if the queue exist in the queuemanager or queuename given " + "in the property files is correct. " + " Going to sleep for " + 60000 + " milliseconds before trying again.");
            try {
                MQDiscoveryDataWriter.sleep(60000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                this.logger.debug(discoveryModule, "MQ Discovery writer thread is interrupted in sleep. Shouldn't have happened, though no problem because of this. ");
                continue;
            }
            break;
        }
    }

    private synchronized boolean createQueueHandle(Object autoDiscoveryQM) {
        try {
            writeQueue = Reflection.createMQQueuePut(autoDiscoveryQM, queuename, OPEN_WRITE_OPTIONS);
            this.logger.info(discoveryModule, "Successful write connection to queue: " + queuename + " for autodiscovery");
            return true;
        }
        catch (Exception e) {
            this.logger.error(discoveryModule, "Problem in creating write connection to queue: " + queuename + " for autodiscovery. " + e.getMessage());
            this.logger.debug(discoveryModule, e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private synchronized boolean closeQueueHandle() {
        try {
            try {
                Reflection.closeMQQueue(writeQueue);
            }
            catch (Exception exception) {}
            this.logger.debug(discoveryModule, "Successful close connection to queue: " + queuename + " for autodiscovery");
            return true;
        }
        catch (Exception e) {
            this.logger.error(discoveryModule, "Problem in closing write connection of queue: " + queuename + " for autodiscovery. " + e.getMessage());
            this.logger.debug(discoveryModule, e.getMessage(), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeQueuePacketsToMQMonitorAgents() {
        String mqMonitorAgentName = "MQMonitor";
        int i = 0;
        this.queuePackets = QueueRepositoryReader.getQueuePackets();
        Iterator qPktIterator = this.queuePackets.keySet().iterator();
        while (qPktIterator.hasNext() && i < this.queuePackets.size()) {
            QueuePacket queuePacket = (QueuePacket)qPktIterator.next();
            if (!this.checkPacketToSend(queuePacket)) continue;
            boolean msgSentFlag = false;
            try {
                Object message = Reflection.createMessageForMQMonitorAgent(queuePacket, this.agentName);
                this.logger.debug(discoveryModule, "Sending autodiscovery message to " + mqMonitorAgentName + " with its own agentname: " + this.agentName);
                Object pmo = Reflection.getPMO();
                Reflection.setDiscoveryAccess(true);
                Object object = writeQueue;
                synchronized (object) {
                    msgSentFlag = Reflection.putMessageToQueue(writeQueue, message, pmo);
                }
                if (++i % 10 == 0) {
                    try {
                        MQDiscoveryDataWriter.sleep(300000L);
                    }
                    catch (InterruptedException interruptedException) {
                        this.logger.debug(discoveryModule, "Autodiscover writer thread is interrupted in sleep. Shouldn't have happened, though no problem because of this. ");
                    }
                }
            }
            catch (Exception e) {
                this.logger.error(discoveryModule, "Problem in sending autodiscovery message to queue: " + queuename + ". ");
                this.logger.debug(discoveryModule, e.getMessage(), (Throwable)e);
                return false;
            }
            if (msgSentFlag) {
                this.logger.debug(discoveryModule, "After Sending autodiscovery message to " + mqMonitorAgentName + " with its own agentname: " + this.agentName);
                continue;
            }
            this.logger.warn(discoveryModule, "Failed to send autodiscovery message to " + mqMonitorAgentName + " with its own agentname: " + this.agentName);
        }
        return true;
    }

    private boolean checkPacketToSend(QueuePacket qPacket) {
        boolean isReady = false;
        long currentTimeInMillis = System.currentTimeMillis();
        long timestampQueuePacketSent = (Long)this.queuePackets.get(qPacket);
        long elapsedTime = currentTimeInMillis - timestampQueuePacketSent;
        if (timestampQueuePacketSent == 0L) {
            this.queuePackets.put(qPacket, new Long(currentTimeInMillis));
            isReady = true;
        } else if (elapsedTime >= 3600000L) {
            int sentCount = qPacket.getSentCount();
            if (sentCount < 10) {
                qPacket.setSentCount(++sentCount);
                this.queuePackets.put(qPacket, new Long(currentTimeInMillis));
                isReady = true;
            } else {
                this.queuePackets.remove(qPacket);
            }
        }
        return isReady;
    }

    public static Object getWriteQueue() {
        return writeQueue;
    }
}

