/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.appmap.agent;

import com.wily.introscope.spec.agent.bizdef.IBizTrx;
import com.wily.introscope.spec.server.appmap.IAppMapOwner;
import com.wily.util.HashCodeUtils;

public class BizDef
implements IAppMapOwner {
    private static final BizDef kNullBizDef = new BizDef(null, 0L);
    private static final String kDelayedBizName = "PostParamDelayed";
    private static final BizDef kDelayedBizDef = new BizDef("PostParamDelayed", -1L);
    private final String fBizName;
    private final long fId;

    private BizDef(IBizTrx bizTrx) {
        if (bizTrx != null) {
            this.fBizName = bizTrx.getBizFullName();
            this.fId = bizTrx.getId();
        } else {
            this.fBizName = "Null";
            this.fId = 0L;
        }
    }

    private BizDef(String bizName, long id) {
        if (bizName != null) {
            this.fBizName = bizName;
            this.fId = id;
        } else {
            this.fBizName = "Null";
            this.fId = 0L;
        }
    }

    public long getId() {
        return this.fId;
    }

    public String getName() {
        return this.fBizName;
    }

    public static BizDef getInstance(IBizTrx bizTrx) {
        if (bizTrx == null) {
            return kNullBizDef;
        }
        return new BizDef(bizTrx);
    }

    public static BizDef getInstance(String bizName, long id) {
        if (bizName == null) {
            return kNullBizDef;
        }
        return new BizDef(bizName, id);
    }

    public static IAppMapOwner getNullInstance() {
        return kNullBizDef;
    }

    public String toString() {
        return "Owner: " + this.fBizName + "; type Business Transaction Component; id = " + this.fId;
    }

    public final boolean isNullInstance() {
        return this.equals(kNullBizDef);
    }

    public static IAppMapOwner getDelayedInstance() {
        return kDelayedBizDef;
    }

    public final boolean isDelayedInstance() {
        return this == kDelayedBizDef;
    }

    public boolean equals(Object b) {
        if (b == null) {
            return false;
        }
        if (!(b instanceof BizDef)) {
            return false;
        }
        BizDef other = (BizDef)b;
        if (this.fBizName == null) {
            return other.fBizName == null;
        }
        return this.fBizName.equals(other.fBizName) && this.fId == other.fId;
    }

    public int hashCode() {
        int result = 17;
        result = HashCodeUtils.accumulateHashCode((int)result, (Object)this.fBizName);
        result = HashCodeUtils.accumulateHashCode((int)result, (long)this.fId);
        return result;
    }
}

