/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.sysview.httptracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.sysview.httptracer.WSClientCorrelationTracer;
import com.wily.powerpack.sysview.httptracer.WSMUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;

public class HttpServletCorrelationTracer
extends WSClientCorrelationTracer {
    private static final String kCommunicationMethod = "Communication Method";
    private static final String kCommunicationMethodHTTPValue = "HTTP";

    public HttpServletCorrelationTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
    }

    public void ITracer_startTrace(int arg0, InvocationData data) {
        try {
            IModuleFeedbackChannel Logger = WSMUtils.getLogger();
            Logger.debug("HTTPServletCorrelationTracer start trace");
            Object aRequest = data.getInvocationParameterAsObject(0);
            Object header = WSMUtils.invokeMethodOnObject(aRequest, "getHeader", new Class[]{String.class}, new Object[]{"CorID"});
            CorrelationId correlationId = null;
            if (header == null || header.equals("")) {
                Logger.debug("HTTPServletCorrelationTracer found no correlation in the header. Creating new one.");
                correlationId = new CorrelationId();
            } else {
                if (Logger.isDebugEnabled()) {
                    Logger.debug("HTTPServletCorrelationTracer found correlation id in the http header:" + header.toString());
                }
                correlationId = new CorrelationId(header.toString());
            }
            if (Logger.isDebugEnabled()) {
                String corIdStr = "Couldn't be allocated.";
                if (correlationId != null) {
                    corIdStr = correlationId.getOutgoingCorrelationIdStrippedForHeader();
                }
                Logger.debug("HTTPServletCorrelationTracer correlation ID:" + corIdStr);
            }
            ComponentTracer componentTracer = this.getComponentTracer();
            try {
                String path = (String)WSMUtils.invokeMethodOnObject(aRequest, "getServletPath");
                if (path == null) {
                    path = "";
                }
                componentTracer.addExtraParameter("URL", path);
            }
            catch (Throwable t) {
                WSMUtils.getLogger().error("HTTPServletCorrelationTracer startTrace exception " + WSMUtils.dumpStackTrace(t));
            }
            try {
                componentTracer.addExtraParameter(kCommunicationMethod, kCommunicationMethodHTTPValue);
            }
            catch (Throwable t) {
                Logger.error("URLConnectionCorrelationTracer ITracer_finishTrace exception " + WSMUtils.dumpStackTrace(t));
            }
        }
        catch (Throwable t) {
            try {
                WSMUtils.getLogger().error("HTTPServletCorrelationTracer startTrace exception " + WSMUtils.dumpStackTrace(t));
            }
            catch (Throwable throwable) {}
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.calculateReentrancyLevel(ReentrancyLevel.kNone);
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

