/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives;

import com.wily.diagnos.cmp.directives.ADirective;
import com.wily.diagnos.cmp.directives.FlagName;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.directives.builder.TracerGroupBuilder;
import com.wily.diagnos.cmp.transform.builder.SubstituteStaticFieldTransformationBuilder;
import com.wily.util.classfile.FullyQualifiedFieldName;

public final class SubstituteStaticFieldIfFlaggedDirective
extends ADirective {
    private final FlagName fFlagName;
    private final FullyQualifiedFieldName fSourceField;
    private final FullyQualifiedFieldName fReplacementField;

    public SubstituteStaticFieldIfFlaggedDirective(String source, int lineNumber, FlagName flagName, FullyQualifiedFieldName sourceField, FullyQualifiedFieldName replacementField) {
        super(source, lineNumber);
        this.fFlagName = flagName;
        this.fSourceField = sourceField;
        this.fReplacementField = replacementField;
    }

    private FlagName getFlagName() {
        return this.fFlagName;
    }

    private FullyQualifiedFieldName getSourceField() {
        return this.fSourceField;
    }

    private FullyQualifiedFieldName getReplacementField() {
        return this.fReplacementField;
    }

    protected void applyToSettings(CompilerSettingsBuilder builder) {
        TracerGroupBuilder tracerGroupBuilder = builder.getTracerGroupBuilder(this.getFlagName());
        builder.addTransformation(new SubstituteStaticFieldTransformationBuilder(tracerGroupBuilder, this.getSourceField(), this.getReplacementField()));
        tracerGroupBuilder.setSource(this.getSource());
    }
}

