/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.stat.gatherer;

import com.wily.introscope.spec.metric.IncompatibleTypesException;
import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.introscope.stat.gatherer.ACombiningGatherer;
import com.wily.introscope.stat.timeslice.ATimeslicedValue;
import com.wily.introscope.stat.timeslice.IntegerTimeslicedValue;
import com.wily.wilyassert.Assertion;

public abstract class AIntegerCombiningGatherer
extends ACombiningGatherer {
    protected AIntegerCombiningGatherer(int typeCookie, long startTimestamp) {
        super(typeCookie, startTimestamp);
        Assertion.wilyAssert(false);
    }

    protected ATimeslicedValue doCombiningHarvest(long when, BlameStackSnapshot blameStack) {
        if (this.isDataAbsent()) {
            return new IntegerTimeslicedValue(this.getESETypeCookie(), this.getStartTimestampInMillis(), when, blameStack, true);
        }
        return new IntegerTimeslicedValue(this.getESETypeCookie(), this.getStartTimestampInMillis(), when, blameStack, this.getDataPointCount(), false, this.getIntValue(), this.getIntMinimum(), this.getIntMaximum());
    }

    protected final void doAcceptAggregateTimeslicedValue(IMetricDataValue newAggregate) throws IncompatibleTypesException {
        try {
            this.doAcceptAggregateIntegerTimeslicedValue((IntegerTimeslicedValue)newAggregate);
        }
        catch (ClassCastException cce) {
            String s = "Unknown";
            try {
                s = newAggregate.toString();
            }
            catch (Throwable throwable) {}
            throw new IncompatibleTypesException("Failed to cast the object: " + s + " (of type: " + newAggregate.getClass() + ") to an IntegerTimeslicedValue", cce);
        }
    }

    protected abstract void doAcceptAggregateIntegerTimeslicedValue(IntegerTimeslicedValue var1);

    public abstract int getIntValue();

    public abstract int getIntMinimum();

    public abstract int getIntMaximum();

    protected abstract void directSetIntMinimum(int var1);

    protected abstract void directSetIntMaximum(int var1);

    protected void syncSinglePointBounds(int value) {
        if (this.isFirstDataPoint()) {
            this.directSetIntMaximum(value);
            this.directSetIntMinimum(value);
        } else {
            if (value > this.getIntMaximum()) {
                this.directSetIntMaximum(value);
            }
            if (value < this.getIntMinimum()) {
                this.directSetIntMinimum(value);
            }
        }
    }

    protected void syncAggregateBounds(IntegerTimeslicedValue newAggregate) {
        if (this.isFirstDataPoint()) {
            this.directSetIntMaximum(newAggregate.getMaximum());
            this.directSetIntMinimum(newAggregate.getMinimum());
        } else {
            if (newAggregate.getMaximum() > this.getIntMaximum()) {
                this.directSetIntMaximum(newAggregate.getMaximum());
            }
            if (newAggregate.getMinimum() < this.getIntMinimum()) {
                this.directSetIntMinimum(newAggregate.getMinimum());
            }
        }
    }
}

