/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import com.wily.util.adt.ConcurrentThreadLocalHashMap;
import com.wily.util.adt.LeastRecentlyUsedCleaner;
import com.wily.util.adt.UsedCounterValue;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.heartbeat.WaitAndExecuteBehavior;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentLRUAgingHashMap<K, V>
extends ConcurrentThreadLocalHashMap<K, UsedCounterValue<V>> {
    private volatile long fUpdateAgingFrequency;
    private volatile IntervalHeartbeat fHeartbeat;
    private static final Module kModule = new Module("ConcurrentAgingThreadLocalHashMap");
    private volatile WaitAndExecuteBehavior agingBehavior;
    private final Object behaviorKillLock = new Object();
    private volatile int upperbound;
    private volatile int lowerbound;
    private volatile int maxSize;
    public AtomicInteger usedCount = new AtomicInteger(0);
    public AtomicBoolean ismaxUsedCount = new AtomicBoolean(false);
    private static final long serialVersionUID = 1L;

    public ConcurrentLRUAgingHashMap(IntervalHeartbeat beat, IModuleFeedbackChannel feedback, boolean useThreadLocal, int initialSize, int threadLocalSize, float loadFactor, long updateAgingFrequency, int numThreads) {
        super(feedback, useThreadLocal, useThreadLocal, initialSize, threadLocalSize, loadFactor, numThreads);
    }

    public ConcurrentLRUAgingHashMap(IntervalHeartbeat beat, IModuleFeedbackChannel feedback, boolean useThreadLocal, int maxsize) {
        this(beat, feedback, useThreadLocal, 750, 75, 0.75f, 15000L, 8);
        this.maxSize = maxsize;
        this.upperbound = (int)((double)maxsize * 0.8);
        this.lowerbound = (int)((double)maxsize * 0.4);
        this.startAging(beat, 15000L);
    }

    public ConcurrentLRUAgingHashMap(IModuleFeedbackChannel feedback, boolean useThreadLocal) {
        super(feedback, useThreadLocal, useThreadLocal);
    }

    public ConcurrentLRUAgingHashMap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAging(IntervalHeartbeat heartbeat, long updateAgingFrequency) {
        if (heartbeat != null) {
            Object object = this.behaviorKillLock;
            synchronized (object) {
                if (this.agingBehavior != null) {
                    this.agingBehavior.kill();
                }
                this.fHeartbeat = heartbeat;
                this.fUpdateAgingFrequency = updateAgingFrequency;
                this.agingBehavior = new LeastRecentlyUsedCleaner(this, this.fHeartbeat, this.fUpdateAgingFrequency, this.upperbound, this.lowerbound, "concurrentLRUAgingMap");
            }
        } else if (this.getFeedback().isDebugEnabled(kModule)) {
            this.getFeedback().debug(kModule, "Cannot Start Aging: heartbeat supplied is null");
        }
    }

    @Override
    public UsedCounterValue<V> get(Object key) {
        UsedCounterValue ret = (UsedCounterValue)super.get(key);
        return ret;
    }

    public V getUsed(K key) {
        UsedCounterValue result = (UsedCounterValue)super.get(key);
        if (result != null) {
            return (V)result.get(this);
        }
        return null;
    }

    @Override
    protected void onGet() {
    }

    @Override
    protected void onPut() {
    }

    public V putUsed(K key, V value) {
        UsedCounterValue<V> result = this.put(key, new UsedCounterValue<V>(value, this));
        if (result != null) {
            return result.get(this);
        }
        return null;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public synchronized boolean reInit() {
        for (Map.Entry entry : this.entrySet()) {
            UsedCounterValue value = (UsedCounterValue)entry.getValue();
            value.usedCount.set(0);
            entry.setValue(value);
        }
        this.ismaxUsedCount.set(false);
        this.usedCount.set(0);
        return true;
    }
}

