/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.webservices.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.IBlameComponent;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.soaextension.webmethods.webservices.nameformatter.WSClientNameFormatter;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class WSClient80NameFormatter
extends WSClientNameFormatter {
    public WSClient80NameFormatter(IAgent agent) {
        super(agent);
    }

    public String INameFormatter_format(String name, InvocationData data) {
        try {
            String wsname = (String)data.get("com.wily.soaextension.webmethods.webservices.NamespaceKey");
            String operation = (String)data.get("com.wily.soaextension.webmethods.webservices.OperationNameKey");
            if (wsname == null || operation == null) {
                Object idataObj = data.getInvocationParameterAsObject(0);
                Object[] objArr = new Object[]{idataObj, "wsdOperationName"};
                operation = WMUtils.invokeGetStringOnValuesEmulator(objArr);
                objArr[1] = "wsdName";
                String wsdName = WMUtils.getWsdNameForVersion8x();
                wsname = this.getWsName(data, operation, wsdName);
            }
            name = this.formatName(wsname, operation, name);
        }
        catch (Exception e) {
            WMUtils.handleError(this.getAgent(), "ERROR_IN_NAMEFORMATTER", e);
            WMUtils.getLogger().debug("Error in Nameformatter:" + e.getMessage());
        }
        return name;
    }

    public IBlameComponent getKey(IModuleFeedbackChannel imodulefeedbackchannel, String name, InvocationData data) {
        String wsname = (String)data.get("com.wily.soaextension.webmethods.webservices.NamespaceKey");
        String operation = (String)data.get("com.wily.soaextension.webmethods.webservices.OperationNameKey");
        if (wsname == null || operation == null) {
            try {
                Object idataObj = data.getInvocationParameterAsObject(0);
                Object[] objArr = new Object[]{idataObj, "wsdOperationName"};
                operation = WMUtils.invokeGetStringOnValuesEmulator(objArr);
                objArr[1] = "wsdName";
                String wsdName = WMUtils.getWsdNameForVersion8x();
                this.getWsName(data, operation, wsdName);
                data.put("com.wily.soaextension.webmethods.webservices.NamespaceKey", (Object)WMUtils.formatToBeResourceSafe(wsname));
                data.put("com.wily.soaextension.webmethods.webservices.OperationNameKey", (Object)operation);
            }
            catch (Exception e) {
                WMUtils.handleError(this.getAgent(), "ERROR_IN_NAMEFORMATTER", e);
                WMUtils.getLogger().debug("Error in Nameformatter:" + e.getMessage());
            }
        }
        try {
            return ABlameComponent.getArrayInstance((Object[])new Object[]{name, "WebServices", "Client", wsname, operation});
        }
        catch (Exception e) {
            imodulefeedbackchannel.error(e.getMessage());
            return null;
        }
    }
}

