/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.Struts2Monitoring;

import com.ca.apm.agent.Struts2Monitoring.Struts2ActionClampConfiguration;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;

public class Struts2NameFormatter
implements INameFormatter {
    private static IAgent fAgent;
    private static IModuleFeedbackChannel fModuleFeedback;
    private static final Module kModule;
    public static final String kAppNamePlaceHolder = "{appName}";
    public static final String kAppNameDefault = "Struts2 Application";
    public static final String kActionNamePlaceHolder = "{action}";
    public static final String kActionDefaultName = "Default";
    public static ConcurrentHashMap<String, HashSet<String>> appToActionMap;
    private Object monitor = new Object();

    static {
        kModule = new Module("Struts2Monitoring");
        appToActionMap = new ConcurrentHashMap();
    }

    public Struts2NameFormatter(IAgent agent) {
        fAgent = agent;
        fModuleFeedback = fAgent.IAgent_getModuleFeedback();
    }

    public String INameFormatter_format(String name, InvocationData data) {
        if (name == null) {
            fModuleFeedback.error("Invalid pbd syntax for metric expression of Struts2");
            return "UNKNOWN";
        }
        String appName = this.getAppNameFromInocationData(data);
        this.initializeAppActionClampSet(appName);
        name = name.replace(kAppNamePlaceHolder, appName);
        String actionName = this.getActionNameFromInvocationData(data);
        actionName = this.buildActionNameWithClampValidation(appName, actionName, data);
        name = name.replace(kActionNamePlaceHolder, actionName);
        return name;
    }

    public String getAppNameFromInocationData(InvocationData data) {
        String frontend;
        String appName = kAppNameDefault;
        if (data.hasFrontBoundary() && (frontend = data.getFrontBoundary()) != null && frontend.contains("Apps")) {
            String frontendSubstring = frontend.split("Apps\\|")[1];
            appName = frontendSubstring.substring(0, frontendSubstring.indexOf(124));
        }
        data.put(kAppNamePlaceHolder, (Object)appName);
        return appName;
    }

    public String getActionNameFromInvocationData(InvocationData data) {
        String serviceActionNameStr;
        block13: {
            serviceActionNameStr = "Action Name";
            Object serviceAction = null;
            if (data.getInvocationParameterCount() >= 3) {
                try {
                    serviceAction = data.getInvocationParameterAsObject(data.getInvocationParameterCount() - 1);
                    Method serviceActionMethod = serviceAction.getClass().getMethod("getName", null);
                    Object serviceActionName = serviceActionMethod.invoke(serviceAction, null);
                    if (serviceActionName != null && serviceActionName instanceof String) {
                        serviceActionNameStr = serviceActionName.toString();
                        break block13;
                    }
                    fModuleFeedback.warn("No Struts2 action name available.");
                }
                catch (SecurityException e) {
                    fModuleFeedback.error("Cannot retrieve Struts2 Action name " + e.getMessage());
                    if (fModuleFeedback.isDebugEnabled(kModule)) {
                        fModuleFeedback.debug(kModule, "Cannot retrieve Struts2 Action name ", (Throwable)e);
                    }
                    break block13;
                }
                catch (NoSuchMethodException e) {
                    fModuleFeedback.error("Cannot retrieve Struts2 Action name " + e.getMessage());
                    if (fModuleFeedback.isDebugEnabled(kModule)) {
                        fModuleFeedback.debug(kModule, "Cannot retrieve Struts2 Action name ", (Throwable)e);
                    }
                    break block13;
                }
                catch (IllegalArgumentException e) {
                    fModuleFeedback.error("Cannot retrieve Struts2 Action name " + e.getMessage());
                    if (fModuleFeedback.isDebugEnabled(kModule)) {
                        fModuleFeedback.debug(kModule, "Cannot retrieve Struts2 Action name ", (Throwable)e);
                    }
                    break block13;
                }
                catch (IllegalAccessException e) {
                    fModuleFeedback.error("Cannot retrieve Struts2 Action name " + e.getMessage());
                    if (fModuleFeedback.isDebugEnabled(kModule)) {
                        fModuleFeedback.debug(kModule, "Cannot retrieve Struts2 Action name ", (Throwable)e);
                    }
                    break block13;
                }
                catch (InvocationTargetException e) {
                    fModuleFeedback.error("Cannot retrieve Struts2 Action name " + e.getMessage());
                    if (fModuleFeedback.isDebugEnabled(kModule)) {
                        fModuleFeedback.debug(kModule, "Cannot retrieve Struts2 Action name ", (Throwable)e);
                    }
                    break block13;
                }
            }
            fModuleFeedback.error("Check the instrumented method in struts.pbd  (Should be serviceAction() of Dispatcher class)");
            return "UNKNOWN";
        }
        return serviceActionNameStr;
    }

    public void initializeAppActionClampSet(String appName) {
        if (!appToActionMap.containsKey(appName)) {
            appToActionMap.put(appName, new HashSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String buildActionNameWithClampValidation(String appName, String actionName, InvocationData data) {
        boolean normalized = false;
        HashSet<String> actionsForApp = appToActionMap.get(appName);
        if (!actionsForApp.contains(actionName)) {
            Object object = this.monitor;
            synchronized (object) {
                int actionsCount = actionsForApp.size();
                int clampValue = Struts2ActionClampConfiguration.getClampValue();
                if (actionsCount < clampValue) {
                    HashSet<String> actionsForAppCopy = new HashSet<String>(actionsForApp);
                    actionsForAppCopy.add(actionName);
                    if (actionsCount + 1 == clampValue) {
                        fModuleFeedback.warn("Absolute Struts2 Actions metric clamp of " + clampValue + " reached, no more metrics for new Actions of " + appName + " can be created. All actions will be reported as Default. If you wish to increase the clamp value, change the property -" + "introscope.agent.struts2.action.clamp");
                    }
                    appToActionMap.put(appName, actionsForAppCopy);
                } else {
                    normalized = true;
                }
            }
        }
        if (normalized) {
            data.put("Action Name Normalization", (Object)String.valueOf(true));
        }
        data.put(kActionNamePlaceHolder, (Object)actionName);
        return normalized ? kActionDefaultName : actionName;
    }
}

