/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.ds.file.fileSpec;

import com.wily.rave.agent.ds.file.fileSpec.AFileSpecRuntime;
import com.wily.rave.agent.ds.file.fileSpec.ZipEntryFileSpec;
import com.wily.rave.utils.TmpFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class ZipEntryFileSpecRuntime
extends AFileSpecRuntime {
    private static final String ZIP_ENTRY_FILE_SPEC_TMP_DIR_PROP;
    private static final String ZIP_ENTRY_FILE_SPEC_TMP_DIR_DEF_VALUE = ".";
    private static final int BUF_SIZE = 1024;
    private static int tmpFileNameCounter;
    private static File tmpDir;
    private ZipEntry entry;
    private ZipFile zipFile;
    private File tmpFile;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.wily.rave.agent.ds.file.fileSpec.ZipEntryFileSpecRuntime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ZIP_ENTRY_FILE_SPEC_TMP_DIR_PROP = String.valueOf(clazz.getName()) + ".tmpDir";
        tmpFileNameCounter = -1;
        String tmpDirName = System.getProperty(ZIP_ENTRY_FILE_SPEC_TMP_DIR_PROP, ZIP_ENTRY_FILE_SPEC_TMP_DIR_DEF_VALUE);
        tmpDir = new File(tmpDirName);
    }

    public ZipEntryFileSpecRuntime(ZipEntryFileSpec fSpec, ZipFile zipFile, ZipEntry entry) {
        super(fSpec);
        this.entry = entry;
        this.zipFile = zipFile;
    }

    public static void setTmpDirName(String tmpDirName) {
        tmpDir = new File(tmpDirName);
    }

    public File getFile() throws IOException {
        if (this.tmpFile == null) {
            this.tmpFile = ZipEntryFileSpecRuntime.getEntryFile(this.entry, this.zipFile);
        }
        return this.tmpFile;
    }

    public long length() throws IOException {
        return this.entry.getSize();
    }

    public long lastModified() throws IOException {
        long time = this.entry.getTime();
        return time > 0L ? time : 0L;
    }

    public boolean exists() throws IOException {
        return true;
    }

    public boolean isDirectory() throws IOException {
        return this.entry.isDirectory();
    }

    protected InputStream getInputStream() throws IOException {
        return this.zipFile.getInputStream(this.entry);
    }

    private static File getEntryFile(ZipEntry entry, ZipFile zipFile) throws IOException {
        File file;
        block2: {
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(zipFile.getInputStream(entry));
                file = ZipEntryFileSpecRuntime.getTmpFile(in);
                Object var3_4 = null;
                if (in == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var3_5 = null;
                    if (in == null) break block3;
                    in.close();
                }
                throw throwable;
            }
            in.close();
        }
        return file;
    }

    private static synchronized File createTmpFile() throws IOException {
        if (tmpDir.exists()) {
            if (tmpFileNameCounter == -1) {
                TmpFile.deleteAllFiles((File)tmpDir);
                tmpFileNameCounter = 0;
            }
        } else if (!tmpDir.mkdir()) {
            throw new IOException("Failed creating tmp directory " + tmpDir.getAbsolutePath());
        }
        File tmpFile = File.createTempFile("tmp_", String.valueOf(new Date().getTime()) + tmpFileNameCounter, tmpDir);
        TmpFile.regTmpFile((File)tmpFile);
        tmpFileNameCounter = tmpFileNameCounter == Integer.MAX_VALUE ? 0 : tmpFileNameCounter + 1;
        return tmpFile;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File getTmpFile(BufferedInputStream in) throws IOException {
        File file = null;
        BufferedOutputStream out = null;
        try {
            file = ZipEntryFileSpecRuntime.createTmpFile();
            out = new BufferedOutputStream(new FileOutputStream(file), 1024);
            byte[] data = new byte[1024];
            int count = in.read(data);
            while (count > 0) {
                ((OutputStream)out).write(data, 0, count);
                count = in.read(data);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            in.close();
            if (out == null) throw throwable;
            ((OutputStream)out).close();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        in.close();
        if (out == null) return file;
        ((OutputStream)out).close();
        return file;
    }
}

