/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class IdentityHashSet {
    private static final int kDefaultInitialCapacity = 11;
    private static final float kLoadFactor = 0.75f;
    private Entry[] fTable;
    private int fCount;

    public IdentityHashSet() {
        this(11);
    }

    public IdentityHashSet(int initialCapacity) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException("Capacity must be positive: " + initialCapacity);
        }
        this.fTable = new Entry[initialCapacity];
        this.fCount = 0;
    }

    public int size() {
        return this.fCount;
    }

    public boolean add(Object value) {
        Entry newEntry;
        int hashcode = System.identityHashCode(value);
        int index = (hashcode & Integer.MAX_VALUE) % this.fTable.length;
        Entry e = this.fTable[index];
        while (e != null) {
            if (e.fValue == value) {
                return false;
            }
            e = e.fNext;
        }
        e = this.fTable[index];
        this.fTable[index] = newEntry = new Entry(hashcode, value, e);
        ++this.fCount;
        if ((float)this.fCount > (float)this.fTable.length * 0.75f) {
            this.rehash();
        }
        return true;
    }

    public boolean remove(Object value) {
        int hashcode = System.identityHashCode(value);
        int index = (hashcode & Integer.MAX_VALUE) % this.fTable.length;
        Entry previous = null;
        Entry e = this.fTable[index];
        while (e != null) {
            if (e.fValue == value) {
                if (previous == null) {
                    this.fTable[index] = e.fNext;
                } else {
                    previous.fNext = e.fNext;
                }
                --this.fCount;
                return true;
            }
            previous = e;
            e = e.fNext;
        }
        return false;
    }

    public boolean contains(Object value) {
        int hashcode = System.identityHashCode(value);
        Entry e = this.fTable[(hashcode & Integer.MAX_VALUE) % this.fTable.length];
        while (e != null) {
            if (e.fValue == value) {
                return true;
            }
            e = e.fNext;
        }
        return false;
    }

    private void rehash() {
        Entry[] newTable = new Entry[this.fTable.length * 2 + 1];
        int i = 0;
        while (i < this.fTable.length) {
            Entry e = this.fTable[i];
            Entry nextE = null;
            while (e != null) {
                Entry newNext;
                nextE = e.fNext;
                int newIndex = (e.fHashcode & Integer.MAX_VALUE) % newTable.length;
                e.fNext = newNext = newTable[newIndex];
                newTable[newIndex] = e;
                e = nextE;
            }
            ++i;
        }
        this.fTable = newTable;
    }

    public Iterator iterator() {
        return new IdentityHashSetIterator();
    }

    private static final class Entry {
        final int fHashcode;
        final Object fValue;
        Entry fNext;

        private Entry(int hashcode, Object value, Entry next) {
            this.fHashcode = hashcode;
            this.fValue = value;
            this.fNext = next;
        }
    }

    private class IdentityHashSetIterator
    implements Iterator {
        private int currentPos = 0;
        private Entry lastEntry;
        private int visited = 0;

        private IdentityHashSetIterator() {
        }

        public boolean hasNext() {
            return this.visited < IdentityHashSet.this.size() && this.currentPos < IdentityHashSet.this.fTable.length;
        }

        public Object next() {
            if (this.visited >= IdentityHashSet.this.size() || this.currentPos >= IdentityHashSet.this.fTable.length) {
                throw new NoSuchElementException();
            }
            Entry entry = null;
            if (this.lastEntry != null) {
                entry = this.lastEntry.fNext;
            }
            while (entry == null && this.currentPos < IdentityHashSet.this.fTable.length) {
                entry = IdentityHashSet.this.fTable[this.currentPos];
                ++this.currentPos;
            }
            if (entry != null) {
                this.lastEntry = entry;
                ++this.visited;
                return entry.fValue;
            }
            throw new RuntimeException("Logic Error");
        }

        public void remove() {
        }
    }
}

