/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.weblogic;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.jmx.JMXDelegatingService;
import com.wily.introscope.agent.service.IAgentService;
import com.wily.introscope.agent.service.ServiceAdministrator;
import com.wily.introscope.agent.transactiontrace.IPlatformCrossProcessDataHelper;
import com.wily.introscope.agent.transactiontrace.weblogic.WeblogicPlatformCrossProcessDataHelper;
import com.wily.introscope.agent.transformer.dynamic.AInstrumentationHelper;
import com.wily.introscope.agent.webappsupport.weblogic.WebLogicAgentNamer;
import com.wily.introscope.agent.wldf.WLDFDelegatingService;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.Map;
import weblogic.common.T3ServicesDef;
import weblogic.common.T3StartupDef;

public final class IntroscopeStartupClass
implements T3StartupDef {
    private static final String kIntroscopeStartupClassStarted = "Introscope Auto Agent Naming and JMX Support have been initiated";

    public void setServices(T3ServicesDef services) {
    }

    public String startup(String name, Hashtable hashtable) throws Exception {
        IAgent agent = AgentShim.getAgentShim().IAgentShim_getAgent();
        IModuleFeedbackChannel feedbackChannel = agent.IAgent_getModuleFeedback();
        if (feedbackChannel.isDebugEnabled() && AInstrumentationHelper.setAndGetStartupServiceCalled((boolean)true)) {
            agent.IAgent_getModuleFeedback().debug("Another instance of IntroscopeStartupClass is already running !!!");
            return kIntroscopeStartupClassStarted;
        }
        IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
        Hashtable workHashtable = hashtable == null ? new Hashtable() : (Hashtable)hashtable.clone();
        this.recordCredentials(workHashtable, feedback);
        WebLogicAgentNamer agentNamer = new WebLogicAgentNamer(agent);
        agentNamer.setAgentNamingCallback();
        ServiceAdministrator serviceAdministrator = agent.IAgent_getServiceAdministrator();
        serviceAdministrator.registerServiceAsync(agent, "JMX", (IAgentService)new JMXDelegatingService(), (Map)workHashtable);
        serviceAdministrator.registerServiceAsync(agent, "WLDF", (IAgentService)new WLDFDelegatingService(), (Map)workHashtable);
        boolean enableCrossJVMTracing = agent.IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.weblogic.crossjvm");
        try {
            if (enableCrossJVMTracing) {
                Class<?> traceClass = Class.forName("weblogic.trace.Trace");
                agent.addCrossProcessDataHelper((IPlatformCrossProcessDataHelper)new WeblogicPlatformCrossProcessDataHelper(traceClass));
                feedback.info("Cross-JVM tracing has been enabled");
            } else {
                feedback.info("Cross-JVM tracing has been disabled");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                feedback.info("No cross-JVM tracing is configured");
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {}
        }
        return kIntroscopeStartupClassStarted;
    }

    private void recordCredentials(Hashtable ht, IModuleFeedbackChannel feedback) {
        Object curSubject;
        Class<?> securityClass = null;
        try {
            securityClass = Class.forName("weblogic.security.Security");
        }
        catch (Throwable t) {
            feedback.debug("Unable to determine credentials, caught Throwable getting class weblogic.security.Security: ", t);
            return;
        }
        try {
            Method getCurrentSubject = securityClass.getMethod("getCurrentSubject", null);
            curSubject = getCurrentSubject.invoke(null, null);
        }
        catch (Exception e) {
            feedback.debug("Unable to determine credentials, caught Exception invoking getCurrentSubject(): ", e);
            return;
        }
        if (curSubject != null) {
            ht.put("com.wily.introscope.jmx.securitysubject", curSubject);
            ht.put("com.wily.introscope.jmx.security.classname", "weblogic.security.Security");
            ht.put("com.wily.introscope.jmx.priveleged.methodname", "runAs");
            AccessControlContext ctx = AccessController.getContext();
            if (ctx != null) {
                ht.put("com.wily.introscope.jmx.accesscontroller", ctx);
            }
            ht.put("com.wily.introscope.wldf.securitysubject", curSubject);
            feedback.debug("Running as subject = -->" + curSubject + "<--");
        } else {
            feedback.debug("Found null subject.");
        }
    }
}

