/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.correlation;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.soaextension.tibcobw.correlation.ClientCorrelationTracer;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Method;

public class JMSClientCorrelationTracer
extends ClientCorrelationTracer {
    public JMSClientCorrelationTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        try {
            Object currentMessageObject;
            if (TibcoBWUtils.correlationJMSInsertionEnabled() && (currentMessageObject = data.getInvocationParameterAsObject(1)) != null) {
                SharedCrossProcessData cache = this.getComponentTracer().getCrossProcessDataCache();
                cache.markNextCrossProcessCallAsNonBlocking();
                String correlationString = new CorrelationId().getOutgoingCorrelationIdStrippedForHeader();
                if (correlationString != null) {
                    Method M_setObjectProperty = currentMessageObject.getClass().getMethod("setStringProperty", String.class, String.class);
                    M_setObjectProperty.setAccessible(true);
                    M_setObjectProperty.invoke(currentMessageObject, "CorID", correlationString);
                }
            }
        }
        catch (Throwable t) {
            this.fLogger.error("JMSClientCorrelationTracer ITracer_startTrace exception " + TibcoBWUtils.dumpStackTrace(t));
        }
    }

    public void ITracer_finishTrace(int index, InvocationData data) {
        if (TibcoBWUtils.correlationJMSInsertionEnabled()) {
            super.ITracer_finishTrace(index, data);
        }
    }
}

