/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.ws;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.errors.ErrorSnapshotFeatureFactory;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.trace.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.spec.metric.ESEException;
import com.wily.soaextension.tibcobw.KConstants;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.soaextension.tibcobw.TibcoReflectionCache;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.lang.reflect.Method;

public class ClientSOAPFaultTracer
extends ASingleMetricTracerFactory {
    public boolean soapFlag = false;

    public ClientSOAPFaultTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    protected IDataAccumulator createDataAccumulator(String s) {
        return null;
    }

    public void ITracer_finishTrace(int i, InvocationData data) {
        String objString = null;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        try {
            String component = this.formatParameterizedResource(data);
            this.getAgent().IAgent_getComponentTracer().removeComponent(component);
            if (data.hasInvocationThrownException()) {
                Throwable error = data.getInvocationThrownException();
                Object fData = TibcoReflectionCache.getM_getData(error);
                if (fData != null) {
                    Method M_Attribute = TibcoReflectionCache.getM_Attribute_getStringValue(fData);
                    Object fDataObj = M_Attribute.invoke(fData, KConstants.EMPTY_OBJECT_ARRAY);
                    if (fDataObj != null) {
                        objString = (String)fDataObj;
                    }
                    this.soapFlag = objString != null ? true : true;
                    if (this.soapFlag) {
                        String errorMessage = "SOAP Fault: " + component + ": " + objString;
                        if (isDebugEnabled) {
                            TibcoBWUtils.getLogger().debug("ClientSOAPFaultTracer - SOAP Fault Message: " + errorMessage);
                        }
                        if (ErrorSnapshotFeatureFactory.flagErrorInManagedApplication((String)errorMessage)) {
                            this.getAgent().IAgent_getComponentTracer().noteBoundaryError();
                        }
                        String name = this.formatParameterizedName(data);
                        this.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(name).ILongIntervalCounterDataAccumulator_addSingleIncident();
                    }
                }
                Throwable errorNew = error;
                String errorMessage = String.valueOf(component) + ": " + errorNew.getClass().getName() + ": " + errorNew.getMessage();
                if (isDebugEnabled) {
                    TibcoBWUtils.getLogger().debug("ClientSOAPFaultTracer - Error Message: " + errorMessage);
                }
                if (ErrorSnapshotFeatureFactory.flagErrorInManagedApplication((String)errorMessage)) {
                    this.getAgent().IAgent_getComponentTracer().noteBoundaryError();
                }
                this.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(String.valueOf(component) + ":" + "Errors Per Interval").ILongIntervalCounterDataAccumulator_addSingleIncident();
            }
        }
        catch (ESEException eSEException) {
            Assertion.wilyFail((String)"Metric type conflict");
        }
        catch (Throwable bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_CLIENT_SOAPFAULT_TRACER", bomb);
        }
    }

    public void ITracer_startTrace(int i, InvocationData data) {
        String component = this.formatParameterizedResource(data);
        this.getAgent().IAgent_getComponentTracer().addComponent(component);
    }
}

