/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.appmap.agent.trace.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.activation.IOSGiClassPlugin;
import com.wily.introscope.agent.blame.IAppMapStack;
import com.wily.introscope.agent.blame.IComponentParameterCallback;
import com.wily.introscope.agent.blame.IStackType;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.trace.ABundledTracerFactory;
import com.wily.introscope.agent.trace.ATracerFactory;
import com.wily.introscope.agent.trace.ICacheableInvocationDataTracerFactory;
import com.wily.introscope.agent.trace.IMetricNameFormatListener;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.transactiontrace.CrossCorrelationStringParameterProvider;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.appmap.agent.AppMapService;
import com.wily.introscope.appmap.agent.AppMapStack;
import com.wily.introscope.appmap.agent.trace.AUniqueCandidate;
import com.wily.introscope.appmap.agent.trace.AppMapCrossProcessHelper;
import com.wily.introscope.appmap.agent.trace.MetricNamesThreadLocalHelper;
import com.wily.introscope.appmap.agent.trace.hc2.AppMapReplayer;
import com.wily.introscope.appmap.agent.trace.hc2.IAppMapReplayerTracer;
import com.wily.introscope.spec.agent.beans.appmap.IAppMapDecisionSupportBean;
import com.wily.introscope.spec.server.transactiontrace.SequenceId;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AppMapMarkerTracer
extends ABundledTracerFactory
implements IAppMapReplayerTracer,
ITracer,
IOSGiClassPlugin,
CrossCorrelationStringParameterProvider,
ICacheableInvocationDataTracerFactory,
IMetricNameFormatListener {
    private static final String kName = "AppMapMarkerTracer";
    private static final String kBoundaryType = "boundaryType";
    private static final String kBoundaryTypeBackend = "Backend";
    private static final Module kModule = new Module("AppMapMarkerTracer");
    private static final IStackType[] kUndefinedStackType = new IStackType[0];
    private IModuleFeedbackChannel fFeedback;
    private boolean fShutoff = true;
    private IAppMapDecisionSupportBean fOracle;
    private String fNodeType;
    private final boolean fIsBackend;
    private volatile boolean fShouldDoCrossInfo;
    private volatile boolean fIsForcedFirstCrossProcess;
    private volatile IStackType[] stackType = kUndefinedStackType;
    private volatile boolean fIsOneStack = false;
    private volatile boolean fIsNoStack = false;

    public AppMapMarkerTracer() {
        this.fIsBackend = false;
    }

    public AppMapMarkerTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        try {
            this.fFeedback = agent.IAgent_getModuleFeedback();
            this.fOracle = AppMapService.getOracleInstance();
            this.fShutoff = false;
        }
        catch (Throwable t) {
            try {
                this.getAgent().IAgent_getModuleFeedback().warn(kModule, "Tracer failed initialization");
                this.getAgent().IAgent_getModuleFeedback().verbose(kModule, "Tracer failed initialization", t);
            }
            catch (Throwable throwable) {}
            this.fShutoff = true;
        }
        if (!this.fShutoff) {
            this.fNodeType = this.getParameter("nodeType");
            String boundaryType = this.getParameter(kBoundaryType);
            this.fIsBackend = boundaryType != null && boundaryType.equals(kBoundaryTypeBackend);
            this.initializeStackType();
            this.fShutoff |= this.fIsNoStack;
            this.fShouldDoCrossInfo = this.getParameter("isCrossProcess") != null;
            this.fIsForcedFirstCrossProcess = this.getParameter("isForcedCrossProcess") != null;
        } else {
            this.fIsBackend = false;
        }
    }

    private IStackType[] getStackType() {
        return this.stackType;
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        if (data.isTransactionAborted()) {
            return;
        }
        if (this.fShouldDoCrossInfo) {
            VirtualStack.pushAppMap((CrossCorrelationStringParameterProvider)this, (InvocationData)data);
            IStackType[] types = this.getStackType();
            if (this.fIsOneStack) {
                SharedCrossProcessData cache = data.getSharedCrossProcessData();
                AppMapCrossProcessHelper.setCallingComponentName(cache, types[0], this);
                AppMapCrossProcessHelper.setCallingComponentType(cache, this);
            } else {
                SharedCrossProcessData cache = data.getSharedCrossProcessData();
                int i = 0;
                while (i < types.length) {
                    AppMapCrossProcessHelper.setCallingComponentName(cache, types[i], this);
                    AppMapCrossProcessHelper.setCallingComponentType(cache, this);
                    ++i;
                }
            }
        }
    }

    public void ITracer_finishTrace(final int tracerIndex, final InvocationData data) {
        if (!data.isTransactionAborted() && data.hasNewAppMapCursor()) {
            IStackType[] types = this.getStackType();
            if (this.fIsOneStack) {
                new AppMapReplayer(){

                    @Override
                    public void executeAppMap(IAppMapStack stack) {
                        AppMapMarkerTracer.this.replay_startTrace(tracerIndex, data, stack);
                        AppMapMarkerTracer.this.replay_finishTrace(tracerIndex, data, stack);
                        AppMapMarkerTracer.this.replay_shutdown(tracerIndex, data, stack);
                    }
                }.replayAppMapOnStack(types[0], data, tracerIndex, this.fIsForcedFirstCrossProcess);
            } else {
                int i = 0;
                while (i < types.length) {
                    IStackType myType = types[i];
                    new AppMapReplayer(){

                        @Override
                        public void executeAppMap(IAppMapStack stack) {
                            AppMapMarkerTracer.this.replay_startTrace(tracerIndex, data, stack);
                            AppMapMarkerTracer.this.replay_finishTrace(tracerIndex, data, stack);
                            AppMapMarkerTracer.this.replay_shutdown(tracerIndex, data, stack);
                        }
                    }.replayAppMapOnStack(myType, data, tracerIndex, this.fIsForcedFirstCrossProcess);
                    ++i;
                }
            }
        }
        if (this.fShouldDoCrossInfo) {
            SharedCrossProcessData cache;
            CrossCorrelationStringParameterProvider provider = data.getCrossProcessStringParentProvider();
            IStackType[] types = this.getStackType();
            if (this.fIsOneStack) {
                cache = data.getSharedCrossProcessData();
                AppMapCrossProcessHelper.setCallingComponentName(cache, types[0], provider);
                AppMapCrossProcessHelper.setCallingComponentType(cache, provider);
            } else {
                cache = data.getSharedCrossProcessData();
                int i = 0;
                while (i < types.length) {
                    AppMapCrossProcessHelper.setCallingComponentName(cache, types[i], provider);
                    AppMapCrossProcessHelper.setCallingComponentType(cache, provider);
                    ++i;
                }
            }
            VirtualStack.popAppMap((InvocationData)data);
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kInstance;
    }

    public boolean ITracerFactory_isShutoff() {
        return this.fShutoff || !AppMapService.hasStarted() || !AppMapService.isAppMapEnabled();
    }

    private void initializeStackType() {
        String levels = this.getParameter("nodeLevel");
        List stackLevels = this.filterLevels(levels);
        String owners = this.getParameter("ownerType");
        List stackOwners = this.filterOwners(owners);
        ArrayList<IStackType> resultStackType = new ArrayList<IStackType>();
        int i = 0;
        while (i < stackLevels.size()) {
            int j = 0;
            while (j < stackOwners.size()) {
                IStackType stack = AppMapService.getStackType((String)stackLevels.get(i), (String)stackOwners.get(j));
                if (stack == null) {
                    ProbeIdentification probe = this.getProbeIdentification();
                    this.fFeedback.warn(kModule, "Tracer " + probe.getRuntimePackageAndClassName() + "." + probe.getProbeMethodName() + probe.getProbeMethodDescriptor() + " does not have correct parameters [nodeLevel, ownerType] " + stackLevels.get(i) + ";" + stackOwners.get(j));
                } else {
                    resultStackType.add(stack);
                }
                ++j;
            }
            ++i;
        }
        IStackType[] stackTypeBuffer = new IStackType[resultStackType.size()];
        this.fIsOneStack = (stackTypeBuffer = resultStackType.toArray(stackTypeBuffer)).length == 1;
        this.fIsNoStack = stackTypeBuffer.length == 0;
        this.stackType = stackTypeBuffer;
    }

    private List filterLevels(String levels) {
        ArrayList<String> result = new ArrayList<String>();
        if (levels != null) {
            String[] splitted = levels.split(",");
            int i = 0;
            while (i < splitted.length) {
                if (AppMapService.isLevelEnabled(splitted[i])) {
                    result.add(splitted[i]);
                }
                ++i;
            }
        }
        return result;
    }

    private List filterOwners(String owners) {
        ArrayList<String> result = new ArrayList<String>();
        if (owners != null) {
            String[] splitted = owners.split(",");
            int i = 0;
            while (i < splitted.length) {
                if (AppMapService.isOwnerTypeEnabled(splitted[i])) {
                    result.add(splitted[i]);
                }
                ++i;
            }
        }
        return result;
    }

    private String getMapComponent(InvocationData data) {
        String component = this.formatParameterizedName(data);
        return component;
    }

    public String getParam(String key) {
        InvocationData pivot = VirtualStack.peekAppMap();
        while (pivot != null) {
            if (pivot.hasTracerFactory((Object)this)) break;
            pivot = pivot.getAppMapParent();
        }
        if (pivot == null) {
            this.fFeedback.error(kModule, "Could not find invocation data for tracer ;" + this.getParameter("ownerType") + ";" + this.getParameter("nodeLevel") + ";" + this.fNodeType + ";" + this.getParameter("name"));
            return null;
        }
        if (key == "AppMapCallerClassName") {
            return this.getMapComponent(pivot);
        }
        if (key == "AppMapCallerMethodName") {
            return this.getMapComponent(pivot);
        }
        if (key == "AppMapCallerType") {
            return this.fNodeType;
        }
        if (key == "AppMapCallerHost") {
            return this.getAgent().IAgent_getHostProcessAgentTriplet()[0];
        }
        if (key == "AppMapCallerProcess") {
            return this.getAgent().IAgent_getHostProcessAgentTriplet()[1];
        }
        if (key == "AppMapCallerAgent") {
            return this.getAgent().IAgent_getHostProcessAgentTriplet()[2];
        }
        return null;
    }

    private AUniqueCandidate getUniqueCandidateMetricSet(InvocationData data, String component) {
        AUniqueCandidate candidate = AUniqueCandidate.getInstance(component, data.getProbeInformation().getProbeIdentification().getRuntimePackageAndClassName(), data.getProbeInformation().getProbeIdentification().getProbeMethodName(), data.getProbeInformation().getProbeIdentification().getProbeMethodDescriptor());
        return candidate;
    }

    private String fetchCurentOutgoingSeqId(InvocationData data) {
        SequenceId seq;
        SharedCrossProcessData cache = data.getSharedCrossProcessData();
        String outSeqId = null;
        if (cache != null && (seq = cache.getSeqID()) != null) {
            outSeqId = seq.getSequenceIdOutgoingFormat();
        }
        return outSeqId;
    }

    @Override
    public boolean replay_startTrace(int tracerIndex, InvocationData data, IAppMapStack stack) {
        boolean isIntermediateNodeEnabled;
        boolean fTracingEnabled;
        boolean bl = fTracingEnabled = !this.ITracerFactory_isShutoff();
        if (!fTracingEnabled) {
            return false;
        }
        boolean bl2 = isIntermediateNodeEnabled = AppMapService.isIntermediateNodesEnabled() || this.fIsForcedFirstCrossProcess;
        if (!this.fIsBackend && !isIntermediateNodeEnabled && data.get("AppMap.NewName") == null) {
            return false;
        }
        this.fFeedback.isTraceEnabled(kModule);
        String component = this.getMapComponent(data);
        HashMap<String, String> params = new HashMap<String, String>();
        String paramVal1 = this.fetchCurentOutgoingSeqId(data);
        String paramName1 = "OutgoingSeqNo";
        if (paramVal1 != null) {
            params.put(paramName1, paramVal1);
        }
        params.put("nodeType", this.fNodeType);
        stack.directAddMapComponent(component, params);
        data.setComponentNameAt(component, tracerIndex);
        if (AppMapService.areMetricsEnabled() && ((AppMapStack)stack).getStackType() == AppMapService.kStackTypeClassMethodApp) {
            AUniqueCandidate candidate = this.getUniqueCandidateMetricSet(data, component);
            MetricNamesThreadLocalHelper.pushActiveMetricNameMap(candidate);
        }
        ITracer[] bptOld = data.getTracersByType(com.wily.introscope.agent.trace.BlamePointTracer.class);
        int i = 0;
        while (i < bptOld.length) {
            if (bptOld[i] != null) {
                ((ATracerFactory)bptOld[i]).exportParameterNameAndRuntimeFormat((IMetricNameFormatListener)this, i, data);
            }
            ++i;
        }
        ITracer[] bptNew = data.getTracersByType(BlamePointTracer.class);
        int i2 = 0;
        while (i2 < bptNew.length) {
            if (bptNew[i2] != null) {
                ((ATracerFactory)bptNew[i2]).exportParameterNameAndRuntimeFormat((IMetricNameFormatListener)this, i2, data);
            }
            ++i2;
        }
        return true;
    }

    @Override
    public boolean replay_finishTrace(int tracerIndex, final InvocationData data, IAppMapStack stack) {
        String component = data.getComponentNameAt(tracerIndex);
        if (component != null) {
            stack.directRemoveMapComponent(component, (IComponentParameterCallback)new DatabaseCallback(data), new IAppMapDecisionSupportBean.ICallBackOnSent(){

                public void onSent(boolean sucess) {
                    ITransactionElement startElement;
                    if (!sucess && (startElement = data.getStartTransactionElement()) != null) {
                        startElement.resetAppMapStamp();
                    }
                }
            });
        }
        if (AppMapService.areMetricsEnabled() && ((AppMapStack)stack).getStackType() == AppMapService.kStackTypeClassMethodApp) {
            MetricNamesThreadLocalHelper.popMetricNamesMap();
        }
        return true;
    }

    @Override
    public boolean actsOnStack(IStackType type) {
        IStackType[] types = this.getStackType();
        if (this.fIsOneStack) {
            return types[0] == type;
        }
        int i = 0;
        while (i < types.length) {
            if (type == types[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getName() {
        return this.getPluginClass().getName();
    }

    public Class getPluginClass() {
        return AppMapMarkerTracer.class;
    }

    public ITracer ITracerFactory_allocateTracer(int tracerIndex, InvocationData data) {
        return this;
    }

    public final void ITracerFactory_releaseTracer(int tracerIndex, ITracer tracer) {
    }

    @Override
    public boolean replay_shutdown(int tracerIndex, InvocationData data, IAppMapStack stack) {
        MetricNamesThreadLocalHelper.reset();
        return true;
    }

    @Override
    public boolean isAppMapNameTracer() {
        return false;
    }

    public boolean canCacheInvocationData() {
        return true;
    }

    public boolean canCacheTracerInstances() {
        return false;
    }

    public boolean canCacheComponentNames() {
        return false;
    }

    public void notifyFormatting(String nameParameter, String result) {
        if (!this.ITracerFactory_isShutoff() && AppMapService.areMetricsEnabled()) {
            MetricNamesThreadLocalHelper.addMetricName(nameParameter, result, this.getAgent().IAgent_getModuleFeedback());
        }
    }

    private class DatabaseCallback
    implements IComponentParameterCallback {
        private static final String kNoUrlFormatterResult = "None";
        private static final String kUrlFormatPlaceholder = "{url}";
        private final InvocationData fData;

        DatabaseCallback(InvocationData data) {
            this.fData = data;
        }

        public void IComponentParameterCallback_addParameters(Map parameters) {
            block5: {
                Map s;
                if (this.fData.get("x-apm-bt") != null) {
                    s = (Map)this.fData.get("x-apm-bt");
                    parameters.put("x-apm-bt", s);
                }
                if (this.fData.get("x-apm-bt") != null) {
                    s = (Map)this.fData.get("x-apm-bt");
                    parameters.put("x-apm-bt", s);
                }
                if (parameters != null && AppMapService.isCatalystIntegrationEnabled() && AppMapMarkerTracer.this.fNodeType.equals("Database")) {
                    try {
                        parameters.put("DatabaseConnection", this.getUrl(this.fData));
                    }
                    catch (Throwable t) {
                        if (!AppMapMarkerTracer.this.fFeedback.isTraceEnabled(kModule)) break block5;
                        AppMapMarkerTracer.this.fFeedback.trace(kModule, "Cannot get Database information:" + t.getMessage());
                    }
                }
            }
        }

        private Object getUrl(InvocationData data) {
            INameFormatter f = AppMapMarkerTracer.this.getCustomNameFormatter();
            if (f != null) {
                String statement = kUrlFormatPlaceholder;
                return f.INameFormatter_format(statement, data);
            }
            return kNoUrlFormatterResult;
        }
    }
}

