/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.stat.IIntegerAggregatingDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerAverageDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.BlamePointTracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.properties.AttributeListing;

public class BackendTracer
extends BlamePointTracer {
    private static final String kBackendsCategoryPrefix = "Backends|";

    public BackendTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        String component = this.getComponentName(data);
        data.setComponentNameAt(component, tracerIndex);
        this.doStartBackendTrace(tracerIndex, data, component);
    }

    protected void doStartBackendTrace(int tracerIndex, InvocationData data, String component) {
        this.doStartBlamePointTrace(tracerIndex, data, component);
    }

    protected void addComponentToBlameStack(String component, InvocationData data) {
        ComponentTracer componentTracer = this.getComponentTracer();
        super.addComponentToBlameStack(component, data);
        IBlameStack stack = data.getStack(componentTracer, true);
        componentTracer.setBackend(stack, component);
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        String component = data.getComponentNameAt(tracerIndex);
        this.getComponentTracer().endBoundaryPopped(component);
        this.doFinishBlamePointTrace(tracerIndex, data, component);
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kInstance;
    }

    protected String getComponentName(InvocationData data) {
        String name = this.formatParameterizedName(data);
        if (!name.startsWith("Backends")) {
            name = kBackendsCategoryPrefix + name;
        }
        return name;
    }

    public IIntegerAverageDataAccumulator getResponseTimeAccumulator(String name) {
        return this.getDataAccumulatorFactory().safeGetIntegerAverageDataAccumulator(name);
    }

    public ILongIntervalCounterDataAccumulator getPerIntervalAccumulator(String name) {
        return this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(name);
    }

    protected IIntegerAggregatingDataAccumulator createTimerDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetBackendIntegerAverageDataAccumulator(formattedMetricName);
    }

    protected ILongIntervalCounterDataAccumulator createPerIntervalDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetBackendLongIntervalCounterDataAccumulator(formattedMetricName);
    }

    protected IIntegerFluctuatingCounterDataAccumulator createConcurrentInvocationDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetBackendIntegerFluctuatingCounterDataAccumulator(formattedMetricName);
    }

    protected ILongIntervalCounterDataAccumulator createErrorsDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetBackendLongIntervalCounterDataAccumulator(formattedMetricName);
    }

    protected IIntegerFluctuatingCounterDataAccumulator createStallsDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetBackendIntegerAggregatingFluctuatingCounterDataAccumulator(formattedMetricName);
    }
}

