/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.biz.trx;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.errors.ErrorSnapshotFeatureFactory;
import com.wily.introscope.agent.errors.Log;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.IIntegerAggregatingDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.BlamePointTracer;
import com.wily.introscope.agent.trace.FrontendTracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.biz.trx.IBizTrxTracer;
import com.wily.introscope.spec.agent.bizdef.IBizTrx;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.metric.ESEException;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class BizTrxAbstractTracer
extends FrontendTracer
implements IBizTrxTracer {
    public BizTrxAbstractTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    protected String getComponentName(InvocationData data) {
        String result = this.formatParameterizedName(data);
        return result;
    }

    protected void addComponentToBlameStack(String component, InvocationData data) {
        ComponentTracer componentTracer = this.getComponentTracer();
        IBlameStack stack = data.getStack(componentTracer, true);
        componentTracer.addComponent(stack, component);
        componentTracer.setComponentMetricPropagateFlag(stack, component, 3);
    }

    protected void doStartBlamePointTraceSimpleLite(int tracerIndex, InvocationData data, String component) {
        ComponentTracer componentTracer = this.getComponentTracer();
        IBlameStack stack = data.getStack(componentTracer, true);
        data.storeWallClockStartTime();
        componentTracer.addComponent(stack, component);
    }

    protected void doStartBlamePointTraceLite(int tracerIndex, InvocationData data, String component) {
        ComponentTracer componentTracer = this.getComponentTracer();
        IBlameStack stack = data.getStack(componentTracer, true);
        data.storeWallClockStartTime();
        componentTracer.addComponent(stack, component);
    }

    protected void doFinishBlamePointTraceLite(int tracerIndex, InvocationData data, String component) {
        ComponentTracer componentTracer = this.getComponentTracer();
        IBlameStack stack = data.getStack(componentTracer, false);
        BlameStackSnapshot snap = componentTracer.getSnapshot(stack, component);
        BlamePointTracer.DataAccumulatorGroup group = this.getAccumulatorGroupLite(component);
        group.timerAccumulator.IIntegerAggregatingDataAccumulator_recordDataPoint(data.getWallClockElapsedTimeAsInt(), snap);
        group.perIntervalAccumulator.ILongIntervalCounterDataAccumulator_addSingleIncident(snap);
        if (this.shouldForceStandardBlameMetrics() && group.errorsAccumulator != null) {
            group.errorsAccumulator.forceMetricToExist(snap);
        }
        this.addBusinessDefinitionParameters(data);
        componentTracer.removeComponent(stack, component);
    }

    protected void doFinishBlamePointTraceSimpleLite(int tracerIndex, InvocationData data, String component, String oldComponent) {
        ComponentTracer componentTracer = this.getComponentTracer();
        IBlameStack stack = data.getStack(componentTracer, false);
        BlameStackSnapshot snap = componentTracer.getSnapshot(stack, component);
        BlamePointTracer.DataAccumulatorGroup group = this.getAccumulatorGroupLite(component);
        group.timerAccumulator.IIntegerAggregatingDataAccumulator_recordDataPoint(data.getWallClockElapsedTimeAsInt(), snap);
        group.perIntervalAccumulator.ILongIntervalCounterDataAccumulator_addSingleIncident(snap);
        if (this.shouldForceStandardBlameMetrics() && group.errorsAccumulator != null) {
            group.errorsAccumulator.forceMetricToExist(snap);
        }
        this.addBusinessDefinitionParameters(data);
        componentTracer.removeComponent(stack, oldComponent);
    }

    protected void doFinishBlamePointTraceNoMatch(int tracerIndex, InvocationData data, String component) {
        ComponentTracer componentTracer = this.getComponentTracer();
        IBlameStack stack = data.getStack(componentTracer, false);
        componentTracer.removeComponent(stack, component);
    }

    protected void doFinishBlamePointTrace(int tracerIndex, InvocationData data, String component) {
        this.addBusinessDefinitionParameters(data);
        super.doFinishBlamePointTrace(tracerIndex, data, component);
    }

    private BlamePointTracer.DataAccumulatorGroup getAccumulatorGroupLite(String component) {
        BlamePointTracer.DataAccumulatorGroup result = null;
        HashMap groupContainer = null;
        if (this.metricGroupContainerCache.getRemovalKey() == DataAccumulatorFactory.getRemovalMetricKey()) {
            groupContainer = this.metricGroupContainerCache.getThreadLocalMap();
            result = (BlamePointTracer.DataAccumulatorGroup)groupContainer.get(component);
            if (result != null && result.concurrentInvocationAccumulator != null) {
                result = null;
            }
        } else {
            this.metricGroupContainerCache.initialize(DataAccumulatorFactory.getRemovalMetricKey());
            groupContainer = this.metricGroupContainerCache.getThreadLocalMap();
        }
        if (result == null) {
            result = this.createAccumulatorGroupLite(component);
            groupContainer.put(component, result);
        }
        return result;
    }

    protected void resetAccumulatorGroup(String component) {
        HashMap groupContainer = null;
        if (this.metricGroupContainerCache.getRemovalKey() == DataAccumulatorFactory.getRemovalMetricKey()) {
            groupContainer = this.metricGroupContainerCache.getThreadLocalMap();
            groupContainer.remove(component);
        }
    }

    private BlamePointTracer.DataAccumulatorGroup createAccumulatorGroupLite(String component) {
        ArrayList<AgentMetric> metrics = new ArrayList<AgentMetric>(3);
        BlamePointTracer.DataAccumulatorGroup result = new BlamePointTracer.DataAccumulatorGroup();
        result.timerAccumulator = this.createTimerDataAccumulator(this.getTimerMetricName(component));
        metrics.add(result.timerAccumulator.IDataAccumulator_getMetric());
        result.perIntervalAccumulator = this.createPerIntervalDataAccumulator(this.getPerIntervalMetricName(component));
        metrics.add(result.perIntervalAccumulator.IDataAccumulator_getMetric());
        if (this.shouldForceStandardBlameMetrics()) {
            result.errorsAccumulator = this.createErrorsDataAccumulator(this.getErrorsMetricName(component));
            metrics.add(result.errorsAccumulator.IDataAccumulator_getMetric());
        }
        this.getAgent().IAgent_getMetricRecordingAdministrator().addMetricGroup(component, metrics);
        return result;
    }

    public void addBusinessDefinitionParameters(InvocationData data) {
        IBizTrx bizTrx = (IBizTrx)data.get("BusinessTrxData");
        Assertion.wilyAssert(bizTrx != null);
        ComponentTracer componentTracer = this.getComponentTracer();
        IBlameStack stack = data.getStack(componentTracer, false);
        componentTracer.addRootParameter(stack, "Business Definition", bizTrx.getBizFullName());
        componentTracer.addRootParameter(stack, "EUM Business Transaction", bizTrx.getBizTrxName());
    }

    protected void checkForErrors(String component, InvocationData data) {
        if (data.hasInvocationThrownException()) {
            String errorMessage;
            if (Log.out.isDebugEnabled()) {
                ProbeIdentification probe = data.getProbeInformation().getProbeIdentification();
                Log.out.debug("Business Transaction Error Reporter: " + probe.getRuntimeFullClassName() + "." + probe.getProbeMethodName() + " threw an exception");
            }
            Throwable error = data.getInvocationThrownException();
            if (component != null && ErrorSnapshotFeatureFactory.flagErrorInManagedApplication(errorMessage = String.valueOf(component) + ": " + error.getClass().getName() + ": " + error.getMessage())) {
                try {
                    String errorMetric = String.valueOf(component) + ":Errors Per Interval";
                    this.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(errorMetric).ILongIntervalCounterDataAccumulator_addSingleIncident();
                }
                catch (ESEException eSEException) {
                    Assertion.wilyFail("Metric type conflict");
                }
            }
        }
    }

    protected IIntegerAggregatingDataAccumulator createTimerDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetBizTrxIntegerAverageDataAccumulator(formattedMetricName);
    }

    protected ILongIntervalCounterDataAccumulator createPerIntervalDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetBizTrxLongIntervalCounterDataAccumulator(formattedMetricName);
    }

    protected IIntegerFluctuatingCounterDataAccumulator createConcurrentInvocationDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetBizTrxIntegerFluctuatingCounterDataAccumulator(formattedMetricName);
    }

    protected ILongIntervalCounterDataAccumulator createErrorsDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetBizTrxLongIntervalCounterDataAccumulator(formattedMetricName);
    }

    protected IIntegerFluctuatingCounterDataAccumulator createStallsDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetBizTrxIntegerAggregatingFluctuatingCounterDataAccumulator(formattedMetricName);
    }
}

