/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.agent.stat.IIntegerAverageDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.RepositoryFactory;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.spec.agent.bizdef.IBizTrx;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.util.properties.AttributeListing;
import java.util.ArrayList;

public class BackendTracer
extends BlamePointTracer {
    protected static final String appMapFormatter = "{database}";
    public static final String kBackendsCategoryPrefix = "Backends|";
    private static final String kCalledBackendsMetricPrefix = "Called ";
    private static final String kCalledBackendsCategoryPrefix = "Called Backends|";
    private static final boolean kDefaultDoBackendForTransactionComponents = false;
    private boolean fDoBackendForTransactionComponents = false;

    public BackendTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    @Override
    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kInstance;
    }

    @Override
    protected final boolean hasContextualMetrics() {
        return true;
    }

    @Override
    protected String getComponentName(InvocationData data) {
        String name = this.formatParameterizedName(data);
        if (!name.contains("Backends")) {
            name = kBackendsCategoryPrefix + name;
        }
        return name;
    }

    @Override
    public void doOnStartTrace(int tracerIndex, IStackElement elementData, ITransactionElement element) {
        super.doOnStartTrace(tracerIndex, elementData, element);
        InvocationData data = (InvocationData)elementData;
        if (data.getEndBoundary() == null) {
            ((InvocationData)elementData).setEndBoundary(tracerIndex);
        }
        data.getVirtualCursor().getCurrentCache().incrementAndGetBackendsCount();
    }

    @Override
    public void doOnEndTrace(int tracerIndex, IStackElement elementData, ITransactionElement element) {
        super.doOnEndTrace(tracerIndex, elementData, element);
        InvocationData data = (InvocationData)elementData;
        if (data.getVirtualCursor().getCurrentCache().decrementAndGetBackendsCount() == 0) {
            ((InvocationData)elementData).unsetEndBoundary(tracerIndex);
        }
        this.consumeComponentId(data);
    }

    public IIntegerAverageDataAccumulator getResponseTimeAccumulator(String name) {
        return this.getDataAccumulatorFactory().safeGetIntegerAverageDataAccumulator(name);
    }

    public ILongIntervalCounterDataAccumulator getPerIntervalAccumulator(String name) {
        return this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(name);
    }

    @Override
    protected AgentMetric[] createTimerMetric(String formattedMetricName) {
        int metricType = 536871937;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for an integer duration metric");
        return new AgentMetric[]{metric};
    }

    @Override
    protected AgentMetric[] createPerIntervalMetric(String formattedMetricName) {
        int metricType = 0x20002002;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for a long interval counter metric");
        return new AgentMetric[]{metric};
    }

    @Override
    protected AgentMetric[] createConcurrentInvocationMetric(String formattedMetricName) {
        int metricType = 0x20000101;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for an integer fluctuating counter metric");
        return new AgentMetric[]{metric};
    }

    @Override
    protected AgentMetric[] createErrorsMetric(String formattedMetricName) {
        int metricType = 0x20002002;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for a long interval counter metric");
        return new AgentMetric[]{metric};
    }

    @Override
    protected AgentMetric[] createStallsMetric(String formattedMetricName) {
        int metricType = 536871297;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for an aggregating integer fluctuating counter metric");
        return new AgentMetric[]{metric};
    }

    @Override
    public ITransactionElement getElementOnStartTrace(Object key, int tracerIndex, IStackElement dataElement, ITransactionElement parent) {
        IBizTrx businessTransaction;
        InvocationData data = (InvocationData)dataElement;
        WilyTransactionElement result = (WilyTransactionElement)super.getElementOnStartTrace(key, tracerIndex, data, parent);
        IBlameTransactionElement previous = BackendTracer.getFrontendElementForCalledBackendMetrics(result);
        IBlameTransactionElement entrypointElement = BackendTracer.getAutomaticEntryPointElementForCalledBackendMetrics(result);
        data.getEndBoundary();
        if (previous != null) {
            this.createCalledMetrics(tracerIndex, data, result, previous);
            result.setHasCalledBackendMetrics(true);
        } else {
            String currentFrontendFromOldMode = data.getFrontBoundary();
            if (currentFrontendFromOldMode != null) {
                this.createCalledMetrics(tracerIndex, data, result, BackendTracer.getCalledPrefix(currentFrontendFromOldMode));
                result.setHasCalledBackendMetrics(true);
            }
        }
        if (entrypointElement != null) {
            this.createCalledMetrics(tracerIndex, data, result, entrypointElement);
            result.setHasCalledBackendMetrics(true);
        }
        if (WilyTransactionStructure.fDoBackendForTransactionComponents && (businessTransaction = VirtualStack.getTransactionCache().getBizTrx()) != null) {
            this.createCalledBusinessMetrics(tracerIndex, data, result, businessTransaction);
        }
        return result;
    }

    protected void createCalledBusinessMetrics(int tracerIndex, InvocationData data, WilyTransactionElement result, IBizTrx businessTransaction) {
        String metricName = data.getComponentNameAt(tracerIndex);
        String previousKey = businessTransaction.getBizFullName();
        String calledPrefix = BackendTracer.getCalledPrefix(previousKey);
        AgentMetric[] timerMetric = this.createTimerMetricBtc(String.valueOf(calledPrefix) + this.getTimerMetricName(metricName));
        result.addMetric(timerMetric, result.getTimerRepository());
        AgentMetric[] perIntervalMetric = this.createPerIntervalMetricBtc(String.valueOf(calledPrefix) + this.getPerIntervalMetricName(metricName));
        result.addMetric(perIntervalMetric, result.getPerIntervalRepository());
        if (this.shouldForceStandardBlameMetrics()) {
            AgentMetric[] stallMetric = this.createStallsMetricBtc(String.valueOf(calledPrefix) + this.getStallsMetricName(metricName));
            result.addMetric(stallMetric, result.getStallsRepository());
            AgentMetric[] errorMetric = this.createErrorsMetricBtc(String.valueOf(calledPrefix) + this.getErrorsMetricName(metricName));
            result.addMetric(errorMetric, result.getErrorsRepository());
        }
    }

    protected void createCalledMetrics(int tracerIndex, InvocationData data, WilyTransactionElement result, IBlameTransactionElement previous) {
        String calledPrefix = BackendTracer.getCalledPrefix(previous);
        this.createCalledMetrics(tracerIndex, data, result, calledPrefix);
    }

    private void createCalledMetrics(int tracerIndex, InvocationData data, WilyTransactionElement result, String calledPrefix) {
        String metricName = data.getComponentNameAt(tracerIndex);
        metricName = IsengardServerConnectionManager.cleanBridgeRoutingPrefix(metricName);
        ArrayList<AgentMetric> metricsForGrouping = new ArrayList<AgentMetric>();
        AgentMetric[] timerMetric = this.createTimerMetric(String.valueOf(calledPrefix) + this.getTimerMetricName(metricName));
        result.addMetric(timerMetric, result.getTimerRepository());
        metricsForGrouping.add(timerMetric[0]);
        AgentMetric[] perIntervalMetric = this.createPerIntervalMetric(String.valueOf(calledPrefix) + this.getPerIntervalMetricName(metricName));
        result.addMetric(perIntervalMetric, result.getPerIntervalRepository());
        metricsForGrouping.add(perIntervalMetric[0]);
        if (this.shouldForceStandardBlameMetrics()) {
            AgentMetric[] stallMetric = this.createStallsMetric(String.valueOf(calledPrefix) + this.getStallsMetricName(metricName));
            result.addMetric(stallMetric, result.getStallsRepository());
            metricsForGrouping.add(stallMetric[0]);
            AgentMetric[] errorMetric = this.createErrorsMetric(String.valueOf(calledPrefix) + this.getErrorsMetricName(metricName));
            result.addMetric(errorMetric, result.getErrorsRepository());
            metricsForGrouping.add(errorMetric[0]);
        }
        this.getAgent().IAgent_getMetricRecordingAdministrator().addMetricGroup(calledPrefix, metricsForGrouping);
    }

    @Override
    protected boolean subscribeToDownstreamErrors() {
        return true;
    }

    @Override
    protected boolean subscribeToDownstreamStalls() {
        return true;
    }

    public static String getCalledPrefix(IBlameTransactionElement frontend) {
        String previousKey = ((WilyTransactionElement)frontend).getBlameName();
        String calledPrefix = BackendTracer.getCalledPrefix(previousKey);
        return calledPrefix;
    }

    public static String getCalledPrefix(String frontendKey) {
        if (frontendKey == null) {
            return null;
        }
        String calledPrefix = String.valueOf(frontendKey) + "|" + kCalledBackendsMetricPrefix;
        return calledPrefix;
    }

    public static IBlameTransactionElement getFrontendElementForCalledBackendMetrics(IBlameTransactionElement result) {
        IBlameTransactionElement cursor = result;
        while (cursor != null) {
            if (cursor.isFrontend()) {
                return cursor.getStartTraceBlamePoint();
            }
            cursor = cursor.getPreviousBlamePoint();
        }
        return null;
    }

    public static IBlameTransactionElement getAutomaticEntryPointElementForCalledBackendMetrics(IBlameTransactionElement result) {
        IBlameTransactionElement cursor = result;
        while (cursor != null) {
            if (cursor.isAutomaticEntryPoint()) {
                return cursor.getStartTraceBlamePoint();
            }
            cursor = cursor.getPreviousBlamePoint();
        }
        return null;
    }

    public static IBlameTransactionElement getBackendElementInStack(IBlameTransactionElement result) {
        IBlameTransactionElement cursor = result;
        while (cursor != null) {
            if (cursor.isBackend()) {
                return cursor.getStartTraceBlamePoint();
            }
            cursor = cursor.getPreviousBlamePoint();
        }
        return null;
    }

    @Override
    public ITransactionElement getElementOnEndTrace(Object key, int tracerIndex, IStackElement dataElement, ITransactionElement parent) {
        InvocationData data = (InvocationData)dataElement;
        WilyTransactionElement result = (WilyTransactionElement)super.getElementOnEndTrace(key, tracerIndex, data, parent);
        IBlameTransactionElement start = (IBlameTransactionElement)data.getStartCursorAt(tracerIndex);
        IBlameTransactionElement previous = start.getPreviousBlamePoint();
        if (previous != null) {
            String metricName = data.getComponentNameAt(tracerIndex);
            String calledPrefix = BackendTracer.getCalledPrefix(previous);
            if (this.shouldForceStandardBlameMetrics()) {
                AgentMetric[] stallMetric = this.createStallsMetric(String.valueOf(calledPrefix) + this.getStallsMetricName(metricName));
                result.addMetric(stallMetric, result.fStallsDataStructure);
            }
        }
        return result;
    }

    @Override
    protected String getAppMapName(Object key, InvocationData data, int tracerIndex, String fallBack) {
        INameFormatter myFormatter = this.getCustomNameFormatter();
        if (myFormatter != null) {
            String result = myFormatter.INameFormatter_format(appMapFormatter, data);
            return result;
        }
        return fallBack;
    }

    @Override
    protected int getBlameStatus() {
        return 2;
    }
}

