/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.cas.ABlameMetricHolder;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.IErrorSubscriber;
import com.wily.introscope.agent.trace.cas.IFaultSubscriber;
import com.wily.introscope.agent.trace.cas.IMetricHolder;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedElement;
import com.wily.introscope.agent.trace.cas.IStallSubscriber;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionElementProvider;
import com.wily.introscope.agent.trace.cas.IUpdater;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.spec.metric.AgentMetric;
import java.util.Iterator;
import java.util.Map;

public class SocketTransactionElement
implements IBlameTransactionElement,
IMetricHolder {
    private final String socketName;
    private final int fPosition;
    private final short fDepth;
    private final String description;
    private volatile String fHostAddress;
    private volatile String fLocalAddress;
    private volatile String fHostName;
    private volatile int fPort;
    private final ITransactionElement fParent;
    private final IBlameTransactionElement fBlameParent;
    private final IBlameTransactionElement fFrontend;
    private final boolean fIsHasMetrics;
    private final IMetricHolder metricHolder;
    final IRepository fTimerDataStructure;
    final IRepository fPerIntervalDataStructure;
    final IRepository fErrorDataStructure;
    private volatile int fAppMapAgingStamp = -1;

    public SocketTransactionElement(String componentName, ITransactionElement parent) {
        this.socketName = componentName;
        this.fParent = parent;
        this.fBlameParent = null;
        this.fHostAddress = null;
        this.fLocalAddress = null;
        this.fHostName = null;
        this.fPort = 0;
        this.fFrontend = null;
        this.fTimerDataStructure = new NullTimerDataStructure();
        this.fPerIntervalDataStructure = new NullPerIntervalDataStructure();
        this.fErrorDataStructure = new NullErrorDataStructure();
        this.metricHolder = new ABlameMetricHolder(null);
        this.fIsHasMetrics = false;
        this.fPosition = componentName == null ? 0 : componentName.lastIndexOf(":");
        this.fDepth = WilyTransactionStructure.getDepth(this.fParent);
        this.description = SocketTransactionElement.evaluateDescription(componentName);
    }

    public SocketTransactionElement(String componentName, IBlameTransactionElement parent, IBlameTransactionElement frontend, Map agentMetrics, IRepository timerSds, IRepository perIntervalSds, IRepository errorSds) {
        this.socketName = componentName;
        this.fParent = parent;
        this.fBlameParent = parent;
        this.fHostAddress = null;
        this.fHostName = null;
        this.fPort = 0;
        this.fFrontend = frontend;
        this.fTimerDataStructure = timerSds != null ? timerSds : new NullTimerDataStructure();
        this.fPerIntervalDataStructure = perIntervalSds != null ? perIntervalSds : new NullPerIntervalDataStructure();
        this.fErrorDataStructure = errorSds != null ? errorSds : new NullErrorDataStructure();
        this.metricHolder = new ABlameMetricHolder(agentMetrics);
        this.fIsHasMetrics = true;
        this.fPosition = componentName == null ? 0 : componentName.lastIndexOf(":");
        this.fDepth = WilyTransactionStructure.getDepth(this.fParent);
        this.description = SocketTransactionElement.evaluateDescription(componentName);
    }

    public void setSocketInfo(String hostAddress, String hostName, String localAddress, int port) {
        this.fHostAddress = hostAddress;
        this.fLocalAddress = localAddress;
        this.fHostName = hostName;
        this.fPort = port;
    }

    public String getHostAddress() {
        return this.fHostAddress;
    }

    public String getLocalAddress() {
        return this.fLocalAddress;
    }

    public String getHostName() {
        return this.fHostName;
    }

    public int getPort() {
        return this.fPort;
    }

    @Override
    public IBlameTransactionElement getPreviousBlamePoint() {
        return this.fFrontend;
    }

    @Override
    public IBlameTransactionElement getStartTraceBlamePoint() {
        return this.fBlameParent != null ? this.fBlameParent.getStartTraceBlamePoint() : null;
    }

    @Override
    public boolean isBackend() {
        return true;
    }

    @Override
    public boolean isFrontend() {
        return false;
    }

    @Override
    public int countChildren() {
        return 0;
    }

    @Override
    public ITransactionElement getParent() {
        return this.fParent;
    }

    @Override
    public ITransactionElement goToChild(Object key, ITransactionElementProvider provider) {
        return null;
    }

    @Override
    public ITransactionElement goToChild(Object keyToNextStep, IStackElement currentData, ITransactionElementProvider elementProvider) {
        return null;
    }

    @Override
    public ITransactionElement goToChildEndTransaction(Object key, int tracerIndex, IStackElement data, ITransactionElementProvider provider) {
        return null;
    }

    @Override
    public ITransactionElement goToChildStartTransaction(Object key, int tracerIndex, IStackElement data, ITransactionElementProvider provider) {
        return null;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public boolean isLastInTransaction() {
        return false;
    }

    @Override
    public Iterator iterateChildren() {
        return null;
    }

    @Override
    public void terminateTransaction(String endKey) {
    }

    @Override
    public void addMetric(AgentMetric[] addedMetric, IRepository structure) {
        this.metricHolder.addMetric(addedMetric, structure);
    }

    @Override
    public void addMetric(AgentMetric addedMetric, IRepository structure) {
        this.metricHolder.addMetric(addedMetric, structure);
    }

    @Override
    public Iterator getMetrics() {
        return this.metricHolder.getMetrics();
    }

    public IRepository getPerIntervalRepository() {
        return this.fPerIntervalDataStructure;
    }

    public IRepository getTimerRepository() {
        return this.fTimerDataStructure;
    }

    public IRepository getErrorRepository() {
        return this.fErrorDataStructure;
    }

    public String getSocketDescription() {
        return this.description;
    }

    @Override
    public IErrorSubscriber getErrorSubscriber() {
        return null;
    }

    @Override
    public IStallSubscriber getStallSubscriber() {
        return null;
    }

    @Override
    public IFaultSubscriber getFaultSubscriber() {
        return null;
    }

    @Override
    public ITransactionElement touch(long now) {
        return this;
    }

    @Override
    public ITransactionElement touch() {
        return this.getParent();
    }

    @Override
    public void markReadTime(long readTime) {
    }

    @Override
    public boolean wasTouchedSinceLastReadTime() {
        return true;
    }

    @Override
    public ITransactionElement getNextOnEndTransaction() {
        return this.getParent();
    }

    @Override
    public long getFilterEnablerBit() {
        return 0L;
    }

    @Override
    public long lastTouched() {
        return this.fParent.lastTouched();
    }

    @Override
    public void notifyPublished() {
    }

    @Override
    public void notifyRemoved() {
    }

    @Override
    public boolean hasBackendInStack() {
        return this.fBlameParent != null ? this.fBlameParent.hasBackendInStack() : false;
    }

    @Override
    public String getComponentName() {
        return this.socketName;
    }

    public boolean hasMetrics() {
        return this.fIsHasMetrics;
    }

    @Override
    public boolean isNotValid() {
        return this.getParent().isNotValid();
    }

    @Override
    public String getResourceName() {
        return this.socketName == null || this.fPosition <= 0 ? this.socketName : this.socketName.substring(0, this.fPosition);
    }

    @Override
    public short getDepth() {
        return this.fDepth;
    }

    @Override
    public int getAgentFeatureIndicant() {
        return 0;
    }

    @Override
    public void setAgentFeatureIndicant(int agentFeatureIndicant) {
    }

    @Override
    public void resetAppMapStamp() {
    }

    public boolean needToSendAppMapAgain(int currentCounter) {
        int stamp = this.fAppMapAgingStamp;
        if (stamp != currentCounter) {
            this.fAppMapAgingStamp = currentCounter;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAutomaticEntryPoint() {
        return false;
    }

    private static String evaluateDescription(String componentName) {
        if (componentName != null) {
            int index = componentName.lastIndexOf("|");
            if (index != -1) {
                return componentName.substring(index + "|".length());
            }
            return componentName;
        }
        return "Not Available";
    }

    private final class NullErrorDataStructure
    implements IRepository {
        private NullErrorDataStructure() {
        }

        @Override
        public void offer(ISharedElement offered) {
        }

        @Override
        public ISharedElement get() {
            return null;
        }

        @Override
        public void update(IUpdater updater, long value, long startTime, int hashcode) {
        }

        @Override
        public void update(IUpdater updater, long value, long startTime, long endTime) {
        }

        @Override
        public ISharedElement read(ISharedElement readTarget) {
            return null;
        }

        @Override
        public ISharedElement read() {
            return null;
        }

        @Override
        public ISharedElement read(IRepository.IRepositorySustainabilityCallback callback) {
            return null;
        }

        @Override
        public void reset() {
        }

        @Override
        public void cleanup(boolean offerBack) {
        }

        @Override
        public boolean hasNotChanged() {
            return false;
        }

        @Override
        public boolean shouldBeHarvested() {
            return false;
        }

        @Override
        public void setShutOff(boolean shutOff) {
        }

        @Override
        public boolean isShutOff() {
            return false;
        }
    }

    private final class NullPerIntervalDataStructure
    implements IRepository {
        private NullPerIntervalDataStructure() {
        }

        @Override
        public ISharedElement get() {
            return null;
        }

        @Override
        public void offer(ISharedElement offered) {
        }

        @Override
        public ISharedElement read() {
            return null;
        }

        @Override
        public void reset() {
        }

        @Override
        public void update(IUpdater updater, long value, long startTime, long endTime) {
        }

        @Override
        public boolean hasNotChanged() {
            return true;
        }

        @Override
        public boolean shouldBeHarvested() {
            return false;
        }

        public void update(IUpdater updater, long value, long startTime, long endTime, int hashcode) {
        }

        @Override
        public ISharedElement read(ISharedElement readTarget) {
            return null;
        }

        @Override
        public ISharedElement read(IRepository.IRepositorySustainabilityCallback callback) {
            return null;
        }

        @Override
        public void update(IUpdater updater, long value, long startTime, int hashcode) {
        }

        @Override
        public void cleanup(boolean offerBack) {
        }

        @Override
        public void setShutOff(boolean shutOff) {
        }

        @Override
        public boolean isShutOff() {
            return false;
        }
    }

    private final class NullTimerDataStructure
    implements IRepository {
        private NullTimerDataStructure() {
        }

        @Override
        public ISharedElement get() {
            return null;
        }

        @Override
        public void offer(ISharedElement offered) {
        }

        @Override
        public ISharedElement read() {
            return null;
        }

        @Override
        public void reset() {
        }

        @Override
        public void update(IUpdater updater, long value, long startTime, long endTime) {
        }

        @Override
        public boolean hasNotChanged() {
            return true;
        }

        @Override
        public boolean shouldBeHarvested() {
            return false;
        }

        public void update(IUpdater updater, long value, long startTime, long endTime, int hashcode) {
        }

        @Override
        public ISharedElement read(ISharedElement readTarget) {
            return null;
        }

        @Override
        public ISharedElement read(IRepository.IRepositorySustainabilityCallback callback) {
            return null;
        }

        @Override
        public void update(IUpdater updater, long value, long startTime, int hashcode) {
        }

        @Override
        public void cleanup(boolean offerBack) {
        }

        @Override
        public void setShutOff(boolean shutOff) {
        }

        @Override
        public boolean isShutOff() {
            return false;
        }
    }
}

