/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.transactiontrace;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import com.wily.util.properties.hot.PositiveLongConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.util.concurrent.atomic.AtomicInteger;

public class SamplingHelper {
    private static long fSamplingIntervalInSeconds;
    private static int fSamplesPerInterval;
    private static volatile TimesliceCountdownBehavior fCountdownBehavior;
    private static IntervalHeartbeat fHeartbeat;
    private static IModuleFeedbackChannel fFeedback;
    private static IRegisteredBehavior fSamplingBehaviorNode;
    private static volatile boolean fSamplingBehaviorSetInAgentProfileProperties;
    private static volatile boolean fInitialize;
    private static volatile boolean fSamplingPropertyEnabled;
    private static volatile IAgent fAgent;

    static {
        fSamplingBehaviorSetInAgentProfileProperties = false;
        fInitialize = false;
        fSamplingPropertyEnabled = true;
    }

    public static void initIfNeccessary() {
        if (fInitialize) {
            return;
        }
        fInitialize = true;
        try {
            IntervalHeartbeat hb;
            if (fAgent == null) {
                fAgent = AgentShim.getAgent();
            }
            IModuleFeedbackChannel feedback = fAgent.IAgent_getModuleFeedback();
            IStringLocalizer localizer = fAgent.IAgent_getStringLocalizer();
            IndexedProperties indexedProperties = fAgent.IAgent_getIndexedProperties();
            fHeartbeat = hb = fAgent.IAgent_getConfigHeartbeat();
            fFeedback = feedback;
            ConfigurationManager cm = fAgent.IAgent_getConfigurationManager();
            if (cm != null) {
                SamplingHelper.defineConfigurationProperties(cm, fAgent.IAgent_getModule(), feedback, localizer);
            } else {
                feedback.warn("Sampling properties could not be initialized because the configuration manager was not found");
            }
            if (indexedProperties.getProperty("introscope.agent.transactiontracer.sampling.perinterval.count") != null || indexedProperties.getProperty("introscope.agent.transactiontracer.sampling.interval.seconds") != null) {
                fSamplingBehaviorSetInAgentProfileProperties = true;
                fFeedback.info(localizer.IStringLocalizer_getFormattedLocalizedString("Agent_Transaction_Trace_Sampling_Interval_Set_Message", String.valueOf(fSamplingIntervalInSeconds)));
                fFeedback.info(localizer.IStringLocalizer_getFormattedLocalizedString("Agent_Transaction_Trace_Samples_Per_Interval_Set_Message", String.valueOf(fSamplesPerInterval)));
            } else {
                fSamplingBehaviorSetInAgentProfileProperties = false;
            }
            if (fSamplesPerInterval <= 0) {
                fFeedback.warn("Bad value for introscope.agent.transactiontracer.sampling.perinterval.count, reverting to default");
                fSamplesPerInterval = 1;
            }
            if (fSamplingIntervalInSeconds <= 0L) {
                fFeedback.warn("Bad value for introscope.agent.transactiontracer.sampling.interval.seconds, reverting to default");
                fSamplingIntervalInSeconds = 120L;
            }
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            fInitialize = false;
        }
    }

    public static boolean isSamplingSetInAgentProperties() {
        return fSamplingBehaviorSetInAgentProfileProperties;
    }

    private static void defineConfigurationProperties(ConfigurationManager configManager, Module module, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        configManager.add(new PositiveIntegerConfigurationProperty("introscope.agent.transactiontracer.sampling.perinterval.count", new Integer(1), "Hot_Property_Configuration_Property", feedback, module, localizer){

            public void set(Object value) {
                int val = (Integer)value;
                if (val > 0) {
                    fSamplingBehaviorSetInAgentProfileProperties = true;
                    SamplingHelper.updateSamplesPerIntervalInternal((Integer)value);
                }
            }
        });
        configManager.add(new PositiveLongConfigurationProperty("introscope.agent.transactiontracer.sampling.interval.seconds", new Long(120L), "Hot_Property_Configuration_Property", feedback, module, localizer){

            public void set(Object value) {
                long val = (Long)value;
                if (val > 0L) {
                    fSamplingBehaviorSetInAgentProfileProperties = true;
                    SamplingHelper.updateSamplingDurationInternal(val);
                }
            }
        });
        configManager.add(new BooleanConfigurationProperty("introscope.agent.transactiontracer.sampling.enabled", Boolean.TRUE, feedback, module, localizer){

            public void set(Object newValue) {
                fSamplingPropertyEnabled = (Boolean)newValue;
                if (!fSamplingPropertyEnabled) {
                    SamplingHelper.stopSampling();
                }
            }
        });
    }

    private static void createSamplingBehaviorNode() {
        if (SamplingHelper.isSamplingEnabled()) {
            fCountdownBehavior = new TimesliceCountdownBehavior(fSamplesPerInterval);
            fSamplingBehaviorNode = fHeartbeat.addBehavior((ITimestampedRunnable)fCountdownBehavior, "TT Sampling Per Interval", true, fSamplingIntervalInSeconds * 1000L, true);
        }
    }

    public static boolean isSamplingEnabled() {
        return fSamplingPropertyEnabled;
    }

    public static void updateSamplingDuration(long samplingInterval) {
        SamplingHelper.initIfNeccessary();
        SamplingHelper.updateSamplingDurationInternal(samplingInterval);
    }

    private static void updateSamplingDurationInternal(long samplingInterval) {
        Assertion.wilyAssert(samplingInterval > 0L);
        if (samplingInterval > 0L) {
            if (fSamplingBehaviorNode != null) {
                fHeartbeat.removeBehavior(fSamplingBehaviorNode);
            }
            fSamplingIntervalInSeconds = samplingInterval;
            SamplingHelper.createSamplingBehaviorNode();
        }
    }

    public static void stopSampling() {
        fHeartbeat.removeBehavior(fSamplingBehaviorNode);
    }

    public static void updateSamplesPerInterval(int samplesPerInterval) {
        SamplingHelper.initIfNeccessary();
        SamplingHelper.updateSamplesPerIntervalInternal(samplesPerInterval);
    }

    private static void updateSamplesPerIntervalInternal(int samplesPerInterval) {
        Assertion.wilyAssert(samplesPerInterval > 0);
        if (samplesPerInterval > 0) {
            if (fSamplingBehaviorNode != null) {
                fHeartbeat.removeBehavior(fSamplingBehaviorNode);
            }
            fSamplesPerInterval = samplesPerInterval;
            SamplingHelper.createSamplingBehaviorNode();
        }
    }

    public static boolean samplingCountdownNotExpired() {
        if (SamplingHelper.isSamplingEnabled() && fCountdownBehavior != null) {
            boolean exp = fCountdownBehavior.hasNotExpired();
            return exp;
        }
        return false;
    }

    private static final class TimesliceCountdownBehavior
    implements ITimestampedRunnable {
        private AtomicInteger fCountdown = new AtomicInteger();
        private final int fInitialCountdownValue;

        public TimesliceCountdownBehavior(int initialValue) {
            this.fInitialCountdownValue = initialValue;
            this.fCountdown.set(initialValue);
        }

        public boolean hasNotExpired() {
            return this.fCountdown.getAndDecrement() > 0;
        }

        public void ITimestampedRunnable_execute(long nowInMillis) {
            this.fCountdown.set(this.fInitialCountdownValue);
        }
    }
}

