/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.util;

import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class ByteClassUtil {
    public static final int CLASS_MAGIC = -889275714;
    private static char kDotSeparator = (char)46;
    private static char kJarSeparator = (char)47;
    private static String kClassExtension = ".class";

    public static byte[] getBytesForClass(Class cls, int limit, IModuleFeedbackChannel feedback) throws IOException {
        return ByteClassUtil.getBytesForClass(cls, limit, feedback, false);
    }

    public static byte[] getBytesForClass(Class cls, int limit, IModuleFeedbackChannel feedback, boolean doSimpleClassNameSearch) throws IOException {
        byte[] byArray;
        feedback.debug("getting bytes for class -" + cls.getName());
        InputStream is = null;
        ClassLoader classLoader = cls.getClassLoader();
        if (classLoader == null) {
            return ByteClassUtil.getBytesForClassUsingClass(cls, limit, feedback);
        }
        String path = String.valueOf(cls.getName().replace(kDotSeparator, kJarSeparator)) + kClassExtension;
        feedback.debug("searching for path -" + path);
        try {
            byte[] classBytes;
            URL url;
            is = classLoader.getResourceAsStream(path);
            if (is == null && doSimpleClassNameSearch && (url = classLoader.getResource(String.valueOf(cls.getSimpleName()) + kClassExtension)) != null) {
                feedback.debug("Simple ClassName search succcessful. URL Path is: " + url.getPath());
                is = url.openStream();
            }
            if (is == null) {
                throw new IOException("input stream null");
            }
            byArray = classBytes = ByteClassUtil.getBytesForClass(is, limit, feedback);
        }
        catch (Throwable throwable) {
            try {
                is.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            is.close();
        }
        catch (Exception exception) {}
        return byArray;
    }

    public static byte[] getBytesForClass(ClassLoader classLoader, String className, int limit, IModuleFeedbackChannel feedback) throws IOException {
        byte[] byArray;
        feedback.debug("getting bytes for class -" + className);
        InputStream is = null;
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        String path = String.valueOf(className.replace(kDotSeparator, kJarSeparator)) + kClassExtension;
        feedback.debug("searching for path -" + path);
        try {
            byte[] classBytes;
            is = classLoader.getResourceAsStream(path);
            if (is == null) {
                throw new IOException("input stream null");
            }
            byArray = classBytes = ByteClassUtil.getBytesForClass(is, limit, feedback);
        }
        catch (Throwable throwable) {
            try {
                is.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            is.close();
        }
        catch (Exception exception) {}
        return byArray;
    }

    public static byte[] getBytesForClassUsingClass(Class cls, int limit, IModuleFeedbackChannel feedback) throws IOException {
        byte[] byArray;
        feedback.debug("getting bytes for class -" + cls.getName());
        InputStream is = null;
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        String path = String.valueOf(cls.getName().replace(kDotSeparator, kJarSeparator)) + kClassExtension;
        feedback.debug("searching for path -" + path);
        try {
            byte[] classBytes;
            is = cl.getResourceAsStream(path);
            if (is == null) {
                throw new IOException("input stream null");
            }
            byArray = classBytes = ByteClassUtil.getBytesForClass(is, limit, feedback);
        }
        catch (Throwable throwable) {
            try {
                is.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            is.close();
        }
        catch (Exception exception) {}
        return byArray;
    }

    public static int byteArrayToInt(byte[] b, int offset) {
        int value = 0;
        int i = 0;
        while (i < 4) {
            int shift = (3 - i) * 8;
            value += (b[i + offset] & 0xFF) << shift;
            ++i;
        }
        return value;
    }

    /*
     * Exception decompiling
     */
    private static byte[] getBytesForClass(InputStream is, int classFileSizeLimit, IModuleFeedbackChannel feedback) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

