/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.metric;

import com.wily.introscope.spec.metric.AgentMetricPrefix;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.StringParser;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.ILocalizableMessage;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class AgentMetricPrefixParser
extends StringParser {
    private static final long serialVersionUID = -6149192976402019754L;

    public AgentMetricPrefixParser(String fullName) throws BadlyFormedNameException {
        super('|', fullName);
        this.validate();
    }

    public AgentMetricPrefixParser(String[] segments) throws BadlyFormedNameException {
        super('|', segments);
        this.validate();
    }

    public AgentMetricPrefixParser(String[] segments, int startIndex, int count) throws BadlyFormedNameException {
        super('|', segments, startIndex, count);
        this.validate();
    }

    public AgentMetricPrefixParser(AgentMetricPrefix prefixPath, AgentMetricPrefix suffixPath) throws BadlyFormedNameException {
        super('|', AgentMetricPrefix.computeAggregatePathString(prefixPath, suffixPath));
        this.validate();
    }

    public AgentMetricPrefixParser(AgentMetricPrefix prefixPath, String suffixString) throws BadlyFormedNameException {
        super('|', AgentMetricPrefix.computeAggregatePathString(prefixPath, suffixString));
        this.validate();
    }

    public AgentMetricPrefixParser(String prefixString, AgentMetricPrefix suffixPath) throws BadlyFormedNameException {
        super('|', AgentMetricPrefix.computeAggregatePathString(prefixString, suffixPath));
        this.validate();
    }

    public AgentMetricPrefixParser() {
    }

    private void validate() throws BadlyFormedNameException {
        int i = 0;
        while (i < this.getSegmentCount()) {
            this.validateSegment(this.getSegment(i));
            ++i;
        }
    }

    private void validateSegment(String segment) throws BadlyFormedNameException {
        if (segment == null || segment.length() == 0) {
            FormattedLocalizableMessage message = new FormattedLocalizableMessage("Metric_Name_Is_Badly_Formed", this.getEntireString(), false);
            throw new BadlyFormedNameException("illegal empty segment in: " + segment + " from: " + this.getEntireString(), (ILocalizableMessage)message);
        }
        if (segment.indexOf("|") != -1) {
            FormattedLocalizableMessage message = new FormattedLocalizableMessage("Metric_Name_Is_Badly_Formed", this.getEntireString(), false);
            throw new BadlyFormedNameException("illegal character in: " + segment + " from: " + this.getEntireString(), (ILocalizableMessage)message);
        }
        if (segment.indexOf(58) != -1) {
            FormattedLocalizableMessage message = new FormattedLocalizableMessage("Metric_Name_Is_Badly_Formed", this.getEntireString(), false);
            throw new BadlyFormedNameException("illegal character in: " + segment + " from: " + this.getEntireString(), (ILocalizableMessage)message);
        }
    }

    public boolean containsSegmentWithPrefix(String prefix) {
        int i = 0;
        while (i < this.getSegmentCount()) {
            if (this.getSegment(i).startsWith(prefix)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final void smartWriteExternal(ObjectOutput out) throws IOException {
        super.smartWriteExternal(out);
    }

    public static AgentMetricPrefixParser smartReadExternalESEPathParser(ObjectInput in) throws IOException, ClassNotFoundException {
        AgentMetricPrefixParser parser = new AgentMetricPrefixParser();
        parser.readExternal(in);
        return parser;
    }
}

