/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.stat.gatherer;

import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.gatherer.ALongCombiningGatherer;
import com.wily.introscope.stat.timeslice.LongTimeslicedValue;
import com.wily.math.RunningLongAverage;

public class LongAverageGatherer
extends ALongCombiningGatherer {
    private long fMinimum;
    private long fMaximum;
    private RunningLongAverage fRunningAverage = new RunningLongAverage();
    private static final long kMaxCount = 200000L;
    private static final long kMaxValue = 3000000L;

    public LongAverageGatherer(int typeCookie, long startTimestamp) {
        super(typeCookie, startTimestamp);
    }

    public long getLongValue() {
        return this.fRunningAverage.getAverage();
    }

    public long getLongMinimum() {
        return this.fMinimum;
    }

    public long getLongMaximum() {
        return this.fMaximum;
    }

    protected void directSetLongMinimum(long minimum) {
        this.fMinimum = minimum;
    }

    protected void directSetLongMaximum(long maximum) {
        this.fMaximum = maximum;
    }

    public synchronized void recordOneDataPoint(long value) {
        this.fRunningAverage.combineValue(value);
        this.syncSinglePointBounds(value);
        this.incrementDataPointCountNonSync();
        this.noteDataIsPresent();
    }

    protected void doAcceptAggregateLongTimeslicedValue(LongTimeslicedValue typedAggregate) {
        if (typedAggregate.getDataPointCount() != 0L) {
            long count = typedAggregate.getDataPointCount();
            long avg = typedAggregate.getValue();
            long min = typedAggregate.getMinimum();
            long max = typedAggregate.getMaximum();
            this.fRunningAverage.combineValue(avg, count, min, max);
            this.syncAggregateBounds(typedAggregate);
            this.addToDataPointCount(typedAggregate.getDataPointCount());
        }
    }

    protected void doResetCombiningGatherer(long when) {
        this.whackInternalState();
    }

    protected void doReinitializeCombiningGatherer() {
        this.whackInternalState();
    }

    private void whackInternalState() {
        this.directSetLongMinimum(0L);
        this.directSetLongMaximum(0L);
        this.fRunningAverage.reset();
    }

    private static long fastLongWeightedAverage(long value1, long count1, long value2, long count2) {
        if (count1 > 200000L || count2 > 200000L || value1 > 3000000L || value2 > 3000000L) {
            double total = (double)value1 * (double)count1 + (double)value2 * (double)count2;
            return (long)(total /= (double)count1 + (double)count2);
        }
        return (value1 * (long)((int)count1) + value2 * (long)((int)count2)) / (long)((int)count1 + (int)count2);
    }

    public static IMetricDataValue aggregateByTime(IMetricDataValue pvalue1, IMetricDataValue pvalue2) {
        LongTimeslicedValue value1 = (LongTimeslicedValue)pvalue1;
        LongTimeslicedValue value2 = (LongTimeslicedValue)pvalue2;
        if (value1.dataIsAbsent() || value2.dataIsAbsent()) {
            return LongAverageGatherer.absentLong(value1, value2);
        }
        long count = value1.getDataPointCount() + value2.getDataPointCount();
        long min = Math.min(value1.getMinimum(), value2.getMinimum());
        long max = Math.max(value1.getMaximum(), value2.getMaximum());
        long avg = LongAverageGatherer.fastLongWeightedAverage(value1.getValue(), value1.getDataPointCount(), value2.getValue(), value2.getDataPointCount());
        return new LongTimeslicedValue(value1.getType(), value1.getStartTimestampInMillis(), value2.getStopTimestampInMillis(), null, count, false, avg, min, max);
    }
}

