/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent;

import com.wily.introscope.agent.ICEMFilterListener;
import com.wily.introscope.agent.enterprise.IServerConnectionObserver;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.server.transactiontrace.AFilterListTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.AndTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.CEMBusinessTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.ITransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.OrTransactionTraceFilter;
import java.util.ArrayList;
import java.util.HashMap;

public class CEMFilterHelper
implements ICEMFilterListener,
IServerConnectionObserver {
    private static CEMFilterHelper kInstance = new CEMFilterHelper();
    private static HashMap kPublishedBTs = new HashMap();

    private CEMFilterHelper() {
    }

    public static CEMFilterHelper getInstance() {
        return kInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cemFilterCreated(CEMBusinessTransactionTraceFilter cemFilterInfo) {
        HashMap hashMap = kPublishedBTs;
        synchronized (hashMap) {
            Integer openBtSessions = (Integer)kPublishedBTs.get(cemFilterInfo.getBusinessTransactionName());
            openBtSessions = openBtSessions == null ? new Integer(1) : new Integer(openBtSessions + 1);
            kPublishedBTs.put(cemFilterInfo.getBusinessTransactionName(), openBtSessions);
        }
    }

    public void cemFilterCreated(CEMBusinessTransactionTraceFilter[] cemFilterInfo) {
        int i = 0;
        while (i < cemFilterInfo.length) {
            this.cemFilterCreated(cemFilterInfo[i]);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cemFilterRemoved(CEMBusinessTransactionTraceFilter cemFilter) {
        HashMap hashMap = kPublishedBTs;
        synchronized (hashMap) {
            Integer openBtSessions = (Integer)kPublishedBTs.get(cemFilter.getBusinessTransactionName());
            if (openBtSessions != null) {
                int count = openBtSessions;
                if (count == 1) {
                    kPublishedBTs.remove(cemFilter.getBusinessTransactionName());
                } else {
                    kPublishedBTs.put(cemFilter.getBusinessTransactionName(), new Integer(count - 1));
                }
            }
        }
    }

    public void cemFilterRemoved(CEMBusinessTransactionTraceFilter[] cemFilterInfo) {
        int i = 0;
        while (i < cemFilterInfo.length) {
            this.cemFilterRemoved(cemFilterInfo[i]);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTraceRequestedFor(String btName) {
        HashMap hashMap = kPublishedBTs;
        synchronized (hashMap) {
            return kPublishedBTs.containsKey(btName);
        }
    }

    public void agentControlAddTTFilter(ITransactionTraceFilter filter) {
        AndTransactionTraceFilter cemAndThresholdTransactionTraceFilter;
        CEMBusinessTransactionTraceFilter[] containedCEMFilterArray;
        if (filter instanceof AndTransactionTraceFilter && (containedCEMFilterArray = this.getContainedCEMFilters(cemAndThresholdTransactionTraceFilter = (AndTransactionTraceFilter)filter)) != null) {
            this.cemFilterCreated(containedCEMFilterArray);
        }
    }

    public void agentControlRemoveTTFilter(ITransactionTraceFilter filter) {
        AndTransactionTraceFilter cemAndThresholdTransactionTraceFilter;
        CEMBusinessTransactionTraceFilter[] containedCEMFilterArray;
        if (filter instanceof AndTransactionTraceFilter && (containedCEMFilterArray = this.getContainedCEMFilters(cemAndThresholdTransactionTraceFilter = (AndTransactionTraceFilter)filter)) != null) {
            this.cemFilterRemoved(containedCEMFilterArray);
        }
    }

    public void agentControlSetReportingState(boolean report) {
    }

    public void agentControlStartReportingMetric(AgentMetric metric) {
    }

    public void agentControlStopReportingMetric(AgentMetric metric) {
    }

    public void serverConnected() {
    }

    public void serverConnectionCycleFailed(int cycleCount) {
    }

    public void serverDisconnected() {
    }

    public CEMBusinessTransactionTraceFilter[] getContainedCEMFilters(AndTransactionTraceFilter andCEMTransactionTraceFilter) {
        ArrayList<ITransactionTraceFilter> cemFilters = new ArrayList<ITransactionTraceFilter>();
        ITransactionTraceFilter[] fFilters = andCEMTransactionTraceFilter.getContainedTransactionFilters();
        int i = 0;
        while (i < fFilters.length) {
            int filterType = fFilters[i].ITransactionTraceFilter_getFilterType();
            if (CEMBusinessTransactionTraceFilter.getFilterType() == filterType) {
                cemFilters.add(fFilters[i]);
                return cemFilters.toArray(new CEMBusinessTransactionTraceFilter[0]);
            }
            if (OrTransactionTraceFilter.getFilterType() == filterType) {
                ITransactionTraceFilter[] filtersArray = ((AFilterListTransactionTraceFilter)fFilters[i]).getContainedTransactionFilters();
                int j = 0;
                while (j < filtersArray.length) {
                    filterType = filtersArray[j].ITransactionTraceFilter_getFilterType();
                    if (CEMBusinessTransactionTraceFilter.getFilterType() == filterType) {
                        cemFilters.add(filtersArray[j]);
                    }
                    ++j;
                }
                return cemFilters.toArray(new CEMBusinessTransactionTraceFilter[0]);
            }
            ++i;
        }
        return null;
    }
}

