/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.blame;

import com.wily.introscope.agent.blame.IAppMapStack;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.blame.IBoundaryBlameStack;
import com.wily.introscope.agent.blame.IComponentParameterCallback;
import com.wily.introscope.agent.blame.ISamplingStack;
import com.wily.introscope.agent.blame.IStackType;
import com.wily.introscope.spec.agent.beans.appmap.IAppMapDecisionSupportBean;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.wilyassert.Assertion;
import java.util.HashMap;

public final class CompoundBlameStack
implements IBoundaryBlameStack,
IBlameStack,
IAppMapStack,
ISamplingStack {
    private IBlameStack fDefaultBlameStack;
    private IBlameStack[] fDelegates;
    private int fDelegateIndex;
    private static final int kDelegateChunkSize = 3;
    private boolean fSamplingkSkipFlag = false;

    public CompoundBlameStack(IBlameStack defaultBlameStack) {
        this();
        this.setDefaultDelegate(defaultBlameStack);
        this.addDelegate(this.fDefaultBlameStack);
    }

    public CompoundBlameStack() {
        this.reinitialize();
    }

    public void reinitialize() {
        this.fDelegates = new IBlameStack[3];
        this.clearDelegates();
        this.fSamplingkSkipFlag = false;
    }

    public void addDelegate(IBlameStack delegate) {
        if (this.fDelegateIndex == this.fDelegates.length) {
            int oldSize = this.fDelegates.length;
            int newSize = oldSize + 3;
            IBlameStack[] newDelegatesArray = new IBlameStack[newSize];
            System.arraycopy(this.fDelegates, 0, newDelegatesArray, 0, oldSize);
            this.fDelegates = newDelegatesArray;
        }
        this.fDelegates[this.fDelegateIndex++] = delegate;
    }

    public void clearDelegates() {
        int i = 0;
        while (i < this.fDelegateIndex) {
            this.fDelegates[i] = null;
            ++i;
        }
        this.fDelegateIndex = 0;
    }

    public void setDefaultDelegate(IBlameStack defaultBlameStack) {
        this.fDefaultBlameStack = defaultBlameStack;
    }

    public void setDelegateAt(int index, IBlameStack newDelegate) {
        Assertion.wilyAssert(index < this.fDelegateIndex);
        this.fDelegates[index] = newDelegate;
    }

    public void IBlameStack_addComponent(String component) {
        int i = 0;
        while (i < this.fDelegateIndex) {
            this.fDelegates[i].IBlameStack_addComponent(component);
            ++i;
        }
    }

    public void IBlameStack_addComponent(String component, String paramName, String paramValue) {
        int i = 0;
        while (i < this.fDelegateIndex) {
            this.fDelegates[i].IBlameStack_addComponent(component, paramName, paramValue);
            ++i;
        }
    }

    public void IBlameStack_addComponent(String component, IComponentParameterCallback callback) {
        int i = 0;
        while (i < this.fDelegateIndex) {
            this.fDelegates[i].IBlameStack_addComponent(component, callback);
            ++i;
        }
    }

    public void IBlameStack_addExtraParameter(String paramName, String paramValue) {
        int i = 0;
        while (i < this.fDelegateIndex) {
            this.fDelegates[i].IBlameStack_addExtraParameter(paramName, paramValue);
            ++i;
        }
    }

    public void IBlameStack_removeComponent(String component) {
        int i = 0;
        while (i < this.fDelegateIndex) {
            this.fDelegates[i].IBlameStack_removeComponent(component);
            ++i;
        }
    }

    public BlameStackSnapshot IBlameStack_getSnapshot(String component) {
        return this.fDefaultBlameStack.IBlameStack_getSnapshot(component);
    }

    public boolean IBlameStack_isEmpty() {
        boolean result = true;
        int i = 0;
        while (i < this.fDelegateIndex) {
            result &= this.fDelegates[i].IBlameStack_isEmpty();
            ++i;
        }
        return result;
    }

    public void IBlameStack_tearDown() {
        int i = 0;
        while (i < this.fDelegateIndex) {
            this.fDelegates[i].IBlameStack_tearDown();
            ++i;
        }
    }

    public void setEndBoundary(String component) {
        int i = 0;
        while (i < this.fDelegateIndex) {
            this.fDelegates[i].setEndBoundary(component);
            ++i;
        }
    }

    public void setFrontBoundary(String component) {
        int i = 0;
        while (i < this.fDelegateIndex) {
            this.fDelegates[i].setFrontBoundary(component);
            ++i;
        }
    }

    public boolean hasFrontBoundary() {
        int i = 0;
        while (i < this.fDelegateIndex) {
            if (this.fDelegates[i].hasFrontBoundary()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean noteBoundaryError() {
        boolean result = false;
        int i = 0;
        while (i < this.fDelegateIndex) {
            boolean delegateResult = this.fDelegates[i].noteBoundaryError();
            result |= delegateResult;
            ++i;
        }
        return result;
    }

    public String[] getDefaultBackendData() {
        String[] result = null;
        int i = 0;
        while (result == null && i < this.fDelegateIndex) {
            result = this.fDelegates[i].getDefaultBackendData();
            ++i;
        }
        return result;
    }

    public void setDefaultBackendComponent(String componentToReplace, String backendComponent) {
        int i = 0;
        while (i < this.fDelegateIndex) {
            this.fDelegates[i].setDefaultBackendComponent(componentToReplace, backendComponent);
            ++i;
        }
    }

    public BlameStackSnapshot getDefaultBackendSnapshot() {
        BlameStackSnapshot result = BlameStackSnapshot.kEmptyBlameStackSnapshot;
        int i = 0;
        while (result == BlameStackSnapshot.kEmptyBlameStackSnapshot && i < this.fDelegateIndex) {
            result = this.fDelegates[i].getDefaultBackendSnapshot();
            ++i;
        }
        return result;
    }

    public void addRootParameter(String key, String value) {
        int i = 0;
        while (i < this.fDelegateIndex) {
            this.fDelegates[i].addRootParameter(key, value);
            ++i;
        }
    }

    public void endBoundaryPopped(String component) {
        int i = 0;
        while (i < this.fDelegateIndex) {
            this.fDelegates[i].endBoundaryPopped(component);
            ++i;
        }
    }

    public void frontBoundaryPopped(String component) {
        int i = 0;
        while (i < this.fDelegateIndex) {
            this.fDelegates[i].frontBoundaryPopped(component);
            ++i;
        }
    }

    public void addMapComponent(IStackType type, String component) {
        int i = 0;
        while (i < this.fDelegateIndex) {
            this.fDelegates[i].addMapComponent(type, component);
            ++i;
        }
    }

    public void addMapComponent(IStackType type, String component, String paramName, String paramVal) {
        int i = 0;
        while (i < this.fDelegateIndex) {
            this.fDelegates[i].addMapComponent(type, component, paramName, paramVal);
            ++i;
        }
    }

    public void removeMapComponent(IStackType type, String component, IComponentParameterCallback endCallback) {
        int i = 0;
        while (i < this.fDelegateIndex) {
            if (this.fDelegates[i] instanceof IAppMapStack) {
                ((IAppMapStack)this.fDelegates[i]).removeMapComponent(type, component, endCallback);
            }
            ++i;
        }
    }

    public void popMapComponent(IStackType type, String component) {
        int i = 0;
        while (i < this.fDelegateIndex) {
            this.fDelegates[i].popMapComponent(type, component);
            ++i;
        }
    }

    public boolean peekLastMapComponentWasMe(IStackType type, String component) {
        boolean result = false;
        int i = 0;
        while (i < this.fDelegateIndex) {
            if (this.fDelegates[i] instanceof IAppMapStack && (result |= ((IAppMapStack)this.fDelegates[i]).peekLastMapComponentWasMe(type, component))) break;
            ++i;
        }
        return result;
    }

    public void removeMapComponent(IStackType type, String component) {
        int i = 0;
        while (i < this.fDelegateIndex) {
            this.fDelegates[i].removeMapComponent(type, component);
            ++i;
        }
    }

    public boolean getHeadFilteringStatus() {
        int i = 0;
        while (i < this.fDelegateIndex) {
            if (this.fDelegates[i].getHeadFilteringStatus()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean shouldCurrentTraceBePropagated() {
        int i = 0;
        while (i < this.fDelegateIndex) {
            if (this.fDelegates[i].shouldCurrentTraceBePropagated()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addMapComponent(IStackType type, String component, HashMap params) {
        int i = 0;
        while (i < this.fDelegateIndex) {
            this.fDelegates[i].addMapComponent(type, component, params);
            ++i;
        }
    }

    public void setComponentMetricPropagateFlag(String component, int flag) {
        int i = 0;
        while (i < this.fDelegateIndex) {
            if (this.fDelegates[i] instanceof IBoundaryBlameStack) {
                ((IBoundaryBlameStack)((Object)this.fDelegates[i])).setComponentMetricPropagateFlag(component, flag);
            }
            ++i;
        }
    }

    public String toString() {
        String res = " ";
        int i = 0;
        while (i < this.fDelegateIndex) {
            res = String.valueOf(res) + " " + this.fDelegates[i].toString();
            ++i;
        }
        return res;
    }

    public boolean getSetSamplingSkipFlag() {
        return this.fSamplingkSkipFlag;
    }

    public void setSetSamplingSkipFlag(boolean flag) {
        this.fSamplingkSkipFlag = flag;
    }

    public void directAddMapComponent(String component, HashMap parameters) {
    }

    public void directRemoveMapComponent(String component, IComponentParameterCallback callback, IAppMapDecisionSupportBean.ICallBackOnSent callbackOnError) {
    }

    public void directAddMapComponent(String component, HashMap parameters, IAppMapDecisionSupportBean.ICallBackOnSent callbackOnError) {
    }

    public void directRemoveMapComponent(String component, IComponentParameterCallback callback) {
    }
}

