/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.websphere;

import com.ibm.websphere.classloader.ClassLoaderPlugin;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.api.websphere.WASPreprocessor;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class WASAutoProbe
implements WASPreprocessor,
ClassLoaderPlugin {
    private final boolean fEnabled = this.calculateEnabled();
    private final ClassLoaderPlugin[] fClassLoaderPlugins;
    private final WASPreprocessor[] fWASPreprocessorPlugins;

    public WASAutoProbe() {
        StringTokenizer st;
        String plugins = System.getProperty("com.wily.introscope.api.websphere.classloaderPlugins");
        ArrayList<Object> al = new ArrayList<Object>();
        if (plugins != null) {
            st = new StringTokenizer(plugins, ",");
            while (st.hasMoreElements()) {
                try {
                    al.add((ClassLoaderPlugin)Class.forName(st.nextToken()).newInstance());
                }
                catch (Throwable t) {
                    try {
                        AgentShim.handleError("A problem occurred while constructing class loader plugin: " + t.toString(), t);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        this.fClassLoaderPlugins = al.toArray(new ClassLoaderPlugin[al.size()]);
        plugins = System.getProperty("com.wily.introscope.api.websphere.waspreprocessorPlugins");
        al = new ArrayList();
        if (plugins != null) {
            st = new StringTokenizer(plugins, ",");
            while (st.hasMoreElements()) {
                try {
                    al.add((WASPreprocessor)Class.forName(st.nextToken()).newInstance());
                }
                catch (Throwable t) {
                    try {
                        AgentShim.handleError("A problem occurred while constructing WAS preprocessor plugin: " + t.toString(), t);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        this.fWASPreprocessorPlugins = al.toArray(new WASPreprocessor[al.size()]);
        AgentShim.ProbeBuilderEntryPoint_initializeAgentShim(null);
    }

    private boolean calculateEnabled() {
        String value = System.getProperty("com.wily.introscope.probebuilder.websphere.enable", Boolean.TRUE.toString());
        return Boolean.valueOf(value);
    }

    private boolean isEnabled() {
        return this.fEnabled;
    }

    private byte[] internalPreprocess(String className, byte[] classBytes) {
        if (this.isEnabled()) {
            try {
                byte[] result = AgentShim.ProbeBuilderEntryPoint_transformClass(false, null, className, null, null, classBytes);
                if (result != null) {
                    return result;
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {}
        }
        return classBytes;
    }

    public final void initialize(Hashtable parameters) {
        int index = 0;
        while (this.fWASPreprocessorPlugins.length > index) {
            try {
                this.fWASPreprocessorPlugins[index].initialize(parameters);
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("A problem occurred in WAS preprocessor plugin initialize: " + t.toString(), t);
                }
                catch (Throwable throwable) {}
            }
            ++index;
        }
    }

    public final byte[] preprocess(String className, byte[] classBytes) {
        byte[] retBytes = classBytes;
        int index = 0;
        while (this.fWASPreprocessorPlugins.length > index) {
            try {
                retBytes = this.fWASPreprocessorPlugins[index].preprocess(className, retBytes);
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("A problem occurred in WAS preprocessor plugin preprocess: " + t.toString(), t);
                }
                catch (Throwable throwable) {}
            }
            ++index;
        }
        return this.internalPreprocess(className, retBytes);
    }

    public final byte[] preDefineApplicationClass(String className, byte[] classBytes) {
        byte[] retBytes = classBytes;
        int index = 0;
        while (this.fClassLoaderPlugins.length > index) {
            try {
                retBytes = this.fClassLoaderPlugins[index].preDefineApplicationClass(className, retBytes);
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("A problem occurred in class loader plugin preDefineApplicationClass: " + t.toString(), t);
                }
                catch (Throwable throwable) {}
            }
            ++index;
        }
        return this.internalPreprocess(className, retBytes);
    }

    public final byte[] preDefineRuntimeClass(String className, byte[] classBytes) {
        byte[] retBytes = classBytes;
        int index = 0;
        while (this.fClassLoaderPlugins.length > index) {
            try {
                retBytes = this.fClassLoaderPlugins[index].preDefineRuntimeClass(className, retBytes);
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("A problem occurred in class loader plugin preDefineRuntimeClass: " + t.toString(), t);
                }
                catch (Throwable throwable) {}
            }
            ++index;
        }
        return this.internalPreprocess(className, retBytes);
    }
}

