/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.registry;

import com.wily.isengard.postoffice.Address;
import com.wily.isengard.postoffice.PostOfficeSpecifier;
import com.wily.isengard.util.tree.DirectoryEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class RegistryEntry
implements DirectoryEntry {
    private static final long serialVersionUID = 6906048295966804055L;
    private static final String kAddressName = "Address";
    private HashMap fMap = new HashMap();
    private int fCreationTime;
    private transient PostOfficeSpecifier fPostOffice;

    public RegistryEntry() {
        HashSet addresses = new HashSet();
        this.fMap.put(kAddressName, addresses);
    }

    public Set getAddresses() {
        return (Set)this.fMap.get(kAddressName);
    }

    public void addAddress(Address address) {
        this.getAddresses().add(address);
    }

    public void removeAddress(Address address) {
        this.getAddresses().remove(address);
    }

    public void setAddress(Address address) {
        Set addresses = this.getAddresses();
        addresses.clear();
        addresses.add(address);
    }

    public void setProperty(String name, Object value) {
        this.fMap.put(name, value);
    }

    public void setProperties(Map map) {
        this.fMap.putAll(map);
    }

    public Map getProperties() {
        return this.fMap;
    }

    public void setCreationTime(int time) {
        this.fCreationTime = time;
    }

    public int getCreationTime() {
        return this.fCreationTime;
    }

    public Address getAddress() {
        Set addresses = this.getAddresses();
        if (addresses.size() == 1) {
            return (Address)addresses.iterator().next();
        }
        return null;
    }

    public Object getProperty(String name) {
        return this.fMap.get(name);
    }

    public void setPostOffice(PostOfficeSpecifier po) {
        this.fPostOffice = po;
    }

    public PostOfficeSpecifier getPostOffice() {
        return this.fPostOffice;
    }

    public String toString() {
        Iterator i = this.fMap.keySet().iterator();
        String s = "";
        while (i.hasNext()) {
            String key = (String)i.next();
            Object value = this.fMap.get(key);
            s = String.valueOf(s) + "{" + key + ": " + value + "}";
        }
        return s;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.fCreationTime);
        out.writeObject(this.fMap);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fCreationTime = in.readInt();
        this.fMap = (HashMap)in.readObject();
    }
}

