/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.properties.lockable;

import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.io.ExtendedFile;
import com.wily.util.properties.lockable.ILocker;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class Locker
implements ILocker {
    private final ExtendedFile fLockFile;
    private FileLock fLock = null;
    private boolean fLocked = false;
    private IModuleFeedbackChannel fFeedback;
    private final Object fInprocessLock = new Object();

    public Locker(ExtendedFile physicalLockFile, IModuleFeedbackChannel feedback) {
        this.fLockFile = physicalLockFile;
        this.fFeedback = feedback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tryLock() {
        Object object = this.fInprocessLock;
        synchronized (object) {
            block21: {
                if (this.fLocked) return false;
                AbstractInterruptibleChannel channel = null;
                this.fLocked = true;
                try {
                    RandomAccessFile raf = new RandomAccessFile(this.fLockFile.getFile(), "rwd");
                    channel = raf.getChannel();
                    this.fLock = ((FileChannel)channel).tryLock();
                    this.fLocked = this.fLock != null;
                }
                catch (FileNotFoundException e) {
                    this.fLocked = false;
                    if (this.fFeedback != null && this.fFeedback.isDebugEnabled()) {
                        this.fFeedback.debug("Physical lock file not found", e);
                    }
                    if (this.fLock != null || channel == null) return this.fLocked;
                    try {
                        channel.close();
                    }
                    catch (IOException iOException) {}
                    break block21;
                }
                catch (IOException e) {
                    try {
                        this.fLocked = false;
                        if (this.fFeedback != null && this.fFeedback.isDebugEnabled()) {
                            this.fFeedback.debug("IO Error in locking physical lock file", e);
                        }
                        if (this.fLock != null || channel == null) return this.fLocked;
                    }
                    catch (Throwable throwable) {
                        if (this.fLock != null || channel == null) throw throwable;
                        try {
                            channel.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        channel.close();
                    }
                    catch (IOException iOException) {}
                    {
                        break block21;
                    }
                }
                if (this.fLock != null || channel == null) return this.fLocked;
                try {
                    channel.close();
                }
                catch (IOException iOException) {}
            }
            return this.fLocked;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.fInprocessLock;
        synchronized (object) {
            block19: {
                try {
                    try {
                        if (this.fLock != null) {
                            this.fLock.release();
                        }
                        this.fLocked = false;
                    }
                    catch (IOException e) {
                        if (this.fFeedback != null && this.fFeedback.isDebugEnabled()) {
                            this.fFeedback.debug("IO Error in unlocking physical lock file", e);
                        }
                        if (this.fLock != null) {
                            try {
                                this.fLock.channel().close();
                            }
                            catch (IOException iOException) {}
                            this.fLock = null;
                        }
                        this.fLocked = this.fLock != null;
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    if (this.fLock != null) {
                        try {
                            this.fLock.channel().close();
                        }
                        catch (IOException iOException) {}
                        this.fLock = null;
                    }
                    this.fLocked = this.fLock != null;
                    throw throwable;
                }
                if (this.fLock != null) {
                    try {
                        this.fLock.channel().close();
                    }
                    catch (IOException iOException) {}
                    this.fLock = null;
                }
                this.fLocked = this.fLock != null;
            }
        }
    }
}

