/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.install;

import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.version.IVersion;

public final class IntroscopeVersion
implements IVersion {
    private final String fReleaseString;
    private final String fBuildNumberString;

    private IntroscopeVersion() {
        this.fReleaseString = null;
        this.fBuildNumberString = null;
    }

    public IntroscopeVersion(IStringLocalizer localizer) {
        this.fReleaseString = localizer.IStringLocalizer_getLocalizedString("Release_String_Key");
        this.fBuildNumberString = localizer.IStringLocalizer_getLocalizedString("Build_Number_String_Key");
    }

    public String IVersion_getBuildNumberString() {
        return this.fBuildNumberString;
    }

    public String IVersion_getReleaseString() {
        return this.fReleaseString;
    }

    public String IVersion_getReleaseAndBuildString(IStringLocalizer localizer) {
        return localizer.IStringLocalizer_getFormattedLocalizedString("FormattedIntroscopeReleaseAndBuildString", this.IVersion_getReleaseString(), this.IVersion_getBuildNumberString());
    }

    public void IVersion_writeProductVersionBanner(IStringLocalizer localizer, IModuleFeedbackChannel feedback, String productName) {
        feedback.info(localizer.IStringLocalizer_getFormattedLocalizedString("FormattedProductNameAndReleaseAndBuildString", productName, this.IVersion_getReleaseAndBuildString(localizer)));
        String vmVersion = localizer.IStringLocalizer_getLocalizedString("JavaVMVersionUnavailableString");
        String vmVendor = localizer.IStringLocalizer_getLocalizedString("JavaVMVendorUnavailableString");
        try {
            vmVendor = System.getProperty("java.vendor");
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            vmVersion = "\"" + System.getProperty("java.vm.name") + " " + System.getProperty("java.version") + "\"";
        }
        catch (Throwable e) {
            // empty catch block
        }
        feedback.info(localizer.IStringLocalizer_getFormattedLocalizedString("FormattedJavaVersionAndVendorString", vmVersion, vmVendor));
    }
}

