/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.LinkedList;

public class CompoundTransferable
implements Transferable {
    private Transferable[] fInnerTransferables;

    public CompoundTransferable(Transferable[] transferables) {
        this.fInnerTransferables = transferables;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        for (int i = 0; i < this.fInnerTransferables.length; ++i) {
            try {
                return this.fInnerTransferables[i].getTransferData(flavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                continue;
            }
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        boolean dataFlavorSupported = false;
        for (int i = 0; i < this.fInnerTransferables.length && !dataFlavorSupported; ++i) {
            dataFlavorSupported = this.fInnerTransferables[i].isDataFlavorSupported(flavor);
        }
        return dataFlavorSupported;
    }

    public DataFlavor[] getTransferDataFlavors() {
        LinkedList<DataFlavor> dataFlavorsList = new LinkedList<DataFlavor>();
        for (int i = 0; i < this.fInnerTransferables.length; ++i) {
            DataFlavor[] innerDataFlavors = this.fInnerTransferables[i].getTransferDataFlavors();
            for (int j = 0; j < innerDataFlavors.length; ++j) {
                dataFlavorsList.add(innerDataFlavors[j]);
            }
        }
        DataFlavor[] dataFlavors = new DataFlavor[dataFlavorsList.size()];
        dataFlavorsList.toArray(dataFlavors);
        return dataFlavors;
    }
}

