/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.soa.ttracefilters.common;

import com.wily.introscope.spec.server.beans.event.IEventDataNode;
import com.wily.introscope.spec.server.transactiontrace.ACustomTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.util.Locale;
import java.util.Map;

public class SoaTransactionTraceFilter
extends ACustomTransactionTraceFilter {
    private static final long serialVersionUID = 4361409756802126787L;
    public static final int kEqualsMatchType = 0;
    public static final int kStartsWithMatchType = 1;
    public static final int kEndsWithMatchType = 2;
    public static final int kContainsMatchType = 3;
    public static final int kExistsMatchType = 4;
    public static final int kDoesNotEqualMatchType = 5;
    public static final int kDoesNotContainMatchType = 6;
    public static final int kDoesNotExistMatchType = 7;
    public static final int kGreaterThanMatchType = 8;
    public static final int kLessThanMatchType = 9;
    public static final int kEqualsIgnoreCaseMatchType = 10;
    public static final int kStartsWithIgnoreCaseMatchType = 11;
    public static final int kEndsWithIgnoreCaseMatchType = 12;
    public static final int kContainsIgnoreCaseMatchType = 13;
    public static final int kDoesNotEqualIgnoreCaseMatchType = 14;
    public static final int kDoesNotContainIgnoreCaseMatchType = 15;
    public static final String kSipOperatorExistsText = "Transaction_Trace_Parameter_Operator_Exists_Text";
    public static final String kSipOperatorDoesNotExistText = "Transaction_Trace_Parameter_Operator_Does_Not_Exist_Text";
    public static final String kSipOperatorEqualsText = "Transaction_Trace_Parameter_Operator_Equals_Text";
    public static final String kSipOperatorDoesNotEqualText = "Transaction_Trace_Parameter_Operator_Does_Not_Equal_Text";
    public static final String kSipOperatorContainsText = "Transaction_Trace_Parameter_Operator_Contains_Text";
    public static final String kSipOperatorDoesNotContainText = "Transaction_Trace_Parameter_Operator_Does_Not_Contain_Text";
    public static final String kSipOperatorStartsWithText = "Transaction_Trace_Parameter_Operator_Starts_With_Text";
    public static final String kSipOperatorEndsWithText = "Transaction_Trace_Parameter_Operator_Ends_With_Text";
    public static final String kSipOperatorIgnoreCaseText = "Transaction_Trace_Parameter_Operator_Ignore_Case";
    public static final String kTransactionTraceGenericFilterDescriptionMessage = "Transaction_Trace_Generic_Filter_Description_Message";
    public static final String kTransactionTraceStatusBarSipFilterMessage = "Transaction_Trace_Status_Bar_Parameter_Filter_Message";
    public static final String kSipFieldName = "fieldname";
    public static final String kSipOperation = "operation";
    public static final String kSipValue = "value";
    public static final String kSipCaseSensitive = "casesensitivity";
    public static final String kSipHashCode = "hashcode";

    public SoaTransactionTraceFilter() {
    }

    public SoaTransactionTraceFilter(Map params) {
        super(params);
    }

    public String getFieldName() {
        return (String)this.getParameters().get(kSipFieldName);
    }

    private static boolean isNotOperation(int operation) {
        return operation == 5 || operation == 6 || operation == 7 || operation == 14 || operation == 15;
    }

    public int getOperationType() {
        return new Integer((String)this.getParameters().get(kSipOperation));
    }

    public String getValue() {
        int operationType = this.getOperationType();
        return operationType == 4 || operationType == 7 ? "" : (String)this.getParameters().get(kSipValue);
    }

    public int getCaseSensitive() {
        return new Integer((String)this.getParameters().get(kSipCaseSensitive));
    }

    public String getCaseSensitiveValue(IStringLocalizer localizer) {
        return localizer.IStringLocalizer_getLocalizedString(kSipOperatorIgnoreCaseText);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SoaTransactionTraceFilter) {
            SoaTransactionTraceFilter filter = (SoaTransactionTraceFilter)((Object)obj);
            return this.getOperationType() == filter.getOperationType() && this.getFieldName().equals(filter.getFieldName()) && this.getValue().equals(filter.getValue()) && this.getCaseSensitive() == filter.getCaseSensitive();
        }
        return false;
    }

    public int hashCode() {
        String filterRep = String.valueOf(this.getFieldName()) + this.getOperationType() + this.getValue() + this.getCaseSensitive();
        return filterRep.hashCode();
    }

    public static int getFilterType() {
        return 50;
    }

    public int ITransactionTraceFilter_getFilterType() {
        return 60;
    }

    public String ITransactionTraceFilter_getLocalizedDescription(IStringLocalizer localizer) {
        return localizer.IStringLocalizer_getFormattedLocalizedString(kTransactionTraceGenericFilterDescriptionMessage, this.ITransactionTraceFilter_getLocalizedStatusMessage(localizer));
    }

    public String ITransactionTraceFilter_getLocalizedStatusMessage(IStringLocalizer localizer) {
        String name = this.getFieldName();
        String operation = SoaTransactionTraceFilter.getLocalizedOperationName(localizer, this.getOperationType());
        String value = this.getValue() == null ? "" : this.getValue();
        String caseSensitive = this.getCaseSensitive() == 0 && value.length() > 0 ? "[" + this.getCaseSensitiveValue(localizer) + "]" : "";
        String text = String.valueOf(name) + " that " + operation + " " + value + " " + caseSensitive;
        return text;
    }

    public String ITransactionTraceFilter_getLocalizedStatusMessage(IStringLocalizer localizer, Locale locale) {
        String name = this.getFieldName();
        String operation = SoaTransactionTraceFilter.getLocalizedOperationName(localizer, this.getOperationType(), locale);
        String value = this.getValue() == null ? "" : this.getValue();
        String caseSensitive = this.getCaseSensitive() == 0 && value.length() > 0 ? "[" + this.getCaseSensitiveValue(localizer) + "]" : "";
        String text = String.valueOf(name) + " that " + operation + " " + value + " " + caseSensitive;
        return text;
    }

    public boolean isHeadFilter() {
        return true;
    }

    public boolean ITransactionTraceFilter_passesFilter(TransactionComponentData data) {
        Assertion.wilyAssert((boolean)false);
        return this.ITransactionTraceFilter_passesFilterInternalRecursive((IEventDataNode)data);
    }

    private boolean ITransactionTraceFilter_passesFilterInternalRecursive(IEventDataNode data) {
        Map txComponentParams = data.getParameters();
        boolean passesFilter = this.shouldCollect(txComponentParams);
        if (!passesFilter) {
            int numSubNodes = data.getSubNodeCount();
            int i = 0;
            while (i < numSubNodes) {
                IEventDataNode childEventNode = data.getSubNode(i);
                passesFilter = this.ITransactionTraceFilter_passesFilterInternalRecursive(childEventNode);
                if (passesFilter) break;
                ++i;
            }
        }
        return passesFilter;
    }

    public boolean shouldCollect(Map txComponentParams) {
        String fieldContents = (String)txComponentParams.get(this.getFieldName());
        String valueToMatch = this.getValue();
        int operation = this.computeActualOperation(this.getOperationType(), this.getCaseSensitive());
        if (operation == 0) {
            if (fieldContents == null) {
                return false;
            }
            return valueToMatch.equals(fieldContents);
        }
        if (operation == 10) {
            if (fieldContents == null) {
                return false;
            }
            return valueToMatch.toLowerCase().equals(fieldContents.toLowerCase());
        }
        if (operation == 5) {
            if (fieldContents == null) {
                return true;
            }
            return !valueToMatch.equals(fieldContents);
        }
        if (operation == 14) {
            if (fieldContents == null) {
                return true;
            }
            return !valueToMatch.toLowerCase().equals(fieldContents.toLowerCase());
        }
        if (operation == 3) {
            if (fieldContents == null) {
                return false;
            }
            return fieldContents.indexOf(valueToMatch) > -1;
        }
        if (operation == 13) {
            if (fieldContents == null) {
                return false;
            }
            return fieldContents.toLowerCase().indexOf(valueToMatch.toLowerCase()) > -1;
        }
        if (operation == 6) {
            if (fieldContents == null) {
                return true;
            }
            return fieldContents.indexOf(valueToMatch) <= -1;
        }
        if (operation == 15) {
            if (fieldContents == null) {
                return true;
            }
            return fieldContents.toLowerCase().indexOf(valueToMatch.toLowerCase()) <= -1;
        }
        if (operation == 1) {
            if (fieldContents == null) {
                return false;
            }
            return fieldContents.startsWith(valueToMatch);
        }
        if (operation == 11) {
            if (fieldContents == null) {
                return false;
            }
            return fieldContents.toLowerCase().startsWith(valueToMatch.toLowerCase());
        }
        if (operation == 2) {
            if (fieldContents == null) {
                return false;
            }
            return fieldContents.endsWith(valueToMatch);
        }
        if (operation == 12) {
            if (fieldContents == null) {
                return false;
            }
            return fieldContents.toLowerCase().endsWith(valueToMatch.toLowerCase());
        }
        if (operation == 4) {
            return fieldContents != null;
        }
        if (this.getOperationType() == 7) {
            return fieldContents == null;
        }
        if (operation == 8) {
            int value2;
            if (fieldContents == null) {
                return false;
            }
            int i = 0;
            while (i < fieldContents.length()) {
                if (!Character.isDigit(fieldContents.charAt(i))) {
                    return false;
                }
                ++i;
            }
            int value1 = new Integer(fieldContents);
            return value1 > (value2 = new Integer(valueToMatch).intValue());
        }
        if (operation == 9) {
            int value2;
            if (fieldContents == null) {
                return false;
            }
            int i = 0;
            while (i < fieldContents.length()) {
                if (!Character.isDigit(fieldContents.charAt(i))) {
                    return false;
                }
                ++i;
            }
            int value1 = new Integer(fieldContents);
            return value1 < (value2 = new Integer(valueToMatch).intValue());
        }
        return false;
    }

    private void printTxComponentData(String indent, IEventDataNode eventNode) {
        System.out.println(String.valueOf(indent) + "Resource: " + eventNode.getResource() + ", parameters: " + eventNode.getParameters());
        int numSuNodes = eventNode.getSubNodeCount();
        indent = String.valueOf(indent) + "  ";
        int i = 0;
        while (i < numSuNodes) {
            IEventDataNode childEventNode = eventNode.getSubNode(i);
            this.printTxComponentData(indent, childEventNode);
            ++i;
        }
    }

    private int computeActualOperation(int inOperation, int caseSensitive) {
        int operation = inOperation;
        if (caseSensitive == 0) {
            if (inOperation == 0) {
                operation = 10;
            } else if (inOperation == 1) {
                operation = 11;
            } else if (inOperation == 2) {
                operation = 12;
            } else if (inOperation == 3) {
                operation = 13;
            } else if (inOperation == 5) {
                operation = 14;
            } else if (inOperation == 6) {
                operation = 15;
            }
        }
        return operation;
    }

    public String toString() {
        return "[SOA Field = " + this.getFieldName() + ", Operator=" + this.getOperationType() + ", Search String=" + this.getValue() + ", Case Sensitivity=" + this.getCaseSensitive() + "]";
    }

    public String toDisplayString(IStringLocalizer localizer) {
        String str = String.valueOf(this.getFieldName()) + " " + SoaTransactionTraceFilter.getLocalizedOperationName(localizer, this.getOperationType()) + " " + this.getValue();
        if (this.getCaseSensitive() == 0) {
            str = String.valueOf(str) + " [ignore case]";
        }
        return str;
    }

    public static String getLocalizedOperationName(IStringLocalizer localizer, int operationType, Locale locale) {
        if (2 == operationType) {
            return localizer.IStringLocalizer_getLocalizedString(locale, kSipOperatorEndsWithText);
        }
        if (1 == operationType) {
            return localizer.IStringLocalizer_getLocalizedString(locale, kSipOperatorStartsWithText);
        }
        if (operationType == 0) {
            return localizer.IStringLocalizer_getLocalizedString(locale, kSipOperatorEqualsText);
        }
        if (5 == operationType) {
            return localizer.IStringLocalizer_getLocalizedString(locale, kSipOperatorDoesNotEqualText);
        }
        if (3 == operationType) {
            return localizer.IStringLocalizer_getLocalizedString(locale, kSipOperatorContainsText);
        }
        if (6 == operationType) {
            return localizer.IStringLocalizer_getLocalizedString(locale, kSipOperatorDoesNotContainText);
        }
        if (4 == operationType) {
            return localizer.IStringLocalizer_getLocalizedString(locale, kSipOperatorExistsText);
        }
        if (7 == operationType) {
            return localizer.IStringLocalizer_getLocalizedString(locale, kSipOperatorDoesNotExistText);
        }
        if (8 == operationType) {
            return "greater than";
        }
        if (9 == operationType) {
            return "less than";
        }
        return "";
    }

    public static String getLocalizedOperationName(IStringLocalizer localizer, int operationType) {
        if (2 == operationType) {
            return localizer.IStringLocalizer_getLocalizedString(kSipOperatorEndsWithText);
        }
        if (1 == operationType) {
            return localizer.IStringLocalizer_getLocalizedString(kSipOperatorStartsWithText);
        }
        if (operationType == 0) {
            return localizer.IStringLocalizer_getLocalizedString(kSipOperatorEqualsText);
        }
        if (5 == operationType) {
            return localizer.IStringLocalizer_getLocalizedString(kSipOperatorDoesNotEqualText);
        }
        if (3 == operationType) {
            return localizer.IStringLocalizer_getLocalizedString(kSipOperatorContainsText);
        }
        if (6 == operationType) {
            return localizer.IStringLocalizer_getLocalizedString(kSipOperatorDoesNotContainText);
        }
        if (4 == operationType) {
            return localizer.IStringLocalizer_getLocalizedString(kSipOperatorExistsText);
        }
        if (7 == operationType) {
            return localizer.IStringLocalizer_getLocalizedString(kSipOperatorDoesNotExistText);
        }
        if (8 == operationType) {
            return "greater than";
        }
        if (9 == operationType) {
            return "less than";
        }
        return "";
    }

    private Boolean evaluateParameterNameValueOperationPartial(Map txComponentParams) {
        String fieldContents = (String)txComponentParams.get(this.getFieldName());
        String valueToMatch = this.getValue();
        boolean exists = fieldContents != null;
        int operation = this.computeActualOperation(this.getOperationType(), this.getCaseSensitive());
        if (!exists && operation != 4 && operation != 7) {
            return null;
        }
        if (operation == 0) {
            if (valueToMatch.equals(fieldContents)) {
                return Boolean.TRUE;
            }
            return null;
        }
        if (operation == 10) {
            if (valueToMatch.toLowerCase().equals(fieldContents.toLowerCase())) {
                return Boolean.TRUE;
            }
            return null;
        }
        if (operation == 5) {
            if (valueToMatch.equals(fieldContents)) {
                return Boolean.FALSE;
            }
            return null;
        }
        if (operation == 14) {
            if (valueToMatch.toLowerCase().equals(fieldContents.toLowerCase())) {
                return Boolean.FALSE;
            }
            return null;
        }
        if (operation == 3) {
            if (fieldContents.indexOf(valueToMatch) > -1) {
                return Boolean.TRUE;
            }
            return null;
        }
        if (operation == 13) {
            if (fieldContents.toLowerCase().indexOf(valueToMatch.toLowerCase()) > -1) {
                return Boolean.TRUE;
            }
            return null;
        }
        if (operation == 6) {
            if (fieldContents.indexOf(valueToMatch) > -1) {
                return Boolean.FALSE;
            }
            return null;
        }
        if (operation == 15) {
            if (fieldContents.toLowerCase().indexOf(valueToMatch.toLowerCase()) > -1) {
                return Boolean.FALSE;
            }
            return null;
        }
        if (operation == 1) {
            if (fieldContents.startsWith(valueToMatch)) {
                return Boolean.TRUE;
            }
            return null;
        }
        if (operation == 11) {
            if (fieldContents.toLowerCase().startsWith(valueToMatch.toLowerCase())) {
                return Boolean.TRUE;
            }
            return null;
        }
        if (operation == 2) {
            if (fieldContents.endsWith(valueToMatch)) {
                return Boolean.TRUE;
            }
            return null;
        }
        if (operation == 12) {
            if (fieldContents.toLowerCase().endsWith(valueToMatch.toLowerCase())) {
                return Boolean.TRUE;
            }
            return null;
        }
        if (operation == 4) {
            if (exists) {
                return Boolean.TRUE;
            }
            return null;
        }
        if (this.getOperationType() == 7) {
            if (exists) {
                return Boolean.FALSE;
            }
            return null;
        }
        if (operation == 8) {
            int value2;
            int i = 0;
            while (i < fieldContents.length()) {
                if (!Character.isDigit(fieldContents.charAt(i))) {
                    return null;
                }
                ++i;
            }
            int value1 = new Integer(fieldContents);
            if (value1 > (value2 = new Integer(valueToMatch).intValue())) {
                return Boolean.TRUE;
            }
            return null;
        }
        if (operation == 9) {
            int value2;
            int i = 0;
            while (i < fieldContents.length()) {
                if (!Character.isDigit(fieldContents.charAt(i))) {
                    return null;
                }
                ++i;
            }
            int value1 = new Integer(fieldContents);
            if (value1 < (value2 = new Integer(valueToMatch).intValue())) {
                return Boolean.TRUE;
            }
            return null;
        }
        return null;
    }

    private boolean evaluateParameterNameValueOperationFinal() {
        return SoaTransactionTraceFilter.isNotOperation(this.getOperationType());
    }

    public boolean shouldCollectFinal() {
        return this.evaluateParameterNameValueOperationFinal();
    }

    public Boolean shouldCollectHead(Map parameters) {
        return this.evaluateParameterNameValueOperationPartial(parameters);
    }
}

