/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.websphere;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public class JAXWSProxyHandlerTracer
extends ASingleInstanceTracerFactory {
    private static final String WAS_INBOUND_SOAP_HEADER_KEY = "jaxws.binding.soap.headers.inbound";
    private static final String WAS_OUTBOUND_SOAP_HEADER_KEY = "jaxws.binding.soap.headers.outbound";
    private static final String SOA_ASYNCH_CLIENT_KEY = "soa_asynch_client";
    private static final String SOA_ASYNCH_OPNAME_KEY = "soa_asynch_opname";
    protected final IModuleFeedbackChannel logger;

    public JAXWSProxyHandlerTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.logger = agent.IAgent_getModuleFeedback();
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        if (!WSMUtils.correlationEnabled()) {
            return;
        }
        long startTime = 0L;
        startTime = System.currentTimeMillis();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("START:JAXWSProxyHandlerTracer.ITracer_startTrace()");
        }
        String operationName = null;
        try {
            Object objJAXWSProxyHandler = data.getInvocationObject();
            Object objRequestContext = WSMUtils.invokeMethodOnObject(objJAXWSProxyHandler, "getRequestContext");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("objRequestContext:" + objRequestContext);
            }
            CorrelationId corrId = new CorrelationId();
            corrId.incrementSequenceId();
            String correlationString = corrId.getCurrentOutgoingCorrelationIdStrippedForHeader();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Outbound correlationString:" + correlationString);
            }
            Map mapReqCtx = (Map)objRequestContext;
            HashMap outboundHeaders = new HashMap();
            ArrayList<String> list1 = new ArrayList<String>();
            list1.add("<WSCorIDSOAPHeader xmlns=\"http://www.ca.com/apm\"><CorID>" + correlationString + "</CorID></WSCorIDSOAPHeader>");
            outboundHeaders.put(new QName("http://www.ca.com/apm", "WSCorIDSOAPHeader"), list1);
            mapReqCtx.put(WAS_OUTBOUND_SOAP_HEADER_KEY, outboundHeaders);
            mapReqCtx.put(SOA_ASYNCH_CLIENT_KEY, new Long(startTime));
            operationName = ((Method)data.getInvocationParameterAsObject(0)).getName();
            mapReqCtx.put(SOA_ASYNCH_OPNAME_KEY, operationName);
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("END:JAXWSProxyHandlerTracer.ITracer_startTrace()");
        }
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (!WSMUtils.correlationSOAPInsertionEnabled()) {
            return;
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

