/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class CanonicalObjectPool {
    private static final CanonicalObjectPool sStringPool = new CanonicalObjectPool();
    private Entry[] fEntries;
    private int fEntryShiftSize = 2;
    private int fIndexMask = (1 << this.fEntryShiftSize) - 1;
    private int fCleanEntries = 0;
    private int fCount;

    public CanonicalObjectPool() {
        this.fEntries = new Entry[1 << this.fEntryShiftSize];
    }

    private void growTable() {
        ++this.fEntryShiftSize;
        this.fIndexMask = (1 << this.fEntryShiftSize) - 1;
        Entry[] oldtable = this.fEntries;
        this.fEntries = new Entry[1 << this.fEntryShiftSize];
        int i = 0;
        while (i < oldtable.length) {
            Entry entry = oldtable[i];
            while (entry != null) {
                Entry origNxtEntry = entry.getNext();
                Object reference = entry.get();
                if (reference != null) {
                    int hashCode = reference.hashCode();
                    int index = hashCode & this.fIndexMask;
                    entry.setNext(this.fEntries[index]);
                    this.fEntries[index] = entry;
                } else {
                    --this.fCount;
                }
                entry = origNxtEntry;
            }
            ++i;
        }
    }

    private void cleanEntries() {
        int i = 0;
        while (i < this.fEntries.length) {
            Entry entry = this.fEntries[i];
            Entry prior = null;
            while (entry != null) {
                if (entry.get() == null) {
                    entry = entry.getNext();
                    if (prior == null) {
                        this.fEntries[i] = entry;
                    } else {
                        prior.setNext(entry);
                    }
                    --this.fCount;
                    continue;
                }
                prior = entry;
                entry = entry.getNext();
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCanonicalObject(Object inputObject) {
        int hashCode = inputObject.hashCode();
        int index = hashCode & this.fIndexMask;
        CanonicalObjectPool canonicalObjectPool = this;
        synchronized (canonicalObjectPool) {
            Entry entry = this.fEntries[index];
            Entry prior = null;
            while (entry != null) {
                Object reference = entry.get();
                if (reference == null) {
                    entry = entry.getNext();
                    if (prior == null) {
                        this.fEntries[index] = entry;
                    } else {
                        prior.setNext(entry);
                    }
                    --this.fCount;
                    continue;
                }
                if (reference.hashCode() == hashCode && reference.equals(inputObject)) {
                    return reference;
                }
                prior = entry;
                entry = entry.getNext();
            }
            Entry newEntry = new Entry(inputObject);
            newEntry.setNext(this.fEntries[index]);
            this.fEntries[index] = newEntry;
            ++this.fCount;
            if (this.fCount >> 2 > this.fIndexMask) {
                this.growTable();
            }
            if ((this.fCleanEntries++ & (this.fIndexMask << 3 | 7)) == (this.fIndexMask << 3 | 7)) {
                this.cleanEntries();
            }
        }
        return inputObject;
    }

    public Object[] toArray(Object[] returnArray) {
        ArrayList results = new ArrayList(this.fCount);
        int i = 0;
        while (i < this.fEntries.length) {
            Entry entry = this.fEntries[i];
            while (entry != null) {
                Object reference = entry.get();
                if (reference != null) {
                    results.add(reference);
                }
                entry = entry.getNext();
            }
            ++i;
        }
        return results.toArray(returnArray);
    }

    public static String getCanonicalString(String s) {
        return (String)sStringPool.getCanonicalObject(s);
    }

    private static class Entry
    extends WeakReference {
        private Entry fNext;

        public Entry(Object ref) {
            super(ref);
        }

        public Entry getNext() {
            return this.fNext;
        }

        public void setNext(Entry next) {
            this.fNext = next;
        }
    }
}

