/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.ext.sysview.namefilter;

import com.wily.introscope.ext.sysview.common.Messages;
import com.wily.introscope.ext.sysview.common.SysViewConstants;
import com.wily.introscope.spec.server.beans.event.IEventDataNode;
import com.wily.introscope.spec.server.transactiontrace.ATransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.text.IStringLocalizer;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Locale;
import java.util.Map;

public class TimeTracerFilter
extends ATransactionTraceFilter
implements Externalizable,
SysViewConstants {
    private long mStartTimeInMicroseconds;

    public long getMStartTime() {
        return this.mStartTimeInMicroseconds;
    }

    public TimeTracerFilter() {
        this.mStartTimeInMicroseconds = -1L;
    }

    public TimeTracerFilter(long startTime) {
        this.mStartTimeInMicroseconds = startTime;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.mStartTimeInMicroseconds = in.readLong();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeInternal(out);
    }

    public int ITransactionTraceFilter_getFilterType() {
        return 180;
    }

    public String ITransactionTraceFilter_getLocalizedDescription(IStringLocalizer localizer) {
        return localizer.IStringLocalizer_getFormattedLocalizedString("Transaction_Trace_Generic_Filter_Description_Message", this.ITransactionTraceFilter_getLocalizedStatusMessage(localizer));
    }

    public String ITransactionTraceFilter_getLocalizedStatusMessage(IStringLocalizer localizer) {
        String statusMessage = "";
        if (this.mStartTimeInMicroseconds >= 0L) {
            statusMessage = Messages.getString("SysviewFilter.TimeFilterStatusMessage", Long.toString(this.mStartTimeInMicroseconds));
        }
        return statusMessage;
    }

    public String ITransactionTraceFilter_getLocalizedStatusMessage(IStringLocalizer localizer, Locale locale) {
        String statusMessage = "";
        if (this.mStartTimeInMicroseconds >= 0L) {
            statusMessage = Messages.getString(locale, "SysviewFilter.TimeFilterStatusMessage", Long.toString(this.mStartTimeInMicroseconds));
        }
        return statusMessage;
    }

    public void ITransactionTraceFilter_write(DataOutput out) throws IOException {
        this.writeInternal(out);
    }

    public boolean isHeadFilter() {
        return false;
    }

    public boolean shouldCollect(Map params) {
        Long longSysviewTimeParamValue = null;
        Object sysviewTimeParamValue = params.get(Messages.getString("TT_SysViewTimeFilter_Key"));
        if (sysviewTimeParamValue == null) {
            return false;
        }
        if (sysviewTimeParamValue instanceof String) {
            try {
                longSysviewTimeParamValue = new Long(Long.parseLong((String)sysviewTimeParamValue));
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        } else if (sysviewTimeParamValue instanceof Long) {
            longSysviewTimeParamValue = (Long)sysviewTimeParamValue;
        } else if (sysviewTimeParamValue instanceof Integer) {
            longSysviewTimeParamValue = new Long(((Integer)sysviewTimeParamValue).longValue());
        }
        if (longSysviewTimeParamValue == null) {
            return false;
        }
        long sysviewTime = longSysviewTimeParamValue;
        return sysviewTime >= this.mStartTimeInMicroseconds;
    }

    public boolean ITransactionTraceFilter_passesFilter(IEventDataNode root) {
        Map params;
        boolean passes = false;
        if (root != null && !(passes = this.shouldCollect(params = root.getParameters()))) {
            int indexc = root.getSubNodeCount() - 1;
            while (!passes && indexc >= 0) {
                passes = this.ITransactionTraceFilter_passesFilter(root.getSubNode(indexc));
                --indexc;
            }
        }
        return passes;
    }

    public boolean ITransactionTraceFilter_passesFilter(TransactionComponentData root) {
        Map params;
        boolean passes = false;
        if (root != null && !(passes = this.shouldCollect(params = root.getParameters()))) {
            int indexc = root.getSubNodeCount() - 1;
            while (!passes && indexc >= 0) {
                passes = this.ITransactionTraceFilter_passesFilter(root.getSubNode(indexc));
                --indexc;
            }
        }
        return passes;
    }

    private void writeInternal(DataOutput out) throws IOException {
        out.writeLong(this.mStartTimeInMicroseconds);
    }

    public int hashCode() {
        return new Long(this.mStartTimeInMicroseconds).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TimeTracerFilter) {
            TimeTracerFilter filter = (TimeTracerFilter)obj;
            return filter.getMStartTime() == this.mStartTimeInMicroseconds;
        }
        return false;
    }
}

