/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.sysview.ctgtracer.eci;

import com.wily.util.clock.MasterClock;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class GUIDGenerator {
    private static Map instances = new HashMap();
    private Random seeder;
    private String hostAndSystemID;
    private static final SecureRandom seedGenerator = new SecureRandom();
    static final char[] kcharsHexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static final String kstDefaultHost = "00000000";
    public static final String kDefaultSeeder = SecureRandom.class.getName();
    private static final AtomicInteger uniqueId = new AtomicInteger(0);
    private static final ThreadLocal<GUIDGenerator> threadUniqueGUIDGenerator = new ThreadLocal<GUIDGenerator>(){

        @Override
        protected GUIDGenerator initialValue() {
            return new GUIDGenerator(new Random(uniqueId.getAndIncrement() + seedGenerator.nextInt()), null);
        }
    };

    private GUIDGenerator() {
        this(new SecureRandom());
    }

    private GUIDGenerator(Random aSeeder) {
        byte[] addr;
        this.seeder = aSeeder;
        this.seeder.nextInt();
        StringBuffer buffer = new StringBuffer(16);
        try {
            addr = InetAddress.getLocalHost().getAddress();
        }
        catch (UnknownHostException unknownHostException) {
            addr = kstDefaultHost.getBytes();
        }
        buffer.append(GUIDGenerator.toHex(GUIDGenerator.toInt(addr), 8));
        buffer.append(GUIDGenerator.toHex(System.identityHashCode(this), 8));
        this.hostAndSystemID = buffer.toString();
    }

    public static GUIDGenerator getInstance() {
        return threadUniqueGUIDGenerator.get();
    }

    public String generateKey() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append(GUIDGenerator.toHex((int)(MasterClock.currentTimeMillis() & 0xFFFFFFFFFFFFFFFFL), 8));
        buffer.append(this.hostAndSystemID);
        buffer.append(GUIDGenerator.toHex(this.seeder.nextInt(), 8));
        return buffer.toString();
    }

    private static String toHex(int value, int length) {
        StringBuffer buffer = new StringBuffer(length);
        int shift = length - 1 << 2;
        int i = -1;
        while (++i < length) {
            buffer.append(kcharsHexDigits[value >> shift & 0xF]);
            value <<= 4;
        }
        return buffer.toString();
    }

    private static int toInt(byte[] bytes) {
        int value = 0;
        int i = -1;
        while (++i < bytes.length) {
            value <<= 8;
            int b = bytes[i] & 0xFF;
            value |= b;
        }
        return value;
    }

    public boolean fromSameHost(String guidString) {
        String guidHostAndId = guidString.substring(8, 24);
        return guidHostAndId.equals(this.hostAndSystemID);
    }

    /* synthetic */ GUIDGenerator(Random random, GUIDGenerator gUIDGenerator) {
        this(random);
    }
}

