/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake;

import com.wily.powerpack.websphereMQ.agent.extensions.MQProperties;
import com.wily.powerpack.websphereMQ.agent.extensions.encryption.AgentConfigFactory;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.logger.MQPPLog;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.HandshakeConstants;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.File;
import java.util.StringTokenizer;

public final class HandshakeSSL
implements HandshakeConstants {
    private static IModuleFeedbackChannel logger = null;
    private static String trustStore = "";
    private static String keyStore = "";
    private static String keyStorePassword = "";
    private static String encryptedPassword = "";
    private static MQProperties properties = null;
    private static boolean alreadyLoaded;

    static {
        logger = MQPPLog.getLogger();
        properties = MQProperties.instance(logger);
        alreadyLoaded = false;
    }

    public static void loadSSLKeyPath() {
        boolean exists;
        File file;
        if (alreadyLoaded) {
            return;
        }
        if (logger.isDebugEnabled()) {
            System.setProperty("javax.net.debug", "ssl,handshake");
        }
        if ((trustStore = properties.getProperty("truststore.path")) != null) {
            file = new File(trustStore = HandshakeSSL.replaceBackSlash(trustStore));
            exists = file.exists();
            if (!exists) {
                logger.warn(handshakeModule, "The trustStore file is missing or the path is incorrect.");
            } else {
                System.setProperty("javax.net.ssl.trustStore", trustStore);
            }
        }
        if ((keyStore = properties.getProperty("keystore.path")) != null) {
            file = new File(keyStore = HandshakeSSL.replaceBackSlash(keyStore));
            exists = file.exists();
            if (!exists) {
                logger.warn(handshakeModule, "The keyStore file is missing or the path is incorrect.");
            } else {
                System.setProperty("javax.net.ssl.keyStore", String.valueOf(keyStore));
                encryptedPassword = properties.getProperty("keystore.password");
                if (encryptedPassword != null) {
                    keyStorePassword = HandshakeSSL.getDecryptedString(encryptedPassword);
                } else {
                    logger.warn(handshakeModule, "KeyStore password is missing.");
                }
                if (keyStorePassword != null) {
                    System.setProperty("javax.net.ssl.keyStorePassword", keyStorePassword);
                } else {
                    logger.warn(handshakeModule, "KeyStore password is missing.");
                }
            }
        }
        alreadyLoaded = true;
    }

    private static String getDecryptedString(String encryptedPassword) {
        String plainText = null;
        try {
            plainText = AgentConfigFactory.instance().getDecryptedString(encryptedPassword);
        }
        catch (Exception e) {
            logger.warn(handshakeModule, "Failed to decrypt the password");
            logger.debug((Throwable)e);
        }
        return plainText;
    }

    private static String replaceBackSlash(String string) {
        StringTokenizer st = new StringTokenizer(string, "\\");
        StringBuffer sb = new StringBuffer();
        sb.append(st.nextToken());
        while (st.hasMoreTokens()) {
            sb.append(File.separator).append(st.nextToken());
        }
        return sb.toString();
    }
}

