/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui;

import com.wily.util.Scale;
import com.wily.util.WilyMath;

public class SmartAxis {
    private Scale fScale;

    public SmartAxis(Scale scale) {
        this.fScale = scale;
    }

    public void setScale(Scale scale) {
        this.fScale = scale;
    }

    public double[] getAxisPoints(int maxSegments) {
        double[] points;
        double lastPoint;
        double breadth = this.fScale.getBreadth();
        double increment = WilyMath.roundUp(WilyMath.roundUp(breadth / (double)maxSegments / 2.0, 1) * 2.0, 1);
        double firstPoint = Math.ceil(this.fScale.getMin() / increment) * increment;
        if (firstPoint != (lastPoint = Math.floor(this.fScale.getMax() / increment) * increment)) {
            points = new double[(int)((lastPoint - firstPoint) / increment) + 1];
            for (int i = 0; i < points.length; ++i) {
                points[i] = firstPoint + (double)i * increment;
            }
        } else {
            points = new double[]{firstPoint, firstPoint};
        }
        return points;
    }
}

