/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.image.filter;

import com.wily.wilyassert.Assertion;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RGBImageFilter;
import javax.swing.JPanel;

public class DecoratorFilter
extends RGBImageFilter {
    private BufferedImage fBufferedDecorator;
    private int fXOffset;
    private int fYOffset;
    private int fTransparencyRGB;

    private DecoratorFilter() {
    }

    public DecoratorFilter(Image decoratorImage, int xOffset, int yOffset, Color transparencyColor) {
        this.initialize(decoratorImage, xOffset, yOffset, transparencyColor);
    }

    private void initialize(Image decoratorImage, int xOffset, int yOffset, Color transparencyColor) {
        Assertion.wilyAssert(transparencyColor != null);
        this.canFilterIndexColorModel = false;
        this.fBufferedDecorator = DecoratorFilter.bufferImage(decoratorImage);
        this.fXOffset = xOffset;
        this.fYOffset = yOffset;
        this.fTransparencyRGB = transparencyColor.getRGB();
    }

    private int getTransparencyRGB() {
        return this.fTransparencyRGB;
    }

    private static BufferedImage bufferImage(Image image) {
        JPanel dummyObserver = new JPanel();
        Assertion.wilyAssert(image.getWidth(dummyObserver) > 0 && image.getHeight(dummyObserver) > 0);
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(dummyObserver), image.getHeight(dummyObserver), 2);
        PollDrawCompleteImageObserver pollDrawCompleteImageObserver = new PollDrawCompleteImageObserver();
        Graphics g = bufferedImage.getGraphics();
        boolean drawComplete = g.drawImage(image, 0, 0, pollDrawCompleteImageObserver);
        if (!drawComplete) {
            while (!pollDrawCompleteImageObserver.isDrawComplete()) {
            }
            drawComplete = g.drawImage(image, 0, 0, dummyObserver);
            Assertion.wilyAssert(drawComplete);
        }
        return bufferedImage;
    }

    public int filterRGB(int x, int y, int rgb) {
        int adjustedRGB;
        if (x >= this.getXOffset() && x < this.getXOffset() + this.getDecoratorWidth() && y >= this.getYOffset() && y < this.getYOffset() + this.getDecoratorHeight()) {
            adjustedRGB = this.getRGBForDecorator(x - this.getXOffset(), y - this.getYOffset());
            if (adjustedRGB == this.getTransparencyRGB()) {
                adjustedRGB = rgb;
            }
        } else {
            adjustedRGB = rgb;
        }
        return adjustedRGB;
    }

    private int getXOffset() {
        return this.fXOffset;
    }

    private int getYOffset() {
        return this.fYOffset;
    }

    private int getDecoratorWidth() {
        return this.fBufferedDecorator.getWidth();
    }

    private int getDecoratorHeight() {
        return this.fBufferedDecorator.getHeight();
    }

    private int getRGBForDecorator(int x, int y) {
        return this.fBufferedDecorator.getRGB(x, y);
    }

    static class PollDrawCompleteImageObserver
    implements ImageObserver {
        private boolean fDrawComplete = false;

        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            if ((infoflags & 0x80) != 0 || (infoflags & 0x40) != 0 || (infoflags & 0x20) != 0) {
                this.fDrawComplete = true;
            }
            Assertion.wilyAssert((infoflags & 0x80) == 0 && (infoflags & 0x40) == 0);
            return !this.fDrawComplete;
        }

        public boolean isDrawComplete() {
            return this.fDrawComplete;
        }
    }
}

