/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.utils;

import com.wily.rave.utils.IStateEngineAdminInterface;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class StateEngine
implements InvocationHandler {
    public static Method setStateMethod;
    public static Method setEngineStateMethod;
    private Object fState;
    private Object[] fMethodArguments;
    private Method fTransitionMethod;
    private Method fCrashMethod;
    private Class[] fCrashExceptions;
    private Object[] fCrashArgs;
    private StateEngineAdmin fAdminObj;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.wily.rave.utils.IStateEngineAdminInterface");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            setStateMethod = clazz.getMethod("IStateEngineAdmin_setState", classArray);
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("com.wily.rave.utils.IStateEngineAdminInterface");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class[] classArray2 = new Class[1];
            Class<?> clazz4 = class$1;
            if (clazz4 == null) {
                try {
                    clazz4 = class$1 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray2[0] = clazz4;
            setEngineStateMethod = clazz3.getMethod("IStateEngineAdmin_setEngineState", classArray2);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }

    private StateEngine(Class stateObjectsInterface, Object initialState, String stateTransitionMethodName, String crashMethodName, Object[] methodArguments, Class[] methodArgumentClasses, Class[] crashExceptions) throws SecurityException, NoSuchMethodException {
        this.fState = initialState;
        this.fMethodArguments = methodArguments;
        Class[] crashArgClasses = new Class[methodArguments.length + 1];
        this.fCrashArgs = new Object[methodArguments.length + 1];
        int i = 0;
        while (i < methodArguments.length) {
            crashArgClasses[i] = methodArgumentClasses[i];
            this.fCrashArgs[i] = methodArguments[i];
            ++i;
        }
        int n = methodArguments.length;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.Throwable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        crashArgClasses[n] = clazz;
        this.fTransitionMethod = stateObjectsInterface.getMethod(stateTransitionMethodName, methodArgumentClasses);
        this.fCrashMethod = stateObjectsInterface.getMethod(crashMethodName, crashArgClasses);
        this.fCrashExceptions = crashExceptions;
        this.fAdminObj = new StateEngineAdmin();
    }

    public static StateEngineTuple getStateEngine(Object initialStateObject, String stateTransitionMethodName, String crashMethodName, Object[] methodArguments, Class[] methodArgumentClasses, Class stateObjectsInterface, Class[] crashExceptions) throws IllegalArgumentException, SecurityException, NoSuchMethodException {
        StateEngine stateEngine = new StateEngine(stateObjectsInterface, initialStateObject, stateTransitionMethodName, crashMethodName, methodArguments, methodArgumentClasses, crashExceptions);
        return new StateEngineTuple(Proxy.newProxyInstance(stateObjectsInterface.getClassLoader(), new Class[]{stateObjectsInterface}, (InvocationHandler)stateEngine), stateEngine.getAdmin());
    }

    private StateEngineAdmin getAdmin() {
        return this.fAdminObj;
    }

    public static StateEngineTuple getStateEngine(Object initialStateObject, String stateTransitionMethodName, String crashMethodName, Object[] methodArguments, Class stateObjectsInterface, Class[] crashExceptions) throws IllegalArgumentException, SecurityException, NoSuchMethodException {
        Class[] methodArgumentClasses = new Class[methodArguments.length];
        int i = 0;
        while (i < methodArguments.length) {
            methodArgumentClasses[i] = methodArguments[i].getClass();
            ++i;
        }
        return StateEngine.getStateEngine(initialStateObject, stateTransitionMethodName, crashMethodName, methodArguments, methodArgumentClasses, stateObjectsInterface, crashExceptions);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> clazz = method.getDeclaringClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.wily.rave.utils.IStateEngineAdminInterface");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2)) {
            Object obj = method.invoke((Object)this.fAdminObj, args);
            if (!method.getName().equals("IStateEngineAdmin_setState")) {
                return obj;
            }
            method = this.fTransitionMethod;
            args = this.fMethodArguments;
        }
        Object nextState = this.fState;
        do {
            try {
                nextState = method.invoke(this.fState, args);
                if (nextState == null) continue;
                this.fState = nextState;
                method = this.fTransitionMethod;
                args = this.fMethodArguments;
            }
            catch (InvocationTargetException ex) {
                Throwable th = ex.getTargetException();
                if (this.isCrash(th)) {
                    method = this.fCrashMethod;
                    this.fCrashArgs[this.fCrashArgs.length - 1] = th;
                    args = this.fCrashArgs;
                    continue;
                }
                throw th;
            }
        } while (nextState != null);
        return this.fState;
    }

    private boolean isCrash(Throwable th) {
        if (this.fCrashExceptions == null) {
            return false;
        }
        int i = 0;
        while (i < this.fCrashExceptions.length) {
            if (this.fCrashExceptions[i].isInstance(th)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public class StateEngineAdmin
    implements IStateEngineAdminInterface {
        public Object IStateEngineAdmin_getState() {
            return StateEngine.this.fState;
        }

        public void IStateEngineAdmin_setState(Object state) {
            StateEngine.this.fState = state;
        }

        public void IStateEngineAdmin_setEngineState(Object state) {
            StateEngine.this.fState = state;
        }
    }

    public static final class StateEngineTuple {
        private final Object stateEngine;
        private final IStateEngineAdminInterface stateEngineAdmin;

        private StateEngineTuple(Object engine, StateEngineAdmin admin) {
            this.stateEngine = engine;
            this.stateEngineAdmin = admin;
        }

        public Object getStateEngine() {
            return this.stateEngine;
        }

        public IStateEngineAdminInterface getStateEngineAdmin() {
            return this.stateEngineAdmin;
        }
    }
}

