/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.environment;

import com.wily.introscope.agent.environment.SubNetworkDescriptor;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.text.IStringLocalizer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class SubNetworks {
    private static final int PRIVATE_IPV4_SUBNETS = 0;
    private static final int PRIVATE_IPV6_SUBNETS = 1;
    private static final int IPV6_TUNNELING_SUBNETS = 2;
    private static final String[] FIRST_WORDS = new String[]{"private", "tunnel"};
    private static final int PRIVATE = 0;
    private final List[] subNets;

    public SubNetworks() {
        this.subNets = new List[]{new ArrayList(), new ArrayList(), new ArrayList()};
    }

    public SubNetworks(Module module, IModuleFeedbackChannel feedback, IStringLocalizer localizer, InputStream subnetworksStream) {
        block16: {
            this.subNets = new List[]{new ArrayList(), new ArrayList(), new ArrayList()};
            BufferedReader br = null;
            try {
                try {
                    br = new BufferedReader(new InputStreamReader(subnetworksStream));
                    String line = br.readLine();
                    int lineNumber = 1;
                    while (line != null) {
                        if (!this.processLine(line)) {
                            feedback.error(module, localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SubNetworks_Line_Format_Error", Integer.toString(lineNumber)));
                        }
                        line = br.readLine();
                        ++lineNumber;
                    }
                }
                catch (IOException e) {
                    feedback.error(module, localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SubNetworks_File_Read_Error", e.getMessage()));
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean processLine(String line) {
        block11: {
            int slashPos;
            String subNetSpec;
            int hashPos = line.indexOf(35);
            if (hashPos >= 0) {
                line = line.substring(0, hashPos);
            }
            if ((line = line.trim()).length() == 0) {
                return true;
            }
            int firstWord = this.getFirstWord(line);
            if (firstWord >= 0 && (subNetSpec = line.substring(FIRST_WORDS[firstWord].length())).length() > 0 && Character.isWhitespace(subNetSpec.charAt(0)) && (slashPos = (subNetSpec = subNetSpec.trim()).indexOf(47)) > 0) {
                SubNetworkDescriptor subNet;
                block10: {
                    subNet = new SubNetworkDescriptor(subNetSpec.substring(0, slashPos), Integer.parseInt(subNetSpec.substring(slashPos + 1)));
                    if (!subNet.isIPv4()) break block10;
                    if (firstWord == 0) {
                        this.subNets[0].add(subNet);
                        return true;
                    }
                    break block11;
                }
                try {
                    if (firstWord == 0) {
                        this.subNets[1].add(subNet);
                    } else {
                        this.subNets[2].add(subNet);
                    }
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return false;
    }

    private int getFirstWord(String line) {
        int i = 0;
        while (i < FIRST_WORDS.length) {
            if (line.startsWith(FIRST_WORDS[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public List getPrivateIPv4SubNets() {
        return this.subNets[0];
    }

    public List getPrivateIPv6SubNets() {
        return this.subNets[1];
    }

    public List getIPv6TunnelingSubNets() {
        return this.subNets[2];
    }
}

