/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub.link.net;

import com.wily.isengard.KIsengardConstants;
import com.wily.isengard.postofficehub.link.net.ASocketFactory;
import com.wily.isengard.postofficehub.link.net.ISSLSocketFactory;
import com.wily.isengard.postofficehub.link.net.SSLInitializationException;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.io.ExtendedFile;
import com.wily.util.properties.IndexedProperties;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public abstract class ASSLSocketFactory
extends ASocketFactory
implements ISSLSocketFactory {
    private SSLContext fContext;
    private String fServerId;
    private String[] fCipherSuites;
    private String[] fProtocols;
    private static final String fSSLStorePath = "introscope.ssl.storepath";
    private final int kDefaultSSLPort = 443;

    public ASSLSocketFactory(IModuleFeedbackChannel feedback) {
        super(feedback);
    }

    public ASSLSocketFactory(IndexedProperties properties, IModuleFeedbackChannel feedback) {
        super(properties, feedback);
        this.fServerId = properties.getProperty("client.current.serverId");
    }

    @Override
    public String[] getCipherSuites() {
        return this.fCipherSuites;
    }

    @Override
    public String[] getProtocols() {
        return this.fProtocols;
    }

    @Override
    public int getPort() {
        return 443;
    }

    @Override
    public SSLContext getSSLContext() throws SSLInitializationException {
        if (this.fContext == null) {
            try {
                this.fContext = this.createSSLContext(this.getProperties(), this.getFeedbackChannel());
            }
            catch (Exception e) {
                this.getFeedbackChannel().debug("Failed to create SSLContext", e);
                throw new SSLInitializationException("Failed to create SSLContext", e);
            }
        }
        return this.fContext;
    }

    private File getTrustStoreFile(String trustStorePath) throws FileNotFoundException {
        String sslStorePath;
        ExtendedFile trustStorePathFile = null;
        File trustStore = null;
        if (!ExtendedFile.isAbsolutePath(trustStorePath) && (sslStorePath = this.getProperties().getIndexedProperty(fSSLStorePath, 0)) != null) {
            trustStorePathFile = new ExtendedFile(new File(sslStorePath), trustStorePath);
        }
        if (!(trustStore = trustStorePathFile == null || !trustStorePathFile.exists() ? new File(trustStorePath) : new File(trustStorePathFile.getAbsolutePath())).exists()) {
            throw new FileNotFoundException("truststore file does not exist: " + trustStore.getAbsolutePath());
        }
        return trustStore;
    }

    private KeyStore getTrustStore(String trustStorePath, String trustPassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keyStore;
        File trustStoreFile = this.getTrustStoreFile(trustStorePath);
        InputStream is = null;
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            char[] password = trustPassword.toCharArray();
            is = new BufferedInputStream(new FileInputStream(trustStoreFile));
            trustStore.load(is, password);
            keyStore = trustStore;
        }
        catch (Throwable throwable) {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException iOException) {}
        return keyStore;
    }

    protected TrustManager[] createTrustManagers(KeyStore trustStore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustFactory.init(trustStore);
        return trustFactory.getTrustManagers();
    }

    protected TrustManager[] createDefaultTrustManagers() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        return trustAllCerts;
    }

    private File getKeyStoreFile(String keyStorePath) throws FileNotFoundException {
        String sslStorePath;
        ExtendedFile keyStorePathFile = null;
        File keyStore = null;
        if (!ExtendedFile.isAbsolutePath(keyStorePath) && (sslStorePath = this.getProperties().getIndexedProperty(fSSLStorePath, 0)) != null) {
            keyStorePathFile = new ExtendedFile(new File(sslStorePath), keyStorePath);
        }
        if (!(keyStore = keyStorePathFile == null || !keyStorePathFile.exists() ? new File(keyStorePath) : new File(keyStorePathFile.getAbsolutePath())).exists()) {
            throw new FileNotFoundException("keystore file does not exist: " + keyStore.getAbsolutePath());
        }
        return keyStore;
    }

    private KeyStore getKeyStore(String keyStorePath, String keyPassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keyStore;
        File keyStoreFile = this.getKeyStoreFile(keyStorePath);
        InputStream is = null;
        try {
            KeyStore keyStore2 = KeyStore.getInstance(KeyStore.getDefaultType());
            char[] password = keyPassword.toCharArray();
            is = new BufferedInputStream(new FileInputStream(keyStoreFile));
            keyStore2.load(is, password);
            keyStore = keyStore2;
        }
        catch (Throwable throwable) {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException iOException) {}
        return keyStore;
    }

    protected KeyManager[] createKeyManagers(KeyStore keyStore, String keyPassword) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        KeyManagerFactory keyFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyFactory.init(keyStore, keyPassword.toCharArray());
        return keyFactory.getKeyManagers();
    }

    protected SSLContext createSSLContext(IndexedProperties properties, IModuleFeedbackChannel feedback) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, UnrecoverableKeyException {
        String key = null;
        key = this.fServerId == null ? "transport.tcp.ciphersuites" : "transport.tcp.ciphersuites." + this.fServerId;
        this.fCipherSuites = properties.safeGetSeparatedProperty(key, ", ", new String[0]);
        key = this.fServerId == null ? "transport.tcp.protocols" : "transport.tcp.protocols." + this.fServerId;
        this.fProtocols = properties.safeGetSeparatedProperty(key, ", ", new String[0]);
        key = this.fServerId == null ? "transport.tcp.truststore" : "transport.tcp.truststore." + this.fServerId;
        String trustStorePath = properties.getProperty(key);
        key = this.fServerId == null ? "transport.tcp.trustpassword" : "transport.tcp.trustpassword." + this.fServerId;
        String trustPassword = properties.getPasswordProperty(key);
        if (!StringUtils.isEmpty(trustStorePath) && StringUtils.isEmpty(trustPassword)) {
            throw new IllegalArgumentException("trust store password property is missing " + key);
        }
        TrustManager[] trustManagers = null;
        if (trustStorePath != null && trustPassword != null) {
            KeyStore trustStore = this.getTrustStore(trustStorePath, trustPassword);
            trustManagers = this.createTrustManagers(trustStore);
        } else {
            trustManagers = this.createDefaultTrustManagers();
            feedback.verbose("No trust store configured.  Using default all-trusting trust manager");
        }
        key = this.fServerId == null ? "transport.tcp.keystore" : "transport.tcp.keystore." + this.fServerId;
        String keyStorePath = properties.getProperty(key);
        key = this.fServerId == null ? "transport.tcp.keypassword" : "transport.tcp.keypassword." + this.fServerId;
        String keyPassword = properties.getPasswordProperty(key);
        if (!StringUtils.isEmpty(keyStorePath) && StringUtils.isEmpty(keyPassword)) {
            throw new IllegalArgumentException("key store password property is missing " + key);
        }
        KeyManager[] keyManagers = null;
        if (keyStorePath != null && keyPassword != null) {
            KeyStore keyStore = this.getKeyStore(keyStorePath, keyPassword);
            keyManagers = this.createKeyManagers(keyStore, keyPassword);
        }
        return this.createSSLContext(keyManagers, trustManagers);
    }

    protected SSLContext createSSLContext(KeyManager[] keyManagers, TrustManager[] trustManagers) throws NoSuchAlgorithmException, KeyManagementException {
        String protocol = null;
        int i = 0;
        while (i < KIsengardConstants.kSSLProtocols.length) {
            protocol = KIsengardConstants.kSSLProtocols[i];
            try {
                SSLContext.getInstance(protocol);
                break;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                ++i;
            }
        }
        SSLContext context = SSLContext.getInstance(protocol);
        context.init(keyManagers, trustManagers, null);
        return context;
    }
}

