/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile;

import com.wily.diagnos.cmp.classfile.DGClassLoadingException;
import com.wily.diagnos.cmp.classfile.DGClassModificationException;
import com.wily.diagnos.cmp.classfile.DGInvalidClassFileException;
import com.wily.diagnos.cmp.classmatcher.IClassMatcher;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.mutate.IClassMutator;
import com.wily.diagnos.personality.java.classfile.DGClass;
import com.wily.diagnos.personality.java.classfile.DGField;
import com.wily.diagnos.personality.java.classfile.attributes.DGAttribute;
import com.wily.diagnos.personality.java.classfile.attributes.DGCode;
import com.wily.diagnos.personality.java.classfile.attributes.DGExceptionsAttribute;
import com.wily.diagnos.personality.java.classfile.attributes.annotations.IAnnotationAttribute;
import com.wily.diagnos.personality.java.classfile.bytecode.DGByteCode;
import com.wily.diagnos.personality.java.classfile.bytecode.DGOpcodes;
import com.wily.diagnos.personality.java.classfile.constants.DGConstantPool;
import com.wily.diagnos.personality.java.tracer.IJavaMethodTracerInstance;
import com.wily.util.classfile.ClassFileException;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IMethodName;
import com.wily.util.classfile.IMethodSignature;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;
import com.wily.util.classfile.ISlotSignature;
import com.wily.util.classfile.InvalidMethodDescriptorException;
import com.wily.util.classfile.java.ClassFileFieldDescriptor;
import com.wily.util.classfile.java.ClassFileMethodDescriptor;
import com.wily.util.classfile.java.ClassName;
import com.wily.util.classfile.java.MethodName;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DGMethod
extends DGField
implements DGOpcodes,
IModeledMethod {
    private static final String kMainMethodName = "main";
    private static final String kMainMethodDescriptor = "([Ljava/lang/String;)V";
    private DGClass fClass;
    private DGCode fCode;
    private final IMethodName fMethodName;
    private static final String kRemoteException = "java/rmi/RemoteException";

    public DGMethod(DGConstantPool cp, DataInputStream in, ICompilerLog log, DGClass cls) throws DGClassLoadingException, IOException {
        super(cp, in, log);
        try {
            this.fMethodName = MethodName.getMethodNameWithDescriptor(String.valueOf(this.getName()) + this.getTypeDescriptor());
        }
        catch (ClassFileException classFileException) {
            throw new DGInvalidClassFileException();
        }
        this.fClass = cls;
        if (this.fAttributes.hasCodeAttribute()) {
            DGCode code = this.fAttributes.getCodeAttribute();
            code.setMethod(this);
            this.fCode = code;
        }
        if (log.ICompilerLog_isLogDynamicInstrEnabled()) {
            try {
                List invocation = null;
                if (this.fCode != null) {
                    invocation = this.fCode.getInvocations();
                }
                log.ICompilerLog_logMethodCalls(this, invocation);
            }
            catch (DGClassModificationException dGClassModificationException) {
                throw new DGInvalidClassFileException();
            }
        }
    }

    public DGMethod(DGConstantPool cp, String fieldName, String fieldDesc, int accessFlags) throws DGClassModificationException {
        super(cp, fieldName, fieldDesc, accessFlags);
        try {
            this.fMethodName = MethodName.getMethodNameWithDescriptor(String.valueOf(this.getName()) + this.getTypeDescriptor());
        }
        catch (ClassFileException classFileException) {
            throw new DGClassModificationException();
        }
    }

    public IModeledClass getModeledClass() {
        return this.getDGClass();
    }

    public IMethodName getMethodName() {
        return this.fMethodName;
    }

    public IMethodSignature getSignature() {
        return this.fMethodName.getSignature();
    }

    public boolean isInstanceConstructor() {
        ClassFileFieldDescriptor returnType = null;
        try {
            returnType = new ClassFileMethodDescriptor(this.getTypeDescriptor()).getReturnType();
        }
        catch (InvalidMethodDescriptorException invalidMethodDescriptorException) {
            return false;
        }
        return this.getCode() != null && this.getName().equals("<init>") && returnType != null && returnType.isVoid();
    }

    public boolean isClassConstructor() {
        return this.getName().equals("<clinit>");
    }

    public boolean isStatic() {
        return (this.getAccessFlags() & 8) != 0;
    }

    public boolean isComplex() {
        return this.isComplex(false);
    }

    public boolean isComplex(boolean considerRestrictedMethods) {
        return this.getCode() != null && this.getCode().isComplex() && (considerRestrictedMethods || DGMethod.isPublicOrPackage(this.getAccessFlags())) && !this.getName().equals("<init>") && !this.getName().equals("<clinit>") && !this.getAttributes().hasAttributeNamed("Synthetic");
    }

    public boolean isRemote() {
        DGExceptionsAttribute exceptions = this.getExceptions();
        if (exceptions != null) {
            return exceptions.contains(kRemoteException);
        }
        return false;
    }

    private static boolean isPublicOrPackage(int accessFlags) {
        return (accessFlags & 1) != 0 || DGMethod.isPackage(accessFlags);
    }

    private static boolean isPackage(int accessFlags) {
        return (accessFlags & 1) == 0 && (accessFlags & 2) == 0 && (accessFlags & 4) == 0;
    }

    public boolean isEntryPoint() {
        return this.getName().equals(kMainMethodName) && this.getTypeDescriptor().equals(kMainMethodDescriptor) && (this.getAccessFlags() & 1) != 0 && (this.getAccessFlags() & 8) != 0;
    }

    public IClassMutator getClassMutator() {
        return this.fClass;
    }

    public DGExceptionsAttribute getExceptions() {
        return this.fAttributes.getExceptionsAttribute();
    }

    public DGClass getDGClass() {
        return this.fClass;
    }

    public DGCode getCode() {
        return this.fCode;
    }

    public List getInvocations() {
        try {
            return this.getCode().getInvocations();
        }
        catch (DGClassModificationException e) {
            this.fLog.ICompilerLog_logException(e);
        }
        catch (Throwable t) {
            this.fLog.ICompilerLog_logException(t);
        }
        return new ArrayList();
    }

    public void setCode(byte[] javaCode, int maxStack, int maxLocals) throws DGClassModificationException {
        int cpiName = this.fConstantPool.addUtf("Code");
        this.fCode = new DGCode(this.fConstantPool, cpiName, "Code", maxStack, maxLocals, javaCode);
        this.fAttributes.addAttribute(this.fCode);
    }

    public void widenJumpOffsets(int minOffsetToWiden) throws DGClassModificationException {
        if (this.fCode != null) {
            this.fCode.widenJumpOffsets(minOffsetToWiden);
        }
    }

    public void substituteClassAllocation(Integer[] cpiClassArray, int cpiSubstituteClass) throws DGClassModificationException {
        if (this.fCode != null) {
            this.fCode.substituteClassAllocation(cpiClassArray, cpiSubstituteClass);
        }
    }

    public void substituteObjrefResult(String substituteMethod) throws DGClassModificationException, IOException {
        if (this.fCode != null) {
            int separator = substituteMethod.lastIndexOf(46);
            String className = substituteMethod.substring(0, separator);
            String methodNameAndDescriptor = substituteMethod.substring(separator + 1);
            separator = methodNameAndDescriptor.indexOf(40);
            String methodName = methodNameAndDescriptor.substring(0, separator);
            String methodDescriptor = methodNameAndDescriptor.substring(separator);
            this.fCode.substituteObjrefResult(className, methodName, methodDescriptor);
        }
    }

    public void substituteResultByNamedProxy(IClassName agentEntryClass, String substituterMethod, String signature, String substituterName, boolean canProvideSampleObject) throws DGClassModificationException, IOException {
        if (this.fCode != null) {
            ISlotSignature originalMethodReturnSignature = this.getSignature().getReturnSlotSignature();
            this.fCode.substituteResultByNamedProxy((ClassName)agentEntryClass, substituterMethod, signature, substituterName, originalMethodReturnSignature.getSignatureString(), canProvideSampleObject);
        }
    }

    public void noticeConstructorCompletion(String notificationMethod) throws DGClassModificationException, IOException {
        if (this.fCode != null) {
            int separator = notificationMethod.lastIndexOf(46);
            String className = notificationMethod.substring(0, separator);
            String methodNameAndDescriptor = notificationMethod.substring(separator + 1);
            separator = methodNameAndDescriptor.indexOf(40);
            String methodName = methodNameAndDescriptor.substring(0, separator);
            String methodDescriptor = methodNameAndDescriptor.substring(separator);
            this.fCode.insertStaticMethodCallAtConstructorFinish(className, methodName, methodDescriptor);
        }
    }

    public void noticeFieldAssignments(IClassName agentEntryClass, IClassMatcher classesToNotice, IClassName eventNoticingClass) throws DGClassModificationException, IOException {
        if (this.fCode != null) {
            this.fCode.noticeFieldAssignments((ClassName)agentEntryClass, classesToNotice, (ClassName)eventNoticingClass);
        }
    }

    public void noticeObjectCreations(IClassName agentEntryClass, IClassMatcher classesToNotice, IClassName eventNoticingClass) throws DGClassModificationException, IOException {
        if (this.fCode != null) {
            this.fCode.noticeObjectCreations((ClassName)agentEntryClass, classesToNotice, (ClassName)eventNoticingClass);
        }
    }

    public void addBytecodeToMethodStart(DGByteCode bytecode) throws DGClassModificationException {
        this.insertCode(bytecode.getByteCode(), bytecode.getMaxStackSlotsUsed());
    }

    public void insertCode(byte[] javaCode, int stackBump) throws DGClassModificationException {
        if (this.fCode != null) {
            this.fCode.insertCode(javaCode);
            this.fCode.bumpMaxStack(stackBump);
        }
    }

    private int getMethodNameCPI() throws DGClassModificationException {
        return this.fConstantPool.addStringIfNecessary(this.getName());
    }

    private int getClassNameCPI(String className) throws DGClassModificationException {
        return this.fConstantPool.addStringIfNecessary(className);
    }

    public boolean containsAnnotation(IClassName annotationName) {
        if (this.fAttributes.hasAnnotations()) {
            for (DGAttribute attribute : this.fAttributes.getAttributes()) {
                IAnnotationAttribute annotationAttribute;
                if (!(attribute instanceof IAnnotationAttribute) || !(annotationAttribute = (IAnnotationAttribute)((Object)attribute)).containsAnnotation(annotationName)) continue;
                return true;
            }
        }
        return false;
    }

    public void addInstrumentation(String className, int cpiMethodRef, int instrumentationType) throws DGClassModificationException, IOException {
        if ((this.fAccessFlags & 0x500) != 0) {
            return;
        }
        int[] cpiParams = new int[]{this.getClassNameCPI(className), this.getMethodNameCPI()};
        switch (instrumentationType) {
            case 0: {
                this.fCode.insertStaticMethodCallAtOpcode(191, cpiMethodRef, cpiParams, true);
                break;
            }
            case 1: {
                this.fCode.insertStaticMethodCallAtCatch(cpiMethodRef, cpiParams);
            }
        }
    }

    public void applyTracerMutation(IJavaMethodTracerInstance tracerInst) throws DGClassModificationException, IOException {
        this.fCode.setMethodTracer(tracerInst);
    }

    public boolean hasBytecode() {
        return (this.fAccessFlags & 0x500) == 0;
    }

    public boolean passesIntelligentInstrumentationCriterea() {
        return this.fCode.passesIntelligentInstrumentationCriterea();
    }

    public int getMethodScore() {
        return this.fCode.getMethodScore();
    }
}

