/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.entrypoint;

import com.wily.agent.main.IIntelligentInstrumentationTracerHelper;
import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.intelligent.detection.AutomaticBoundaryDetectionAdmin;
import com.wily.introscope.agent.intelligent.detection.rules.CommonUtils;
import com.wily.introscope.agent.intelligent.detection.rules.SkipClassMethodRule;
import com.wily.introscope.agent.intelligent.entrypoint.Logger;
import com.wily.introscope.agent.intelligent.entrypoint.RuntimeAnomalyDetector;
import com.wily.introscope.agent.intelligent.entrypoint.apis.RuleEngine;
import com.wily.introscope.agent.trace.IEntryPointShutoff;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.cas.TransactionTransitionException;
import com.wily.introscope.agent.trace.hc2.EntryPointTracer;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.agent.trace.intelligent.frontend.FrontEndCandidateAnalyzer;
import com.wily.introscope.agent.trace.intelligent.frontend.FrontendCandidate;
import java.util.HashSet;
import java.util.concurrent.ScheduledExecutorService;

public class EntryPointRTAnomalyDetector
implements RuntimeAnomalyDetector {
    private static volatile IIntelligentInstrumentationTracerHelper intHelper = null;
    private static volatile ScheduledExecutorService schedulor = null;

    static {
        try {
            EntryPointRTAnomalyDetector.initializeHelper(AgentShim.getAgent());
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
    }

    public static void initializeHelper(IAgent agent) {
        if (intHelper == null && agent != null) {
            try {
                intHelper = agent.IAgent_getTracerAdministrator().getIntelligentInstrumentationService();
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
    }

    private EntryPointRTAnomalyDetector() {
    }

    public static void setScheduler(ScheduledExecutorService service) {
        schedulor = service;
    }

    @Override
    public void execute(InvocationData data) {
        if (this.hasNoticedAnomaly(data)) {
            try {
                this.takeAction(data);
            }
            catch (Exception e) {
                Logger.logDebugMessage("Exception while shutting off EntryPoint after detecting AEP -> FE anomaly", e);
            }
        }
    }

    @Override
    public boolean hasNoticedAnomaly(InvocationData data) {
        return data.getEntryPointBoundary() != null;
    }

    @Override
    public void takeAction(InvocationData currentInvData) {
        InvocationData epData = EntryPointRTAnomalyDetector.findEPInvocationData(currentInvData);
        if (epData != null) {
            WilyTransactionStructure.getInstance().abortTransaction(new TransactionTransitionException("Automatic Entrypoint is invoked before a Frontend"), currentInvData);
            boolean result = EntryPointRTAnomalyDetector.shutoffEPTracers(epData);
            if (result && schedulor != null) {
                final StackTraceElement[] st = Thread.currentThread().getStackTrace();
                ProbeIdentification epProbe = epData.getProbeInformation().getProbeIdentification();
                ProbeIdentification feProbe = currentInvData.getProbeInformation().getProbeIdentification();
                final String[] epClassMethod = new String[]{epProbe.getProbeClassName(), epProbe.getProbeMethodName()};
                final String[] feClassMethod = new String[]{feProbe.getProbeClassName(), feProbe.getProbeMethodName()};
                schedulor.execute(new Runnable(){

                    @Override
                    public void run() {
                        StackTraceElement[] skipElements = EntryPointRTAnomalyDetector.findClassesToSkip(st, epClassMethod[0], epClassMethod[1], feClassMethod[0], feClassMethod[1]);
                        EntryPointRTAnomalyDetector.markSkipped(skipElements);
                    }
                });
            }
        }
    }

    private static boolean hasEPTracer(InvocationData data) {
        ITracer[] tracers;
        ITracer[] iTracerArray = tracers = data.getTracersByType(EntryPointTracer.class);
        int n = tracers.length;
        int n2 = 0;
        while (n2 < n) {
            ITracer t = iTracerArray[n2];
            if (t instanceof EntryPointTracer) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean shutoffEPTracers(InvocationData data) {
        ITracer[] tracers = data.getTracersByType(IEntryPointShutoff.class);
        boolean shutoff = false;
        ITracer[] iTracerArray = tracers;
        int n = tracers.length;
        int n2 = 0;
        while (n2 < n) {
            ITracer t = iTracerArray[n2];
            if (t != null) {
                shutoff = ((IEntryPointShutoff)((Object)t)).shutoff();
            }
            ++n2;
        }
        return shutoff;
    }

    private static InvocationData findEPInvocationData(InvocationData currentInvData) {
        InvocationData data = currentInvData;
        while (data.getParent() instanceof InvocationData) {
            if (!EntryPointRTAnomalyDetector.hasEPTracer(data = (InvocationData)data.getParent())) continue;
            return data;
        }
        return null;
    }

    private static StackTraceElement[] findClassesToSkip(StackTraceElement[] st, String fromClass, String fromMethod, String toClass, String toMethod) {
        if (Logger.isTraceEnabled()) {
            Logger.logTraceMessage(String.format("Stack trace captured by Frontend Tracer on AEP -> FE :\n%s\n", CommonUtils.getStringRepresentationOfTrace(st)));
        }
        int si = 0;
        int ei = 0;
        int i = st.length - 1;
        while (i >= 0) {
            StackTraceElement e = st[i];
            if (fromClass.equals(e.getClassName()) && fromMethod.equals(e.getMethodName())) {
                ei = i;
            }
            if (toClass.equals(e.getClassName()) && toMethod.equals(e.getMethodName())) {
                si = i;
            }
            --i;
        }
        if (ei > si) {
            int l = ei - si;
            StackTraceElement[] arr = new StackTraceElement[l];
            System.arraycopy(st, si + 1, arr, 0, l);
            return arr;
        }
        return new StackTraceElement[0];
    }

    private static void markSkipped(StackTraceElement[] st) {
        HashSet<SkipClassMethodRule> rules = new HashSet<SkipClassMethodRule>();
        StackTraceElement[] stackTraceElementArray = st;
        int n = st.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement e = stackTraceElementArray[n2];
            Logger.logDebugMessage(String.format("Adding SkipClassMethod rule for class:%s & method:%s", e.getClassName(), e.getMethodName()));
            rules.add(new SkipClassMethodRule(e.getClassName(), e.getMethodName()));
            if (intHelper != null) {
                intHelper.setMethodState(e.getClassName(), e.getMethodName(), FrontendCandidate.FrontEndCandidateState.REJECTED.toString());
                FrontEndCandidateAnalyzer.stopTrackingPerformance(e.getClassName(), e.getMethodName());
            }
            ++n2;
        }
        RuleEngine engine = AutomaticBoundaryDetectionAdmin.getInstance().getEntryPointDetectionRuleEngine();
        engine.registerRules(rules);
    }

    public static EntryPointRTAnomalyDetector getInstance() {
        return LazyHolder.INSTANCE;
    }

    /* synthetic */ EntryPointRTAnomalyDetector(EntryPointRTAnomalyDetector entryPointRTAnomalyDetector) {
        this();
    }

    private static class LazyHolder {
        private static final EntryPointRTAnomalyDetector INSTANCE = new EntryPointRTAnomalyDetector(null);

        private LazyHolder() {
        }
    }
}

