/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.async;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.async.AsyncFrontendEndTracer;
import com.wily.introscope.agent.async.AsyncVirtualStack;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;

public abstract class AsyncHttpFrontendEndTracer
extends AsyncFrontendEndTracer {
    public IModuleFeedbackChannel feedback;
    public static final Module module = new Module("AsyncHttpFrontendEndTracer");
    public final IAgent agent;
    private int UNKNOWN_STATUS_CODE = -1;

    public abstract boolean isNullDataResolver();

    public abstract int getHttpStatusCode(InvocationData var1);

    public abstract String getHttpStatusMessage(InvocationData var1);

    public AsyncHttpFrontendEndTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.agent = agent;
        this.feedback = this.getAgent().IAgent_getModuleFeedback();
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        try {
            if (!data.hasInvocationThrownException() || this.showStatusCodeIfExceptionThrown()) {
                this.handleStatusCodeAndError(data);
            }
        }
        catch (ClassCastException castException) {
            this.feedback.error(module, "doOnEndTrace - expected \"elementData\" to be an instance of InvocationData");
            this.feedback.verbose(castException);
        }
        super.ITracer_finishTrace(tracerIndex, data);
    }

    protected boolean showStatusCodeIfExceptionThrown() {
        return false;
    }

    protected boolean generateErrorForErrorStatusCode() {
        return true;
    }

    public void handleStatusCodeAndError(InvocationData data) {
        if (this.isNullDataResolver()) {
            return;
        }
        int statusCode = this.getHttpStatusCode(data);
        if (statusCode == this.UNKNOWN_STATUS_CODE) {
            return;
        }
        String statusMessage = this.getHttpStatusMessage(data);
        String responseCode = String.valueOf(Integer.toString(statusCode)) + " - " + statusMessage;
        if (statusCode >= 400 && statusCode <= 599 && this.generateErrorForErrorStatusCode() && ErrorFeature.evalErrorQualificationForCurrTxn(this.getAgent(), null, responseCode)) {
            AsyncVirtualStack.decorateComponentWithError(data, responseCode);
        }
        this.asyncStack.decorateComponentWithParam(data, "HTTP Status Code", responseCode, "Frontend component");
    }
}

