/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.async;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.async.AsyncFrontendStartTracer;
import com.wily.introscope.agent.blame.ApplicationNameInfo;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.hc2.UrlGroupingProvider;
import com.wily.introscope.agent.trace.servlet.IHttpRequestHelper;
import com.wily.util.properties.AttributeListing;
import java.util.HashMap;

public abstract class AsyncHttpFrontendStartTracer
extends AsyncFrontendStartTracer {
    private static int sCompNameErrorCount = 0;
    private static final int sCompNameConsecutiveErrorThreshold = 100;
    private final String charEncoding;
    protected static boolean sHaveGivenUpGettingCompName = false;

    public AsyncHttpFrontendStartTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.charEncoding = agent.IAgent_getIndexedProperties().getProperty("introscope.agent.charEncoding");
    }

    protected abstract IHttpRequestHelper getHttpRequestHelper();

    protected abstract Object getHttpRequestObject(InvocationData var1);

    @Override
    protected String getFrontendNameForAsyncComponent(InvocationData data, String rootName) {
        String result;
        block11: {
            result = null;
            if (!sHaveGivenUpGettingCompName) {
                Object request = this.getHttpRequestObject(data);
                IHttpRequestHelper helper = this.getHttpRequestHelper();
                if (request != null) {
                    try {
                        HashMap parameterMap = new HashMap();
                        String url = UrlGroupingProvider.getNormalizedURL(this.agent, parameterMap, helper, request, data, this.charEncoding);
                        String appName = ApplicationNameInfo.resolveApplicationName(null);
                        StringBuilder sb = new StringBuilder();
                        String prefix = String.valueOf(this.getFormattedName()) + "|";
                        if (!prefix.contains("Frontends")) {
                            prefix = "Frontends|Apps|";
                        }
                        sb.append(prefix);
                        sb.append(appName);
                        sb.append("|URLs|");
                        sb.append(url);
                        result = sb.toString();
                        sCompNameErrorCount = 0;
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable t) {
                        try {
                            this.getModuleFeedback().error("An error occurred while formatting HTTP frontend metrics: " + t);
                            this.getModuleFeedback().verbose(t);
                        }
                        catch (ThreadDeath td2) {
                            throw td2;
                        }
                        catch (Throwable throwable) {}
                        if (++sCompNameErrorCount < 100) break block11;
                        sHaveGivenUpGettingCompName = true;
                    }
                }
            }
        }
        if (result == null) {
            result = this.formatParameterizedName(data);
        }
        return result.intern();
    }
}

