/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.enterprise;

import com.wily.EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArrayList;
import com.wily.introscope.agent.ACommonAgent;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.IHarvester;
import com.wily.introscope.agent.IMetricDataListener;
import com.wily.introscope.agent.beans.autotracing.AutoTracingTriggerServiceBean;
import com.wily.introscope.agent.beans.remoteconfiguration.AgentRemoteConfigurationBean;
import com.wily.introscope.agent.beans.resource.AgentResourceBean;
import com.wily.introscope.agent.bizrecording.BizRecordingAdministrator;
import com.wily.introscope.agent.blamestackfeature.IBlameStackFeatureAdministrator;
import com.wily.introscope.agent.connection.ConnectedServer;
import com.wily.introscope.agent.connection.IAgentHarvester;
import com.wily.introscope.agent.connection.IServerConnectionNotification;
import com.wily.introscope.agent.connection.IServerFailoverPolicy;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.agent.correlation.CrossProcessCorrelationAdmin;
import com.wily.introscope.agent.debug.DebugService;
import com.wily.introscope.agent.enterprise.AgentWrapperLoader;
import com.wily.introscope.agent.enterprise.EnterpriseAgentNamingPolicy;
import com.wily.introscope.agent.enterprise.FailoverPolicyFactory;
import com.wily.introscope.agent.enterprise.IServerConnectionManager;
import com.wily.introscope.agent.enterprise.IServerConnectionObserver;
import com.wily.introscope.agent.environment.EnvironmentAdministrator;
import com.wily.introscope.agent.errors.ErrorReportingService;
import com.wily.introscope.agent.event.EventAdministrator;
import com.wily.introscope.agent.extension.ExtensionAdministrator;
import com.wily.introscope.agent.extension.IExtensionLocatorPolicy;
import com.wily.introscope.agent.recording.MetricRecordingAdministrator;
import com.wily.introscope.agent.recording.RemoveMetricDataWatcher;
import com.wily.introscope.agent.resultsub.ResultSubstitutionAdministrator;
import com.wily.introscope.agent.service.ASimpleService;
import com.wily.introscope.agent.service.ServiceAdministrator;
import com.wily.introscope.agent.stalls.StallService;
import com.wily.introscope.agent.sustainability.SustainabilityService;
import com.wily.introscope.agent.trace.IMethodTracer;
import com.wily.introscope.agent.trace.IParameterizedMethodTracer;
import com.wily.introscope.agent.trace.IWallClockDelegate;
import com.wily.introscope.agent.trace.TracerAdministrator;
import com.wily.introscope.agent.transformer.TransformerAdministrator;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.metric.AgentMetricData;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.server.transactiontrace.ITransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.isengard.container.BeanActivationException;
import com.wily.util.INameChangeListener;
import com.wily.util.StringUtils;
import com.wily.util.adt.IAtomicNumber;
import com.wily.util.adt.IAtomicNumberFactory;
import com.wily.util.adt.IGuaranteedCounter;
import com.wily.util.adt.INanoTimeProvider;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;
import com.wily.util.feedback.AApplicationFeedbackChannel;
import com.wily.util.feedback.IAsynchFeedbackChannel;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.resource.IResource;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.text.MultipleResourceBundleStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EnterpriseAgent
extends ACommonAgent
implements IServerConnectionObserver,
IAgentHarvester {
    private volatile IServerConnectionManager fServerConnection;
    private final boolean[] fDisableResetServerConnection = new boolean[1];
    private final TracerAdministrator fTracerAdministrator;
    private final EventAdministrator fEventAdministrator;
    private final ResultSubstitutionAdministrator resultSubstitutionAdministrator;
    private final ServiceAdministrator fServiceAdministrator;
    private final TransformerAdministrator fTransformerAdministrator;
    private final EnvironmentAdministrator fEnvironmentAdministrator;
    private final BizRecordingAdministrator fBizRecordingAdministrator;
    private final EnterpriseAgentNamingPolicy fAgentNamingPolicy;
    private final String fProcessName;
    private final IntervalHeartbeat fRemoveMetricDataHeartbeat;
    private final StallService stallService;
    private final ErrorReportingService errorReportingService;
    public volatile IGuaranteedCounter fCounterFactory = new DefaultGuaranteedCounter();
    public volatile IAtomicNumberFactory fNumberFactory = new DefaultAtomicNumberFactory();
    public volatile INanoTimeProvider fNanoTimeProvider = new DefaultNanoTimeProvider();
    public static final List kAdditionalHarvesters = new CopyOnWriteArrayList();
    public static final List kMetricDataListeners = new CopyOnWriteArrayList();
    private static final String kHiddenTestHeartbeatInterval = "introscope.agent.metricAging.heartbeatInterval.hidden.base";

    public EnterpriseAgent(AApplicationFeedbackChannel feedback, String mainClassName, IExtensionLocatorPolicy locatorPolicy) throws BadlyFormedNameException {
        this(feedback, EnterpriseAgent.makeAgentName(mainClassName), locatorPolicy, EnterpriseAgent.makeStringLocalizer(feedback), null);
    }

    public EnterpriseAgent(AApplicationFeedbackChannel feedback, String mainClassName, IExtensionLocatorPolicy locatorPolicy, IStringLocalizer localizer, IntervalHeartbeat intervalHeartbeat) {
        super(feedback, localizer, mainClassName, intervalHeartbeat, locatorPolicy);
        this.fAgentNamingPolicy = new EnterpriseAgentNamingPolicy(this);
        this.fProcessName = this.initProcessName(mainClassName);
        this.fRemoveMetricDataHeartbeat = this.createRemoveMetricDataHeartbeat();
        this.createRemoveMetricDataWatcher(this.fRemoveMetricDataHeartbeat, this.getMetricRecordingAdministrator());
        this.fExtensionAdministrator.initialLoadExtensions();
        this.fTracerAdministrator = new TracerAdministrator(this);
        this.fEventAdministrator = new EventAdministrator(this);
        this.resultSubstitutionAdministrator = new ResultSubstitutionAdministrator(this);
        this.fServiceAdministrator = new ServiceAdministrator(this);
        this.fTransformerAdministrator = new TransformerAdministrator(this);
        this.fEnvironmentAdministrator = new EnvironmentAdministrator(this.IAgent_getConfigurationResource(), this.IAgent_getConfigurationManager(), this.IAgent_getModule(), feedback, localizer);
        this.fBizRecordingAdministrator = BizRecordingAdministrator.getBizRecordingAdministrator(this);
        this.errorReportingService = new ErrorReportingService();
        this.stallService = new StallService();
        this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_Startup_Complete_Message"));
    }

    private static String makeAgentName(String mainClassName) {
        if (mainClassName == null) {
            return "Agent";
        }
        if (mainClassName.endsWith("Agent")) {
            return mainClassName;
        }
        return String.valueOf(mainClassName) + " " + "Agent";
    }

    private static IStringLocalizer makeStringLocalizer(IModuleFeedbackChannel feedback) {
        String[] coreList = EnterpriseAgent.getCommonAgentResourceBundleList();
        String[] entireList = new String[coreList.length + 1];
        System.arraycopy(coreList, 0, entireList, 0, coreList.length);
        entireList[coreList.length] = "com.wily.introscope.agent.properties.EnterpriseAgentReleaseStrings";
        MultipleResourceBundleStringLocalizer localizer = new MultipleResourceBundleStringLocalizer(feedback, EnterpriseAgent.class.getClassLoader(), entireList, false);
        return localizer;
    }

    protected void doPostConstructionInitialize() {
        super.doPostConstructionInitialize();
        this.loadLogConfiguration();
        this.fAgentNamingPolicy.nameAgentAsync();
        this.getServiceAdministrator().loadServicePlugins(this);
        this.errorReportingService.registerAsync(this, this.getServiceAdministrator());
        this.stallService.registerAsync(this, this.getServiceAdministrator());
        if (this.fRemoveMetricDataHeartbeat != null) {
            try {
                this.fRemoveMetricDataHeartbeat.start();
            }
            catch (RuntimeException runtimeException) {
                this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Start_Remove_Metric_Data_Heartbeat_Failed"));
            }
        }
        CrossProcessCorrelationAdmin.initializeProperties(this);
        this.IAgent_getServiceAdministrator().registerServiceAsync(this, "Sustainability Service", new SustainabilityService("Sustainability Service"), new HashMap());
        if (this.fExtensionAdministrator.getOptionalExtensionManager() != null) {
            this.fExtensionAdministrator.getOptionalExtensionManager().setLoadingFlag(false);
        }
    }

    private boolean startIsengard(String agentName) {
        boolean isStarted = false;
        InitIsengardService service = new InitIsengardService(agentName);
        try {
            this.getServiceAdministrator().registerServiceSync(this, service.getName(), service, new HashMap());
            isStarted = true;
        }
        catch (Throwable e) {
            this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_Enterprise_Manager_Connection_Error_Message"));
            this.getModuleFeedback().verbose(e);
        }
        return isStarted;
    }

    protected void doPostAgentNamingInitialization(String agentName) {
        super.doPostAgentNamingInitialization(agentName);
        this.startIsengard(agentName);
        DebugService service = new DebugService();
        service.registerAsync(this, this.getServiceAdministrator());
    }

    public IAgent createAgentWrapper(IAgent delegate) {
        AgentWrapperLoader loader = new AgentWrapperLoader(this.getModuleFeedback(), this.getStringLocalizer(), this.getExtensionAdministrator());
        return loader.createAgentWrapper(delegate);
    }

    protected IAsynchFeedbackChannel getAgentShimFeedback() {
        return (IAsynchFeedbackChannel)this.getModuleFeedback();
    }

    public final ExtensionAdministrator getExtensionAdministrator() {
        return this.fExtensionAdministrator;
    }

    public final TracerAdministrator getTracerAdministrator() {
        return this.fTracerAdministrator;
    }

    public final EventAdministrator getEventAdministrator() {
        return this.fEventAdministrator;
    }

    public final ResultSubstitutionAdministrator getResultSubstitutionAdministrator() {
        return this.resultSubstitutionAdministrator;
    }

    public final ServiceAdministrator getServiceAdministrator() {
        return this.fServiceAdministrator;
    }

    public final TransformerAdministrator getTransformerAdministrator() {
        return this.fTransformerAdministrator;
    }

    public final BizRecordingAdministrator getBizRecordingAdministrator() {
        return this.fBizRecordingAdministrator;
    }

    private String initProcessName(String mainClassName) {
        char[] illegalProcessChars;
        String temp;
        String processName = this.getProperties().getProperty("introscope.agent.customProcessName");
        if (StringUtils.isEmpty(processName)) {
            processName = this.getProperties().getProperty("introscope.agent.defaultProcessName");
            if (StringUtils.isEmpty(processName) && mainClassName != null) {
                mainClassName = mainClassName.replace('/', '.');
                processName = this.getProcessNameFromMainClassName(mainClassName);
            } else if (StringUtils.isEmpty(processName) && mainClassName == null) {
                processName = "UnknownProcess";
            }
        }
        if ((temp = StringUtils.replaceIllegalChars(processName, illegalProcessChars = new char[]{'|', ':'}, ' ')) != null && temp.compareTo(processName) != 0) {
            this.getModuleFeedback().warn(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Illegal_Process_Name_Message", "introscope.agent.customProcessName", new String(illegalProcessChars)));
            processName = temp;
        }
        if (StringUtils.isEmpty(processName)) {
            this.getModuleFeedback().warn(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_Missing_Or_Blank_Process_Message"));
            processName = "UnknownProcess";
        }
        return processName;
    }

    private String getProcessNameFromMainClassName(String mainClassName) {
        if (mainClassName == null) {
            return null;
        }
        int index = mainClassName.lastIndexOf(46);
        if (index == -1) {
            return mainClassName;
        }
        return mainClassName.substring(index + 1);
    }

    public boolean IAgent_isLogFileAutoNamingEnabled() {
        boolean disableLogFileAutoNaming = this.getProperties().getBooleanProperty("introscope.agent.disableLogFileAutoNaming", false);
        boolean clonedAgent = this.getProperties().getBooleanProperty("introscope.agent.clonedAgent", false);
        boolean canAutoNameAgent = this.fAgentNamingPolicy != null && this.fAgentNamingPolicy.canAutoNameAgent();
        boolean enableLogFileAutoNaming = !disableLogFileAutoNaming && (canAutoNameAgent || clonedAgent);
        return enableLogFileAutoNaming;
    }

    private IntervalHeartbeat createRemoveMetricDataHeartbeat() {
        try {
            int hiddenPropertyValue = this.IAgent_getIndexedProperties().getIntProperty(kHiddenTestHeartbeatInterval);
            if (hiddenPropertyValue == 0) {
                hiddenPropertyValue = 86400;
            }
            return new IntervalHeartbeat("Remove Metric Data Watch Heartbeat", this.IAgent_getAgentThreadFactory(), this.getModuleFeedback(), this.IAgent_getStringLocalizer(), hiddenPropertyValue);
        }
        catch (RuntimeException re) {
            this.getModuleFeedback().error(this.IAgent_getModule(), this.IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString("Create_Remove_Metric_Data_Heartbeat_Failed"), re);
            return null;
        }
    }

    protected RemoveMetricDataWatcher createRemoveMetricDataWatcher(IntervalHeartbeat removeMetricDataHeartbeat, MetricRecordingAdministrator metricAdmin) {
        RemoveMetricDataWatcher result = null;
        if (removeMetricDataHeartbeat != null) {
            try {
                boolean bAllowBelowDefaults = this.IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.metricAging.hidden.overrride.defaults");
                result = new RemoveMetricDataWatcher(removeMetricDataHeartbeat, this.IAgent_getConfigurationManager(), this.IAgent_getModule(), this.getModuleFeedback(), this.IAgent_getStringLocalizer(), bAllowBelowDefaults);
                result.addListener(metricAdmin);
            }
            catch (RuntimeException re) {
                this.getModuleFeedback().error(this.IAgent_getModule(), this.IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString("Create_Remove_Metric_Data_Watcher_Failed"), re);
            }
        }
        return result;
    }

    protected String doGetLogFilePath() {
        return this.getProfileResource().IResource_getLocation();
    }

    private void loadLogConfiguration() {
        try {
            IResource profileResource = this.getProfileResource();
            if (profileResource != null && profileResource.IResource_isFileResource()) {
                this.setAgentFeedbackConfiguration();
            } else {
                this.getApplicationFeedback().setConfiguration(this.getProperties());
            }
            if (profileResource != null && !this.getApplicationFeedback().containsLoggingConfiguration(this.getProperties())) {
                this.getModuleFeedback().warn(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("No_Logging_Configuration_Found_Error", profileResource.IResource_getLocation()));
            }
        }
        catch (RuntimeException re) {
            this.getModuleFeedback().warn(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Loading_Logging_Configuration_Error"));
            this.getApplicationFeedback().setRootVerbose();
            this.getModuleFeedback().verbose(re);
        }
        this.getAgentShimFeedback().addAsyncLoggingToHeartbeat(this.getCommonHeartbeat());
    }

    protected void setAgentFeedbackConfiguration() {
        this.getAgentShimFeedback().setConfiguration(this.getConfigurationWatcher(), this.getProfileResource());
    }

    protected int getPreferredSerializationMode() {
        return 48;
    }

    private void initIsengard(String agentName) {
        this.getModuleFeedback().info(new Module("Isengard"), this.getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_Enterprise_Manager_Initiating_Connection_Attempts_Message"));
        try {
            IServerFailoverPolicy failoverPolicy = this.getIsengardFailoverPolicy();
            final IsengardServerConnectionManager serverConnection = new IsengardServerConnectionManager(failoverPolicy, this.IAgent_getEnvironmentAdministrator().getHostname(), this.IAgent_getEnvironmentAdministrator().getIPAddress(), this.fProcessName, agentName, this.getClonedAgentFlagFromProperties(), this.getPreferredSerializationMode(), this.getModuleFeedback(), this.getStringLocalizer(), this.IAgent_getAgentThreadFactory(), this.getSharedAsyncQueue(), this.getTransactionTraceController(), this, this.IAgent_getCommonHeartbeat(), this.IAgent_getConfigurationManager());
            this.getCommonHeartbeat().addBehavior(new ITimestampedRunnable(){

                public void ITimestampedRunnable_execute(long nowInMillis) {
                    serverConnection.watchDog();
                }
            }, "Connection Watchdog", true, 300000L, false);
            this.fExtensionAdministrator.registerExtensionClassloaders(serverConnection);
            this.fServerConnection = serverConnection;
            serverConnection.addConnectionObserver(new IServerConnectionNotification(){

                public void connectionUp() {
                    EnterpriseAgent.this.registerAgentBeans(serverConnection);
                }

                public void connectionDown() {
                }
            });
            serverConnection.addConnectionObserver(this);
            this.addShutdownHook();
            serverConnection.connect();
        }
        catch (Exception e) {
            this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_Enterprise_Manager_Connection_Error_Message"));
            this.getModuleFeedback().verbose(e);
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                if (EnterpriseAgent.this.fServerConnection != null) {
                    EnterpriseAgent.this.fServerConnection.disconnect();
                    EnterpriseAgent.this.getModuleFeedback().info("Host JVM shutting down. Disconnecting from server");
                }
            }
        });
        this.getModuleFeedback().debug("Added shutdown hook");
    }

    private void registerAgentBeans(IsengardServerConnectionManager serverConnection) {
        this.getModuleFeedback().verbose("Registering agent beans");
        ConnectedServer server = serverConnection.getConnectedServer();
        if (server == null) {
            return;
        }
        try {
            server.addBean(AgentResourceBean.class, this);
            server.addBean(AgentRemoteConfigurationBean.class, this);
            server.addBean(AutoTracingTriggerServiceBean.class, this);
        }
        catch (BeanActivationException e) {
            this.getModuleFeedback().error("Unable to register agent beans");
            this.getModuleFeedback().verbose(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canInitTransport(boolean testAndSet) {
        boolean canInit = false;
        boolean[] blArray = this.fDisableResetServerConnection;
        synchronized (this.fDisableResetServerConnection) {
            if (!this.fDisableResetServerConnection[0]) {
                canInit = true;
            } else if (testAndSet) {
                this.fDisableResetServerConnection[0] = true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return canInit;
        }
    }

    public void setNewTransport(IServerConnectionManager manager) {
        if (manager == null) {
            this.getModuleFeedback().warn("Invalid server connection manager");
        } else if (this.canInitTransport(true)) {
            this.fServerConnection = manager;
        } else {
            this.getModuleFeedback().info("Class " + manager.getClass().getName() + " ignored: manager already exists");
        }
    }

    private boolean getClonedAgentFlagFromProperties() {
        return this.getProperties().getBooleanProperty("introscope.agent.clonedAgent", false);
    }

    public final IResource IAgent_getConfigurationResource() {
        return this.getProfileResource();
    }

    public final ExtensionAdministrator IAgent_getExtensionAdministrator() {
        return this.getExtensionAdministrator();
    }

    public final TracerAdministrator IAgent_getTracerAdministrator() {
        return this.getTracerAdministrator();
    }

    public final EventAdministrator IAgent_getEventAdministrator() {
        return this.getEventAdministrator();
    }

    public final ServiceAdministrator IAgent_getServiceAdministrator() {
        return this.getServiceAdministrator();
    }

    public TransformerAdministrator IAgent_getTransformerAdministrator() {
        return this.getTransformerAdministrator();
    }

    public final EnvironmentAdministrator IAgent_getEnvironmentAdministrator() {
        return this.fEnvironmentAdministrator;
    }

    public IMethodTracer IAgent_loadTracer(int probeHashCode, String probeClassName, String probeMethodName, String probeMethodDescriptor, Object tracedObject, String tracerEncoding) {
        return this.getTracerAdministrator().loadTracer(probeHashCode, probeClassName, probeMethodName, probeMethodDescriptor, tracedObject, tracerEncoding);
    }

    public IMethodTracer IAgent_loadTracer(int probeHashCode, String probeClassName, String probeMethodName, String probeMethodDescriptor, Object tracedObject, String tracerEncoding, IWallClockDelegate clockDelegate) {
        return this.getTracerAdministrator().loadTracer(probeHashCode, probeClassName, probeMethodName, probeMethodDescriptor, tracedObject, tracerEncoding, clockDelegate);
    }

    public IParameterizedMethodTracer IAgent_loadParameterizedTracer(int probeHashCode, String probeClassName, String probeMethodName, String probeMethodDescriptor, Object tracedObject, String tracerEncoding) {
        return this.getTracerAdministrator().loadParameterizedTracer(probeHashCode, probeClassName, probeMethodName, probeMethodDescriptor, tracedObject, tracerEncoding);
    }

    public IParameterizedMethodTracer IAgent_loadParameterizedTracer(int probeHashCode, String probeClassName, String probeMethodName, String probeMethodDescriptor, Object tracedObject, String tracerEncoding, IWallClockDelegate clockDelegate) {
        return this.getTracerAdministrator().loadParameterizedTracer(probeHashCode, probeClassName, probeMethodName, probeMethodDescriptor, tracedObject, tracerEncoding, clockDelegate);
    }

    public void IAgent_noticeEvent(String probeClassName, String probeMethodName, String probeMethodDescriptor, String eventNoticingClass, String eventType, Object eventSpecificReference, String eventSpecificData, String eventSpecificData2) {
        this.getEventAdministrator().noticeEvent(probeClassName, probeMethodName, probeMethodDescriptor, eventNoticingClass, eventType, eventSpecificReference, eventSpecificData, eventSpecificData2);
    }

    public Object substituteResult(Object sampleTracedObject, Object origResult, String substituterName) {
        return this.getResultSubstitutionAdministrator().substituteResult(sampleTracedObject, origResult, substituterName);
    }

    public void IAgent_transformAssembly(int assemblyID, String assemblyPath) {
        this.getTransformerAdministrator().transformAssembly(assemblyID, assemblyPath);
    }

    public byte[] IAgent_transformClass(boolean classLoaderIsAvailable, ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classBytes) {
        return this.getTransformerAdministrator().transformClass(classLoaderIsAvailable, loader, className, classBeingRedefined, protectionDomain, classBytes);
    }

    public byte[] IAgent_transformMethod(IModeledClass modeledClass, IModeledMethod modeledMethod, byte[] methodBytes, Object contextCallback) {
        return this.getTransformerAdministrator().transformMethod(modeledClass, modeledMethod, methodBytes, contextCallback);
    }

    public boolean IAgent_isIsengardEnabled() {
        return true;
    }

    public IsengardServerConnectionManager IAgent_getIsengardServerConnection() {
        return (IsengardServerConnectionManager)this.fServerConnection;
    }

    public String IAgent_getName() {
        if (this.fServerConnection != null) {
            return this.fServerConnection.getActualAgentName();
        }
        return "UnknownAgent";
    }

    public String[] IAgent_getHostProcessAgentTriplet() {
        String[] result = new String[]{this.IAgent_getEnvironmentAdministrator().getHostname(), this.fProcessName, this.fServerConnection != null ? this.fServerConnection.getActualAgentName() : "UnknownAgent"};
        return result;
    }

    protected final void reportTransactions(TransactionComponentData[] transactions) {
        if (this.fServerConnection != null) {
            this.fServerConnection.reportTransactions(transactions);
        }
    }

    protected void noticeConnected() {
        super.noticeConnected();
    }

    protected void doReportTimeslice(AgentMetric[] newMetrics, AgentMetricData[] timeslicedBindings, AgentMetric[] deadMetrics, int timesliceType) {
        if (this.fServerConnection != null) {
            this.fServerConnection.reportTimeslice(newMetrics, timeslicedBindings, deadMetrics, timesliceType);
        }
    }

    protected final boolean doReportAgentNameChange(String newName) {
        if (this.fServerConnection != null) {
            return this.fServerConnection.reportClientNameChange(newName);
        }
        return false;
    }

    public final IndexedProperties IAgent_getIndexedProperties() {
        Assertion.wilyAssert(false);
        return this.getProperties();
    }

    public final void IAgent_writeDebugInfo(IModuleFeedbackChannel feedback) {
        this.debugInfoPrintCount(feedback, "accumulators", this.getDataCollectorCount());
        this.debugInfoPrintCount(feedback, "heartbeats", this.getCommonHeartbeat().getBehaviorCount());
    }

    private void debugInfoPrintCount(IModuleFeedbackChannel feedback, String thingBeingCounted, int currentCount) {
        feedback.info("Current size of " + thingBeingCounted + ": " + currentCount);
    }

    public final void serverConnected() {
        this.noticeConnected();
    }

    public final void serverDisconnected() {
        this.noticeDisconnected();
    }

    public final void serverConnectionCycleFailed(int cycleCount) {
        this.noticeConnectionCycleFailed(cycleCount);
    }

    public final void agentControlSetReportingState(boolean newValue) {
        this.IAgent_setRecordingEnabled(newValue);
    }

    public final void agentControlStopReportingMetric(AgentMetric metric) {
        this.getMetricRecordingAdministrator().shutMetricOff(metric);
    }

    public final void agentControlStartReportingMetric(AgentMetric metric) {
        this.getMetricRecordingAdministrator().turnMetricOn(metric);
    }

    public final void agentControlAddTTFilter(ITransactionTraceFilter filter) {
        this.getTransactionTraceController().addEMFilter(filter);
    }

    public final void agentControlRemoveTTFilter(ITransactionTraceFilter filter) {
        this.getTransactionTraceController().removeFilter(filter);
    }

    final IServerFailoverPolicy getIsengardFailoverPolicy() throws Exception {
        FailoverPolicyFactory failoverFactory = new FailoverPolicyFactory(this);
        return failoverFactory.getIsengardFailoverPolicy();
    }

    public IBlameStackFeatureAdministrator getBlameStackFeatureAdministrator() {
        return this.IAgent_getComponentTracer();
    }

    public void IAgent_addNegotiatedNameChangeListener(INameChangeListener listener) {
        if (this.fServerConnection != null) {
            this.fServerConnection.addNegotiatedNameChangeListener(listener);
        } else {
            Assertion.unimplemented();
        }
    }

    public void IAgent_removeNegotiatedNameChangeListener(INameChangeListener listener) {
        if (this.fServerConnection != null) {
            this.fServerConnection.removeNegotiatedNameChangeListener(listener);
        } else {
            Assertion.unimplemented();
        }
    }

    public void setMetricShutoffState(AgentMetric metric, boolean isShutoff) {
        if (this.fServerConnection != null) {
            this.fServerConnection.setMetricShutoffState(metric, isShutoff);
        }
    }

    public boolean isTestAgent() {
        return false;
    }

    protected IServerConnectionManager getServerConnection() {
        return this.fServerConnection;
    }

    public IGuaranteedCounter IAgent_getGuaranteedCounter() {
        return this.fCounterFactory.getNewInstance();
    }

    public IAtomicNumberFactory IAgent_getAtomicNumberFactory() {
        return this.fNumberFactory;
    }

    public void addHarvester(IHarvester harvester) {
        kAdditionalHarvesters.add(harvester);
    }

    public void addMetricDataListener(IMetricDataListener listener) {
        kMetricDataListeners.add(listener);
    }

    public long getNanoTime() {
        return this.fNanoTimeProvider.getNanoTime();
    }

    protected void notifyOnPostConstructInitializationComplete() {
        this.getTracerAdministrator().notifyOnPostConstructInitializationComplete();
    }

    private final class DefaultAtomicNumberFactory
    implements IAtomicNumberFactory {
        private DefaultAtomicNumberFactory() {
        }

        public IAtomicNumber getInstance(int seed) {
            return new DefaultAtomicNumber(seed);
        }

        public IAtomicNumber getInstance(long seed) {
            return new DefaultAtomicNumber(seed);
        }

        private class DefaultAtomicNumber
        implements IAtomicNumber {
            long number;

            public DefaultAtomicNumber(int seed) {
                this.number = seed;
            }

            public DefaultAtomicNumber(long seed) {
                this.number = seed;
            }

            public synchronized int getIntAtomic() {
                return (int)this.number;
            }

            public synchronized long getLongAtomic() {
                return this.number;
            }

            public synchronized int getIntAndSet(int value) {
                int result = (int)this.number;
                this.number = value;
                return result;
            }

            public synchronized long getLongAndSet(long value) {
                long result = this.number;
                this.number = value;
                return result;
            }

            public synchronized int addIntAndGet(int addition) {
                this.number += (long)addition;
                return (int)this.number;
            }

            public synchronized long addLongAndGet(long addition) {
                this.number += addition;
                return this.number;
            }

            public synchronized int incrementIntAndGet() {
                return (int)this.number++;
            }

            public synchronized long incrementLongAndGet() {
                return this.number++;
            }

            public synchronized int decrementIntAndGet() {
                return (int)this.number--;
            }

            public synchronized long decrementLongAndGet() {
                return this.number--;
            }
        }
    }

    private class DefaultGuaranteedCounter
    implements IGuaranteedCounter {
        private int counter = 0;

        private DefaultGuaranteedCounter() {
        }

        public IGuaranteedCounter getNewInstance() {
            return new DefaultGuaranteedCounter();
        }

        public synchronized int next() {
            ++this.counter;
            return this.counter;
        }

        public synchronized int prev() {
            --this.counter;
            return this.counter;
        }

        public synchronized void reset() {
            this.counter = 0;
        }

        public synchronized int peek() {
            return this.counter;
        }

        public synchronized int getAndSet(int i) {
            int result = this.counter;
            this.counter = 0;
            return result;
        }
    }

    private class DefaultNanoTimeProvider
    implements INanoTimeProvider {
        private DefaultNanoTimeProvider() {
        }

        public long getNanoTime() {
            return System.currentTimeMillis() * 1000000L;
        }
    }

    private final class InitIsengardService
    extends ASimpleService {
        private final String fAgentName;

        public InitIsengardService(String agentName) {
            super("Init Isengard");
            this.fAgentName = agentName;
        }

        protected void doStartService(IAgent agent, Map parameters) {
            if (EnterpriseAgent.this.canInitTransport(false)) {
                EnterpriseAgent.this.initIsengard(this.fAgentName);
            }
        }
    }
}

