/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.remote;

import com.wily.introscope.agent.IAgent;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IMethodName;
import com.wily.util.classfile.IMethodSignature;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.InvalidMethodDescriptorException;
import com.wily.util.classfile.InvalidMethodNameException;
import com.wily.util.classfile.java.ClassFileMethodDescriptor;
import com.wily.util.classfile.java.ClassName;
import com.wily.util.classfile.java.MethodName;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.PrintWriter;
import java.util.Iterator;

public final class RemoteModeledMethod
implements IModeledMethod {
    private final IModuleFeedbackChannel fFeedback;
    private final String methodName;
    private final String className;
    private final String methodDescriptor;

    public RemoteModeledMethod(IAgent agent, String methodName, String className, String methodDescriptor) {
        this.methodName = methodName;
        this.className = className;
        this.methodDescriptor = methodDescriptor;
        this.fFeedback = agent.IAgent_getModuleFeedback();
    }

    public IModeledClass getModeledClass() {
        return new IModeledClass(){

            public IClassName getClassName() {
                try {
                    return ClassName.getClassName(RemoteModeledMethod.this.className);
                }
                catch (InvalidClassNameException e) {
                    RemoteModeledMethod.this.fFeedback.error("Invalid class name: " + RemoteModeledMethod.this.className + " " + e.getMessage());
                    if (RemoteModeledMethod.this.fFeedback.isDebugEnabled()) {
                        RemoteModeledMethod.this.fFeedback.debug(e);
                    }
                    return null;
                }
            }

            public boolean hasSuperClass() {
                return false;
            }

            public IClassName getSuperClassName() {
                return null;
            }

            public boolean isInterface() {
                return false;
            }

            public boolean isValueType() {
                return false;
            }

            public boolean inheritsDirectlyFromInterface(IClassName interfaceName) {
                return false;
            }

            public boolean isInstanceOf(IClassName classOrinterfaceName) {
                return false;
            }

            public Iterator getAllDeclaredMethods() {
                return null;
            }

            public boolean containsAnnotation(IClassName annotationName) {
                return false;
            }

            public boolean referencesClass(IClassName referencedName) {
                return false;
            }

            public void debugDump(PrintWriter log) {
                log.println(RemoteModeledMethod.this.className);
            }
        };
    }

    public IMethodName getMethodName() {
        try {
            return MethodName.getMethodName(this.methodName);
        }
        catch (InvalidMethodDescriptorException e) {
            this.fFeedback.error("Invalid method desriptor: " + this.className + "." + this.methodName + " " + this.methodDescriptor + " " + e.getMessage());
            if (this.fFeedback.isDebugEnabled()) {
                this.fFeedback.debug(e);
            }
            return null;
        }
        catch (InvalidMethodNameException e) {
            this.fFeedback.error("Invalid method name: " + this.className + "." + this.methodName + " " + this.methodDescriptor + " " + e.getMessage());
            if (this.fFeedback.isDebugEnabled()) {
                this.fFeedback.debug(e);
            }
            return null;
        }
    }

    public IMethodSignature getSignature() {
        try {
            if (this.methodDescriptor != null && this.methodDescriptor.length() > 0) {
                return new ClassFileMethodDescriptor(this.methodDescriptor);
            }
            return new ClassFileMethodDescriptor("()V");
        }
        catch (InvalidMethodDescriptorException e) {
            this.fFeedback.error("Invalid method desriptor: " + this.className + "." + this.methodName + " " + this.methodDescriptor + " " + e.getMessage());
            if (this.fFeedback.isDebugEnabled()) {
                this.fFeedback.debug(e);
            }
            return null;
        }
    }

    public boolean isInstanceConstructor() {
        return this.methodName.equals(this.className);
    }

    public boolean isClassConstructor() {
        return false;
    }

    public boolean isStatic() {
        return false;
    }

    public boolean isEntryPoint() {
        return false;
    }

    public boolean hasBytecode() {
        return true;
    }

    public boolean isComplex() {
        return true;
    }

    public boolean containsAnnotation(IClassName annotationName) {
        return false;
    }

    public boolean isComplex(boolean includeRestricted) {
        return true;
    }

    public boolean isRemote() {
        return false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.methodDescriptor == null ? 0 : this.methodDescriptor.hashCode());
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteModeledMethod other = (RemoteModeledMethod)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.methodDescriptor == null ? other.methodDescriptor != null : !this.methodDescriptor.equals(other.methodDescriptor)) {
            return false;
        }
        return !(this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName));
    }
}

