/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.trace.DefaultNameFormatter;
import com.wily.introscope.agent.trace.ICachedNameFormatter;
import com.wily.introscope.agent.trace.IMetricNameFormatListener;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.ITracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.util.ArrayList;
import java.util.List;

public abstract class ATracerFactory
implements ITracerFactory {
    protected static final ICachedNameFormatter kDefaultFormatter = new DefaultNameFormatter();
    private static final AllResultFilter kAllResultFilter = new AllResultFilter();
    private static final NormalCompletionResultFilter kNormalCompletionResultFilter = new NormalCompletionResultFilter();
    private static final ThrownExceptionResultFilter kThrownExceptionResultFilter = new ThrownExceptionResultFilter();
    private final IAgent fAgent;
    private final AttributeListing fTracerParameters;
    private final ProbeIdentification fProbeIdentification;
    private final INameFormatter fCustomNameFormatter;
    private final String fName;
    private final String fResource;
    private final boolean fHasParametersInName;
    private final boolean fUseFormatter;
    private final boolean fCanUseCaching;
    private final String fFormattedName;
    private final String fFormattedResource;
    private final ComponentTracer fComponentTracer;
    private final IResultFilter fResultFilter;
    private boolean fLoggedUsageRequiresParameters;
    private int fAgentComponent;
    private List fMetricNameFormatListeners;

    public ATracerFactory() {
        this.fAgent = null;
        this.fTracerParameters = null;
        this.fProbeIdentification = null;
        this.fCustomNameFormatter = null;
        this.fName = null;
        this.fResource = null;
        this.fHasParametersInName = false;
        this.fUseFormatter = false;
        this.fCanUseCaching = false;
        this.fFormattedName = null;
        this.fFormattedResource = null;
        this.fComponentTracer = null;
        this.fResultFilter = null;
        this.fAgentComponent = -1;
    }

    public ATracerFactory(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        Assertion.wilyAssert(false);
        Assertion.wilyAssert(false);
        Assertion.wilyAssert(false);
        this.fAgent = agent;
        this.fTracerParameters = parameters;
        this.fProbeIdentification = probe;
        this.fCustomNameFormatter = this.calculateNameFormatter(agent);
        this.fName = this.getParameter("name");
        this.fResource = this.calculateResource();
        this.fUseFormatter = this.calculateUseFormatter();
        this.fHasParametersInName = this.calculateHasParametersInName();
        this.fCanUseCaching = this.calculateCanUseCaching();
        this.fFormattedName = this.calculateFormattedName(sampleTracedObject);
        this.fFormattedResource = this.calculateFormattedResource(sampleTracedObject);
        this.fComponentTracer = this.getAgent().IAgent_getComponentTracer();
        this.fResultFilter = this.calculateResultFilter();
        this.fLoggedUsageRequiresParameters = false;
        this.setAgentComponent();
    }

    private void setAgentComponent() {
        String agentComponent = this.getParameter("agentcomponent");
        if (agentComponent != null) {
            if (agentComponent.startsWith("SQL")) {
                this.fAgentComponent = 1;
            } else if (agentComponent.startsWith("Soc")) {
                this.fAgentComponent = 2;
            }
        }
    }

    public final ProbeIdentification getProbeIdentification() {
        return this.fProbeIdentification;
    }

    private final INameFormatter calculateNameFormatter(IAgent agent) {
        String nameFormatterString = this.getParameter("nameformatter");
        if (nameFormatterString == null) {
            return null;
        }
        return agent.IAgent_getTracerAdministrator().loadNameFormatter(nameFormatterString);
    }

    private final IResultFilter calculateResultFilter() {
        String resultFilter = this.getParameter("resultfilter");
        if (resultFilter != null) {
            if (resultFilter.equalsIgnoreCase("normalcompletion")) {
                return kNormalCompletionResultFilter;
            }
            if (resultFilter.equalsIgnoreCase("thrownexception")) {
                return kThrownExceptionResultFilter;
            }
        }
        return kAllResultFilter;
    }

    private final String calculateResource() {
        String name = this.getNameParameter();
        if (name == null) {
            return null;
        }
        int index = name.lastIndexOf(":");
        if (index > 0) {
            return name.substring(0, index);
        }
        return null;
    }

    private final boolean calculateUseFormatter() {
        INameFormatter formatter = this.getCustomNameFormatter();
        return formatter != null && !(formatter instanceof ICachedNameFormatter);
    }

    private final boolean calculateHasParametersInName() {
        String name = this.getNameParameter();
        if (name != null) {
            int prefixIndex = name.indexOf("{");
            while (prefixIndex != -1) {
                if (prefixIndex < name.length() - 1 && Character.isDigit(name.charAt(prefixIndex + 1))) {
                    return true;
                }
                prefixIndex = name.indexOf("{", prefixIndex + 1);
            }
        }
        return false;
    }

    private final boolean calculateCanUseCaching() {
        return !this.hasParametersInName() && !this.shouldUseFormatter();
    }

    private final String calculateFormattedName(Object sampleTracedObject) {
        String result = this.initialFormat(this.getNameParameter(), sampleTracedObject);
        return result;
    }

    private final String calculateFormattedResource(Object sampleTracedObject) {
        String resource = this.getResource();
        if (resource != null) {
            return this.initialFormat(resource, sampleTracedObject);
        }
        return null;
    }

    private final String initialFormat(String value, Object sampleTracedObject) {
        try {
            INameFormatter formatter = this.getCustomNameFormatter();
            if (formatter != null && formatter instanceof ICachedNameFormatter) {
                ICachedNameFormatter cachedFormatter = (ICachedNameFormatter)formatter;
                value = cachedFormatter.ICachedNameFormatter_format(value, this.getProbeIdentification(), sampleTracedObject);
            }
            value = kDefaultFormatter.ICachedNameFormatter_format(value, this.getProbeIdentification(), sampleTracedObject);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Tracer_Factory_Formatting_Name_Error_Message", value, this.getProbeIdentification().getProbeClassName(), this.getProbeIdentification().getProbeMethodName(), this.getProbeIdentification().getProbeMethodDescriptor()));
            this.getModuleFeedback().verbose(t);
        }
        return value;
    }

    private final String customFormat(String value, InvocationData data) {
        try {
            INameFormatter formatter = this.getCustomNameFormatter();
            if (formatter != null) {
                value = formatter.INameFormatter_format(value, data);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Tracer_Factory_Formatting_Name_Error_Message", value, this.getProbeIdentification().getProbeClassName(), this.getProbeIdentification().getProbeMethodName(), this.getProbeIdentification().getProbeMethodDescriptor()));
            this.getModuleFeedback().verbose(t);
        }
        return value;
    }

    protected final ReentrancyLevel calculateReentrancyLevel(ReentrancyLevel defaultReentrancyLevel) {
        String value = this.getParameter("reentrancy");
        if (value != null) {
            if (value.equals("instance")) {
                return ReentrancyLevel.kInstance;
            }
            if (value.equals("methodname")) {
                return ReentrancyLevel.kMethodName;
            }
        }
        return defaultReentrancyLevel;
    }

    protected final boolean calculateUseBlame(boolean defaultUseBlame) {
        return this.calculateBooleanParameter("useblame", defaultUseBlame);
    }

    protected final boolean calculateBooleanParameter(String key, boolean defaultValue) {
        String value = this.getParameter(key);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return defaultValue;
    }

    protected final int calculateIntegerParameter(String key, int defaultValue) {
        String value = this.getParameter(key);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    protected final IAgent getAgent() {
        return this.fAgent;
    }

    protected final IModuleFeedbackChannel getModuleFeedback() {
        return this.getAgent().IAgent_getModuleFeedback();
    }

    protected final IStringLocalizer getStringLocalizer() {
        return this.getAgent().IAgent_getStringLocalizer();
    }

    protected final IndexedProperties getIndexedProperties() {
        return this.getAgent().IAgent_getIndexedProperties();
    }

    protected final DataAccumulatorFactory getDataAccumulatorFactory() {
        return this.getAgent().IAgent_getDataAccumulatorFactory();
    }

    protected final ComponentTracer getComponentTracer() {
        return this.fComponentTracer;
    }

    protected final INameFormatter getCustomNameFormatter() {
        return this.fCustomNameFormatter;
    }

    protected final String getResource() {
        return this.fResource;
    }

    public final String getParameter(String key) {
        return this.fTracerParameters.get(key);
    }

    public final int getAgentComponent() {
        return this.fAgentComponent;
    }

    protected final String getNameParameter() {
        return this.fName;
    }

    private final boolean hasParametersInName() {
        return this.fHasParametersInName;
    }

    private final boolean shouldUseFormatter() {
        return this.fUseFormatter;
    }

    protected final boolean canUseCaching() {
        return this.fCanUseCaching;
    }

    public final String getFormattedName() {
        return this.fFormattedName;
    }

    public final String getFormattedResource() {
        return this.fFormattedResource;
    }

    private final String runtimeFormat(String value, InvocationData data) {
        if (this.shouldUseFormatter()) {
            value = this.customFormat(value, data);
        }
        if (this.hasParametersInName()) {
            value = data.formatWithParameters(value);
        }
        return value;
    }

    protected final String formatParameterizedName(InvocationData data) {
        return this.runtimeFormat(this.getFormattedName(), data);
    }

    protected final String formatParameterizedResource(InvocationData data) {
        return this.runtimeFormat(this.getFormattedResource(), data);
    }

    protected final int getIntegerParameter(String key, int defaultValue) {
        String value = this.getParameter(key);
        if (value != null && !value.equals("")) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                this.getModuleFeedback().debug(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Tracer_Factory_Tracer_Expected_Integer_Parameter_Error_Message", new String[]{key, value, this.getClass().getName(), this.getProbeIdentification().getProbeClassName(), this.getProbeIdentification().getProbeMethodName(), this.getProbeIdentification().getProbeMethodDescriptor()}));
            }
        }
        return defaultValue;
    }

    protected final boolean invocationPassesResultFilter(InvocationData data) {
        return this.fResultFilter.IResultFilter_shouldReportResult(this, data);
    }

    private final void logUsageRequiresParameters() {
        if (!this.fLoggedUsageRequiresParameters) {
            this.fLoggedUsageRequiresParameters = true;
            this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Tracer_Factory_Tracer_Requires_Parameters_Error_Message", this.getClass().getName(), this.getProbeIdentification().getProbeClassName(), this.getProbeIdentification().getProbeMethodName(), this.getProbeIdentification().getProbeMethodDescriptor()));
        }
    }

    public void ITracerFactory_addMetricNameFormatListener(IMetricNameFormatListener metricNameFormatListener) {
        if (this.fMetricNameFormatListeners == null) {
            this.fMetricNameFormatListeners = new ArrayList(1);
        }
        this.fMetricNameFormatListeners.add(metricNameFormatListener);
    }

    protected void notifyMetricListenerInitialFormat(String nameParameter, String result) {
        if (this.fMetricNameFormatListeners != null) {
            int i = 0;
            while (i < this.fMetricNameFormatListeners.size()) {
                ((IMetricNameFormatListener)this.fMetricNameFormatListeners.get(i)).notifyFormatting(nameParameter, result);
                ++i;
            }
        }
    }

    protected void notifyMetricListenerRuntimeFormat(String nameParameter, String value) {
        if (this.fMetricNameFormatListeners != null) {
            int i = 0;
            while (i < this.fMetricNameFormatListeners.size()) {
                ((IMetricNameFormatListener)this.fMetricNameFormatListeners.get(i)).notifyFormatting(nameParameter, value);
                ++i;
            }
        }
    }

    public void exportParameterNameAndRuntimeFormat(IMetricNameFormatListener listener, int tracerIndex, InvocationData data) {
        listener.notifyFormatting(this.getNameParameter(), data.getComponentNameAt(tracerIndex));
    }

    private static final class AllResultFilter
    implements IResultFilter {
        private AllResultFilter() {
        }

        public final boolean IResultFilter_shouldReportResult(ATracerFactory tracer, InvocationData data) {
            return true;
        }
    }

    private static interface IResultFilter {
        public boolean IResultFilter_shouldReportResult(ATracerFactory var1, InvocationData var2);
    }

    private static final class NormalCompletionResultFilter
    implements IResultFilter {
        private NormalCompletionResultFilter() {
        }

        public final boolean IResultFilter_shouldReportResult(ATracerFactory tracer, InvocationData data) {
            if (data.hasMethodResultAvailable()) {
                return !data.hasInvocationThrownException();
            }
            tracer.logUsageRequiresParameters();
            return false;
        }
    }

    private static final class ThrownExceptionResultFilter
    implements IResultFilter {
        private ThrownExceptionResultFilter() {
        }

        public final boolean IResultFilter_shouldReportResult(ATracerFactory tracer, InvocationData data) {
            if (data.hasMethodResultAvailable()) {
                return data.hasInvocationThrownException();
            }
            tracer.logUsageRequiresParameters();
            return false;
        }
    }
}

