/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postoffice;

import com.wily.EDU.oswego.cs.dl.util.concurrent.BoundedLinkedQueue;
import com.wily.EDU.oswego.cs.dl.util.concurrent.Executor;
import com.wily.isengard.message.AMessage;
import com.wily.isengard.message.MessageUndeliverableException;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.MethodCallMessage;
import com.wily.isengard.messageprimitives.service.MessageServiceFactory;
import com.wily.isengard.postoffice.Address;
import com.wily.isengard.postoffice.CorruptedMessage;
import com.wily.isengard.postoffice.IPostOfficeNotification;
import com.wily.isengard.postoffice.InvalidPostOfficeException;
import com.wily.isengard.postoffice.Mailbox;
import com.wily.isengard.postoffice.MailboxInUseException;
import com.wily.isengard.postoffice.MessageUndeliverableMessage;
import com.wily.isengard.postoffice.PostOfficeHub;
import com.wily.isengard.postoffice.PostOfficeSpecifier;
import com.wily.isengard.postoffice.RemoteCallerInfo;
import com.wily.isengard.registry.IRegistryService;
import com.wily.isengard.registry.IRegistryServiceLocal;
import com.wily.isengard.util.parameter.CheckParameter;
import com.wily.util.adt.IntHashMap;
import com.wily.util.clock.MasterClock;
import com.wily.util.concurrent.IncrementingNameThreadFactoryOLD;
import com.wily.util.concurrent.PooledVaryingExecutor;
import com.wily.util.exception.UnexpectedExceptionError;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.wilyassert.Assertion;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PostOffice {
    public static final String kMainPostOfficeName = "main";
    private static RemoteCallerInfo sInternalRemoteCaller = new RemoteCallerInfo(new PostOfficeSpecifier("Local", "Local"), "localhost");
    private static int kMaxQueuedMessages = Integer.MAX_VALUE;
    private static Module sModule = new Module("PostOffice");
    private static ThreadLocal sRemoteCaller = new ThreadLocal();
    private final IModuleFeedbackChannel fFeedback;
    private int fMailboxSequenceNum = 256;
    private final PostOfficeSpecifier fName;
    private final PostOfficeHub fPostOfficeHub;
    private final List fNotification;
    private final IntHashMap fMailboxMap;
    private volatile boolean fIsClosed;
    private final HashMap fMailboxCloseMap;
    private final ReferenceQueue fReferenceQueue;
    private int fDeliveryCount;
    private final PooledVaryingExecutor fMailMen;
    private int fActiveDeliveryThreads;
    private final BoundedLinkedQueue fMessageQueue;
    private HashMap messageStatistics;

    public PostOffice(PostOfficeHub hub, String name, int numMailMen) {
        this(hub, name, numMailMen, kMaxQueuedMessages);
    }

    public PostOffice(PostOfficeHub hub, String name, int numMailMen, int maxDeliveryQueueSize) {
        CheckParameter.isPositive("Number of Mail Men", numMailMen);
        CheckParameter.isPositive("Incoming message delivery queue size.", maxDeliveryQueueSize);
        this.fName = new PostOfficeSpecifier(hub.getHubName(), name);
        this.fPostOfficeHub = hub;
        this.fMailboxMap = new IntHashMap(8, 2.0f);
        this.fNotification = Collections.synchronizedList(new ArrayList());
        this.fFeedback = hub.getFeedbackChannel();
        this.fReferenceQueue = new ReferenceQueue();
        this.fMailboxCloseMap = new HashMap();
        this.fMessageQueue = new BoundedLinkedQueue(maxDeliveryQueueSize);
        this.fMailMen = new PooledVaryingExecutor("PO", this.fMessageQueue, numMailMen, numMailMen);
        IncrementingNameThreadFactoryOLD threadFactory = new IncrementingNameThreadFactoryOLD("PO:" + name + " Mailman", this.fPostOfficeHub.getThreadFactory());
        this.fMailMen.setThreadFactory(threadFactory);
        this.fMailMen.setKeepAliveTime(0x7FFFFFFEL);
        hub.addLocalPostOffice(this);
        this.getFeedbackChannel().debug(sModule, "PostOffice: " + this.fName.toString() + " created.");
    }

    public PostOffice(PostOfficeHub hub, String name) {
        this(hub, name, 1);
    }

    public String toString() {
        return this.fName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumMailboxes() {
        IntHashMap intHashMap = this.fMailboxMap;
        synchronized (intHashMap) {
            return this.fMailboxMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debugDumpMailboxes() {
        boolean debug = false;
        if (debug) {
            IntHashMap intHashMap = this.fMailboxMap;
            synchronized (intHashMap) {
                Mailbox[] box = this.fMailboxMap.values().toArray(new Mailbox[0]);
                int i = 0;
                while (i < box.length) {
                    box[i].dumpCreationStack();
                    ++i;
                }
            }
        }
    }

    public boolean isClosed() {
        return this.fIsClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Mailbox[] box;
        this.getFeedbackChannel().debug(sModule, "Closing PostOffice.");
        PostOffice postOffice = this;
        synchronized (postOffice) {
            if (this.isClosed()) {
                return;
            }
            this.fIsClosed = true;
        }
        IntHashMap intHashMap = this.fMailboxMap;
        synchronized (intHashMap) {
            box = this.fMailboxMap.values().toArray(new Mailbox[0]);
        }
        int i22 = 0;
        while (i22 < box.length) {
            if (!box[i22].getIsSystemService()) {
                box[i22].close();
            }
            ++i22;
        }
        IntHashMap i22 = this.fMailboxMap;
        synchronized (i22) {
            box = this.fMailboxMap.values().toArray(new Mailbox[0]);
        }
        int i = 0;
        while (i < box.length) {
            box[i].close();
            ++i;
        }
        this.fPostOfficeHub.removePostOffice(this);
        this.fMailMen.shutdownNow();
        this.getFeedbackChannel().debug(sModule, "PostOffice successfully closed.");
    }

    public PostOfficeHub getPostOfficeHub() {
        return this.fPostOfficeHub;
    }

    public int getNumQueuedMessages() {
        return this.fMessageQueue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getAndResetMessageStatistics() {
        HashMap result = null;
        if (this.messageStatistics != null) {
            result = new HashMap();
            HashMap hashMap = this.messageStatistics;
            synchronized (hashMap) {
                for (Map.Entry entry : this.messageStatistics.entrySet()) {
                    MessageStatistics stats = (MessageStatistics)entry.getValue();
                    result.put(entry.getKey(), stats.cloneInst());
                    stats.reset();
                }
            }
        } else {
            this.messageStatistics = new HashMap();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void registerNewMailbox(Mailbox box, int boxNumber) throws MailboxInUseException {
        if (boxNumber == 1) {
            this.fPostOfficeHub.setRegistryAddress(box.getAddress());
        }
        IntHashMap intHashMap = this.fMailboxMap;
        synchronized (intHashMap) {
            Mailbox temp = (Mailbox)this.fMailboxMap.put(boxNumber, box);
            if (temp != null) {
                this.fMailboxMap.put(boxNumber, temp);
                throw new MailboxInUseException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeMailbox(Mailbox box) {
        IntHashMap intHashMap = this.fMailboxMap;
        synchronized (intHashMap) {
            this.fMailboxMap.remove(box.getMailboxNumber());
        }
    }

    public synchronized int getNextSequentialMailboxNumber() {
        int num = this.fMailboxSequenceNum;
        this.fMailboxSequenceNum = this.fMailboxSequenceNum + 1 & Integer.MAX_VALUE;
        if (this.fMailboxSequenceNum < 256) {
            this.fMailboxSequenceNum = 256;
        }
        return num;
    }

    int createNewMailbox(Mailbox box) {
        while (true) {
            int boxNumber = this.getNextSequentialMailboxNumber();
            try {
                this.registerNewMailbox(box, boxNumber);
                return boxNumber;
            }
            catch (MailboxInUseException mailboxInUseException) {
                continue;
            }
            break;
        }
    }

    public IRegistryService getRegistry() throws ConnectionException {
        return (IRegistryService)MessageServiceFactory.getService(this, IRegistryService.class, this.getRegistryAddress());
    }

    public IRegistryServiceLocal getLocalRegistry() {
        return this.getPostOfficeHub().getLocalRegistry();
    }

    public Address getRegistryAddress() throws ConnectionException {
        return this.fPostOfficeHub.getRegistryAddress();
    }

    public PostOfficeSpecifier getSpecifier() {
        return this.fName;
    }

    private boolean isLocalDelivery(Address destination) {
        return destination.getPostOffice().equals(this.fName);
    }

    public void validateMailbox(Address source) {
        Mailbox box;
        if (source != null && (box = this.getMailboxFromAddress(source)) == null) {
            throw new RuntimeException("Invalid mailbox at " + source);
        }
    }

    public IModuleFeedbackChannel getFeedbackChannel() {
        return this.fFeedback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deliverInternal(AMessage message, Address destination) {
        boolean messageDelivered;
        block27: {
            Mailbox box;
            messageDelivered = false;
            if ((this.fDeliveryCount++ & 0x7FF) == 2047) {
                this.closeAllWeaklyReferencedMailboxes();
            }
            if ((box = this.getMailboxFromAddress(destination)) != null) {
                if (this.getFeedbackChannel().isTraceEnabled(sModule)) {
                    this.getFeedbackChannel().trace(sModule, "Delivering " + message.toString(destination));
                }
                if (message instanceof CorruptedMessage) {
                    try {
                        Object handler = box.getInvocationHandler();
                        StringBuffer buf = new StringBuffer();
                        buf.append("Received corrupted message: ");
                        buf.append(message.toString(destination));
                        buf.append(" for: ");
                        buf.append(box);
                        buf.append(" class: ");
                        buf.append(box.getClass().getName());
                        if (handler != null) {
                            buf.append(" handler: ");
                            buf.append(handler.getClass().getName());
                        }
                        this.getFeedbackChannel().error(sModule, buf.toString());
                    }
                    catch (Exception exception) {}
                    return false;
                }
                try {
                    try {
                        PostOffice handler = this;
                        synchronized (handler) {
                            ++this.fActiveDeliveryThreads;
                        }
                        box.handleMessage(message);
                        messageDelivered = true;
                    }
                    catch (Throwable t) {
                        this.getFeedbackChannel().error(sModule, "PostOffice thread caught exception while delivering message.", t);
                        this.fPostOfficeHub.reportUnrecoverableException(t);
                        PostOffice postOffice = this;
                        synchronized (postOffice) {
                            --this.fActiveDeliveryThreads;
                            break block27;
                        }
                    }
                }
                catch (Throwable throwable) {
                    PostOffice postOffice = this;
                    synchronized (postOffice) {
                        --this.fActiveDeliveryThreads;
                    }
                    throw throwable;
                }
                PostOffice postOffice = this;
                synchronized (postOffice) {
                    --this.fActiveDeliveryThreads;
                }
            }
            messageDelivered = false;
            if (message.getSourceAddress() != null) {
                MessageUndeliverableMessage reportError = new MessageUndeliverableMessage(message, destination, "Destination Mailbox Closed", null);
                try {
                    this.handleMessage(reportError, message.getSourceAddress());
                }
                catch (MessageUndeliverableException messageUndeliverableException) {}
                this.getFeedbackChannel().debug(sModule, "Message sent to unregistered mailbox " + message.toString(destination));
            }
        }
        return messageDelivered;
    }

    public void handleMessage(AMessage message, Address destination) throws MessageUndeliverableException {
        Assertion.wilyAssert(destination != null);
        if (this.isLocalDelivery(destination)) {
            this.deliverInternal(message, destination);
        } else {
            this.fPostOfficeHub.routeMessage(message, destination);
        }
    }

    public void deliverFromHub(final AMessage message, final Address destination) {
        if (message.getHubShouldDirectDeliver()) {
            if (message instanceof MessageUndeliverableMessage) {
                try {
                    this.getExceptionAsyncExecutor().execute(new Runnable(){

                        @Override
                        public void run() {
                            PostOffice.this.deliverInternal(message, destination);
                        }
                    });
                }
                catch (InterruptedException e) {
                    throw new UnexpectedExceptionError(e);
                }
            } else {
                this.deliverInternal(message, destination);
            }
        } else {
            try {
                this.enqueueMessage(message, destination);
            }
            catch (InvalidPostOfficeException e) {
                this.getFeedbackChannel().error(e);
            }
        }
    }

    public void addPostOfficeNotification(IPostOfficeNotification handler) {
        this.fNotification.add(handler);
    }

    public void removePostOfficeNotification(IPostOfficeNotification handler) {
        this.fNotification.remove(handler);
    }

    public void postOfficeAdded(PostOfficeSpecifier poName) {
        IPostOfficeNotification[] notification = this.fNotification.toArray(new IPostOfficeNotification[0]);
        int i = 0;
        while (i < notification.length) {
            notification[i].postOfficeAdded(poName);
            ++i;
        }
    }

    public void postOfficeRemoved(PostOfficeSpecifier poName) {
        IPostOfficeNotification[] notification = this.fNotification.toArray(new IPostOfficeNotification[0]);
        int i = 0;
        while (i < notification.length) {
            notification[i].postOfficeRemoved(poName);
            ++i;
        }
    }

    public boolean isConnectedPO(PostOfficeSpecifier spec) {
        return this.fPostOfficeHub.isConnectedPO(spec);
    }

    public final boolean containsMailbox(Address address) {
        return this.getMailboxFromAddress(address) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Mailbox getMailboxFromAddress(Address address) {
        IntHashMap intHashMap = this.fMailboxMap;
        synchronized (intHashMap) {
            return (Mailbox)this.fMailboxMap.get(address.getMailboxNumber());
        }
    }

    public Address getCanonicalAddress(Address destination) {
        Mailbox box = this.getMailboxFromAddress(destination);
        if (box == null) {
            return null;
        }
        return box.getAddress();
    }

    void enqueueMessage(AMessage message, Address destination) throws InvalidPostOfficeException {
        if (!destination.getPostOffice().equals(this.fName)) {
            throw new InvalidPostOfficeException(destination, this.fName);
        }
        while (true) {
            try {
                this.fMailMen.execute(new DeliveryItem(message, destination));
            }
            catch (InterruptedException e) {
                if (!this.getFeedbackChannel().isTraceEnabled(sModule)) continue;
                this.getFeedbackChannel().trace(sModule, "PostOffice enqueueMessage: Is PostOffice closed " + this.isClosed(), e);
                if (!this.isClosed()) continue;
                return;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCloseOnWeakReference(Mailbox mailboxToClose, Object proxy) {
        HashMap hashMap = this.fMailboxCloseMap;
        synchronized (hashMap) {
            this.fMailboxCloseMap.put(new WeakReference<Object>(proxy, this.fReferenceQueue), mailboxToClose);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllWeaklyReferencedMailboxes() {
        Reference ref;
        while ((ref = this.fReferenceQueue.poll()) != null) {
            Mailbox mailboxToClose;
            HashMap hashMap = this.fMailboxCloseMap;
            synchronized (hashMap) {
                mailboxToClose = (Mailbox)this.fMailboxCloseMap.remove(ref);
            }
            mailboxToClose.close();
        }
    }

    public static RemoteCallerInfo getRemoteCallerInfo() {
        RemoteCallerInfo info = (RemoteCallerInfo)sRemoteCaller.get();
        if (info == null) {
            info = sInternalRemoteCaller;
        }
        return info;
    }

    public static RemoteCallerInfo getInternalCallerInfo() {
        return sInternalRemoteCaller;
    }

    public Executor getOrderedAsyncExecutor() {
        return this.fPostOfficeHub.getAsyncExecutor();
    }

    public Executor getExceptionAsyncExecutor() {
        return this.fPostOfficeHub.getRouteDownExecutor();
    }

    public Executor getUnorderedAsyncExecutor() {
        return this.fMailMen;
    }

    public synchronized int getActiveThreadCount() {
        return this.fActiveDeliveryThreads;
    }

    private class DeliveryItem
    implements Runnable {
        final AMessage fMessage;
        final Address fAddress;

        public DeliveryItem(AMessage message, Address address) {
            this.fMessage = message;
            this.fAddress = address;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block15: {
                try {
                    RemoteCallerInfo origCaller = (RemoteCallerInfo)sRemoteCaller.get();
                    if (origCaller == null) {
                        PostOfficeSpecifier remotePO = this.fMessage.getSourceAddress().getPostOffice();
                        RemoteCallerInfo currentCaller = new RemoteCallerInfo(remotePO, this.fMessage.getRemoteHost());
                        sRemoteCaller.set(currentCaller);
                    }
                    try {
                        MethodCallMessage m;
                        long start = -1L;
                        if (PostOffice.this.messageStatistics != null) {
                            start = MasterClock.currentTimeMillis();
                        }
                        PostOffice.this.deliverInternal(this.fMessage, this.fAddress);
                        if (start == -1L) break block15;
                        String messageKey = this.fMessage.getClass().getName();
                        String messageKeyDetail = null;
                        if (this.fMessage instanceof MethodCallMessage && (m = (MethodCallMessage)this.fMessage).getMethod() != null) {
                            messageKeyDetail = String.valueOf(messageKey) + "|" + m.getMethod().getDeclaringClass().getName();
                        }
                        HashMap hashMap = PostOffice.this.messageStatistics;
                        synchronized (hashMap) {
                            MessageStatistics statistics = null;
                            MessageStatistics statisticsDetail = null;
                            statistics = (MessageStatistics)PostOffice.this.messageStatistics.get(messageKey);
                            if (statistics == null) {
                                statistics = new MessageStatistics();
                                PostOffice.this.messageStatistics.put(messageKey, statistics);
                            }
                            if (messageKeyDetail != null && (statisticsDetail = (MessageStatistics)PostOffice.this.messageStatistics.get(messageKeyDetail)) == null) {
                                statisticsDetail = new MessageStatistics();
                                PostOffice.this.messageStatistics.put(messageKeyDetail, statisticsDetail);
                            }
                            if (statistics != null) {
                                statistics.add(start);
                            }
                            if (statisticsDetail != null) {
                                statisticsDetail.add(start);
                            }
                        }
                    }
                    finally {
                        sRemoteCaller.set(origCaller);
                    }
                }
                catch (Throwable e) {
                    PostOffice.this.getFeedbackChannel().error(sModule, "PostOffice thread caught exception.", e);
                }
            }
        }
    }

    public static class MessageStatistics {
        private long count = 0L;
        private int time = 0;
        private int timeMin = -1;
        private int timeMax = 0;

        public synchronized void add(long start) {
            ++this.count;
            int t = (int)(MasterClock.currentTimeMillis() - start);
            this.time += t;
            this.timeMax = Math.max(this.timeMax, t);
            this.timeMin = this.timeMin < 0 ? t : Math.min(this.timeMin, t);
        }

        public synchronized void reset() {
            this.count = 0L;
            this.time = 0;
            this.timeMin = -1;
            this.timeMax = 0;
        }

        public synchronized MessageStatistics cloneInst() {
            MessageStatistics result = new MessageStatistics();
            result.count = this.count;
            result.time = this.time;
            result.timeMin = this.timeMin;
            result.timeMax = this.timeMax;
            return result;
        }

        public synchronized long getCount() {
            return this.count;
        }

        public synchronized int getART() {
            return (int)(this.count == 0L ? 0L : (long)this.time / this.count);
        }

        public synchronized int getARTMin() {
            return this.timeMin >= 0 ? this.timeMin : 0;
        }

        public synchronized int getARTMax() {
            return this.timeMax;
        }
    }
}

