/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.spec;

import com.wily.rave.spec.IContentChangeEventSummary;
import com.wily.rave.spec.IContentSummary;
import com.wily.rave.spec.IDataSourceInstance;
import com.wily.rave.utils.HashCodeUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;

abstract class AContentChangeEventSummary
implements IContentChangeEventSummary,
Externalizable {
    private long changeDetectionTime;
    private String resourceName;
    private Class resourceType;
    private IDataSourceInstance dataSourceInstance;
    private IContentSummary contentSummary;
    private String resourceOwner;
    private static final long serialVersionUID = 1L;

    public AContentChangeEventSummary() {
    }

    AContentChangeEventSummary(long changeDetectionTime, String resourceName, Class resourceType, String resourceOwner, IDataSourceInstance dataSourceInstance, IContentSummary contentSummary) {
        this.changeDetectionTime = changeDetectionTime;
        this.resourceName = resourceName;
        this.resourceType = resourceType;
        this.resourceOwner = resourceOwner;
        this.dataSourceInstance = dataSourceInstance;
        this.contentSummary = contentSummary;
    }

    @Override
    public void writeExternal(ObjectOutput oo) throws IOException {
        oo.writeLong(this.changeDetectionTime);
        oo.writeUTF(this.resourceName);
        oo.writeObject(this.resourceType);
        oo.writeObject("AContentChangeEventSummary_8.0");
        oo.writeObject(this.resourceOwner);
        oo.writeObject(this.dataSourceInstance);
        oo.writeObject(this.contentSummary);
    }

    @Override
    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        this.changeDetectionTime = oi.readLong();
        this.resourceName = oi.readUTF();
        this.resourceType = (Class)oi.readObject();
        Object ownerOrDSInst = oi.readObject();
        if (ownerOrDSInst instanceof String) {
            this.resourceOwner = (String)oi.readObject();
            this.dataSourceInstance = (IDataSourceInstance)oi.readObject();
        } else {
            this.resourceOwner = "";
            this.dataSourceInstance = (IDataSourceInstance)ownerOrDSInst;
        }
        this.contentSummary = (IContentSummary)oi.readObject();
    }

    @Override
    public long getDetectionTimestamp() {
        return this.changeDetectionTime;
    }

    @Override
    public boolean isChangeTimestampAvailable() {
        if (this.isDeletionEvent()) {
            return false;
        }
        return this.contentSummary.getChangeTimestamp() != -1L;
    }

    @Override
    public long getChangeTimestamp() {
        long timestamp;
        if (!this.isDeletionEvent() && (timestamp = this.contentSummary.getChangeTimestamp()) != -1L) {
            return timestamp;
        }
        return this.changeDetectionTime;
    }

    @Override
    public IContentSummary getContentSummary() {
        return this.contentSummary;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public Class getResourceType() {
        return this.resourceType;
    }

    @Override
    public String getResourceOwner() {
        return this.resourceOwner;
    }

    @Override
    public IDataSourceInstance getDataSourceInstance() {
        return this.dataSourceInstance;
    }

    public boolean equals(Object other) {
        if (other.getClass() == this.getClass()) {
            AContentChangeEventSummary otherContentChangeEventSummary = (AContentChangeEventSummary)other;
            if (otherContentChangeEventSummary.resourceName.equals(this.resourceName) && otherContentChangeEventSummary.changeDetectionTime == this.changeDetectionTime && otherContentChangeEventSummary.dataSourceInstance.equals(this.dataSourceInstance) && (otherContentChangeEventSummary.contentSummary == this.contentSummary || otherContentChangeEventSummary.contentSummary != null && otherContentChangeEventSummary.contentSummary.equals(this.contentSummary))) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int code = HashCodeUtils.accumulateHashCode(this.resourceName.hashCode(), this.dataSourceInstance);
        code = HashCodeUtils.accumulateHashCode(code, this.resourceType.hashCode());
        code = HashCodeUtils.accumulateHashCode(code, this.changeDetectionTime);
        return code;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public boolean isDeletionEvent() {
        return false;
    }

    @Override
    public boolean isModificationEvent() {
        return false;
    }

    @Override
    public boolean isAdditionEvent() {
        return false;
    }

    public abstract String toString();

    static class ContentAddEventSummary
    extends AContentChangeEventSummary {
        private static final long serialVersionUID = 1L;

        public ContentAddEventSummary() {
        }

        ContentAddEventSummary(long changeDetectionTime, String resourceName, Class resourceType, String resourceOwner, IDataSourceInstance dataSourceInstance, IContentSummary contentSummary) {
            super(changeDetectionTime, resourceName, resourceType, resourceOwner, dataSourceInstance, contentSummary);
        }

        @Override
        public boolean isAdditionEvent() {
            return true;
        }

        @Override
        public String toString() {
            return "Addition of resource " + ((AContentChangeEventSummary)this).resourceName + " / " + ((AContentChangeEventSummary)this).dataSourceInstance + " at " + ((AContentChangeEventSummary)this).changeDetectionTime;
        }

        @Override
        public boolean changeTypeMatches(int changeType) {
            return (changeType & 1) > 0;
        }
    }

    static class ContentDeleteEventSummary
    extends AContentChangeEventSummary {
        private static final long serialVersionUID = 1L;

        public ContentDeleteEventSummary() {
        }

        ContentDeleteEventSummary(long changeDetectionTime, String resourceName, Class resourceType, String resourceOwner, IDataSourceInstance dataSourceInstance) {
            super(changeDetectionTime, resourceName, resourceType, resourceOwner, dataSourceInstance, null);
        }

        @Override
        public boolean isDeletionEvent() {
            return true;
        }

        @Override
        public String toString() {
            return "Deletion of resource " + ((AContentChangeEventSummary)this).resourceName + " / " + ((AContentChangeEventSummary)this).dataSourceInstance + " at " + ((AContentChangeEventSummary)this).changeDetectionTime;
        }

        @Override
        public boolean changeTypeMatches(int changeType) {
            return (changeType & 2) > 0;
        }
    }

    static class ContentModifyEventSummary
    extends AContentChangeEventSummary {
        private static final long serialVersionUID = 1L;

        public ContentModifyEventSummary() {
        }

        ContentModifyEventSummary(long changeDetectionTime, String resourceName, Class resourceType, String resourceOwner, IDataSourceInstance dataSourceInstance, IContentSummary contentSummary) {
            super(changeDetectionTime, resourceName, resourceType, resourceOwner, dataSourceInstance, contentSummary);
        }

        @Override
        public boolean isModificationEvent() {
            return true;
        }

        @Override
        public String toString() {
            return "Modification of resource " + ((AContentChangeEventSummary)this).resourceName + " / " + ((AContentChangeEventSummary)this).dataSourceInstance + " at " + ((AContentChangeEventSummary)this).changeDetectionTime;
        }

        @Override
        public boolean changeTypeMatches(int changeType) {
            return (changeType & 4) > 0;
        }
    }
}

